/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.fugue.Effect;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.webtests.ztests.timetracking.modern.AbstractWorklogSearchingTest;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.REST, Category.WORKLOGS})
public final class TestWorklogAuthorSearching
extends AbstractWorklogSearchingTest {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-developers");
    }

    public void testEqualsOperator() throws Exception {
        String issueKey1 = this.createDefaultIssue();
        String issueKey2 = this.createDefaultIssue();
        this.createWorklogAsUser(issueKey1, "admin");
        this.createWorklogAsUser(issueKey2, "fred");
        SearchResult searchResult = this.executeJqlSearch("worklogAuthor = fred");
        Assert.assertThat((Object)searchResult, TestWorklogAuthorSearching.sizeEquals(1));
        Assert.assertThat((Object)searchResult, TestWorklogAuthorSearching.containsIssues(issueKey2));
    }

    public void testNotEqualsOperator() throws Exception {
        String issueKey1 = this.createDefaultIssue();
        String issueKey2 = this.createDefaultIssue();
        this.createWorklogAsUser(issueKey1, "admin");
        this.createWorklogAsUser(issueKey2, "fred");
        SearchResult searchResult = this.executeJqlSearch("worklogAuthor != fred");
        Assert.assertThat((Object)searchResult, TestWorklogAuthorSearching.sizeEquals(1));
        Assert.assertThat((Object)searchResult, TestWorklogAuthorSearching.containsIssues(issueKey1));
    }

    public void testInOperator() throws Exception {
        String issueKey1 = this.createDefaultIssue();
        String issueKey2 = this.createDefaultIssue();
        this.createWorklogAsUser(issueKey1, "admin");
        this.createWorklogAsUser(issueKey2, "fred");
        SearchResult searchResult = this.executeJqlSearch("worklogAuthor in (fred, admin)");
        Assert.assertThat((Object)searchResult, TestWorklogAuthorSearching.sizeEquals(2));
        Assert.assertThat((Object)searchResult, TestWorklogAuthorSearching.containsIssues(issueKey1, issueKey2));
    }

    public void testNotInOperator() throws Exception {
        String issueKey1 = this.createDefaultIssue();
        String issueKey2 = this.createDefaultIssue();
        this.createWorklogAsUser(issueKey1, "admin");
        this.createWorklogAsUser(issueKey2, "fred");
        SearchResult searchResult = this.executeJqlSearch("worklogAuthor not in (fred)");
        Assert.assertThat((Object)searchResult, TestWorklogAuthorSearching.sizeEquals(1));
        Assert.assertThat((Object)searchResult, TestWorklogAuthorSearching.containsIssues(issueKey1));
    }

    public void testSearchingWorklogInDeletedIssue() throws Exception {
        String issueKey = this.createDefaultIssue();
        this.createWorklogAsUser(issueKey, "admin");
        MatcherAssert.assertThat((Object)this.executeJqlSearch("worklogAuthor = admin"), TestWorklogAuthorSearching.sizeEquals(1));
        this.issueClient.delete(issueKey, null);
        MatcherAssert.assertThat((Object)this.executeJqlSearch("worklogAuthor = admin"), TestWorklogAuthorSearching.sizeEquals(0));
    }

    public void testAuthorAndDateConditionSimple() throws Exception {
        String issue = this.createDefaultIssue();
        this.createWorklog(issue, "2014-08-10", "admin");
        this.createWorklog(issue, "2014-08-13", "fred");
        SearchResult searchResult = this.executeJqlSearch("worklogDate = 2014-08-10 AND worklogAuthor = admin");
        MatcherAssert.assertThat((Object)searchResult, TestWorklogAuthorSearching.sizeEquals(1));
        MatcherAssert.assertThat((Object)searchResult, TestWorklogAuthorSearching.containsIssues(issue));
        searchResult = this.executeJqlSearch("worklogDate = 2014-08-10 AND worklogAuthor = fred");
        MatcherAssert.assertThat((Object)searchResult, TestWorklogAuthorSearching.sizeEquals(0));
        searchResult = this.executeJqlSearch("worklogDate = 2014-08-13 AND worklogAuthor = admin");
        MatcherAssert.assertThat((Object)searchResult, TestWorklogAuthorSearching.sizeEquals(0));
    }

    public void testAuthorAndDateCondition() throws Exception {
        final String issueWithWorklogsOn10thAnd13th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogsOn10thAnd13th, "2014-08-10", "admin");
        this.createWorklog(issueWithWorklogsOn10thAnd13th, "2014-08-13", "fred");
        String issueWithWorklogOn9thAnd14th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogOn9thAnd14th, "2014-08-09", "fred");
        this.createWorklog(issueWithWorklogOn9thAnd14th, "2014-08-14", "admin");
        Effect<String> testFirstIssueReturnedForQuery = new Effect<String>(){

            public void apply(String query) {
                SearchResult searchResult = TestWorklogAuthorSearching.this.executeJqlSearchAsUser(query, "admin");
                MatcherAssert.assertThat((Object)searchResult, AbstractWorklogSearchingTest.sizeEquals(1));
                MatcherAssert.assertThat((Object)searchResult, AbstractWorklogSearchingTest.containsIssues(issueWithWorklogsOn10thAnd13th));
            }
        };
        testFirstIssueReturnedForQuery.apply((Object)"worklogDate < 2014-08-11 AND worklogAuthor = admin");
        testFirstIssueReturnedForQuery.apply((Object)"worklogDate < 2014-08-11 AND worklogAuthor = currentUser()");
        testFirstIssueReturnedForQuery.apply((Object)"worklogDate < 2014-08-11 AND worklogAuthor = echo('admin')");
        testFirstIssueReturnedForQuery.apply((Object)"worklogDate = 2014-08-10 AND worklogAuthor = admin");
        testFirstIssueReturnedForQuery.apply((Object)"worklogDate > 2014-08-09 AND worklogDate < 2014-08-11 AND worklogAuthor = admin");
        testFirstIssueReturnedForQuery.apply((Object)"worklogDate < 2014-08-11 AND project = HSP AND worklogAuthor = admin");
        testFirstIssueReturnedForQuery.apply((Object)"project = HSP AND (worklogDate < 2014-08-11 AND worklogAuthor = admin)");
        testFirstIssueReturnedForQuery.apply((Object)"worklogDate = 2014-08-10 AND worklogAuthor = admin OR (project = HSP AND (worklogDate < 2014-08-11 AND worklogAuthor = admin))");
    }

    public void testOrConditions() throws Exception {
        final String issueWithWorklogsOn10thAnd13th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogsOn10thAnd13th, "2014-08-10", "admin");
        this.createWorklog(issueWithWorklogsOn10thAnd13th, "2014-08-13", "fred");
        final String issueWithWorklogOn9thAnd14th = this.createDefaultIssue();
        this.createWorklog(issueWithWorklogOn9thAnd14th, "2014-08-09", "fred");
        this.createWorklog(issueWithWorklogOn9thAnd14th, "2014-08-14", "admin");
        Effect<String> testBothIssuesReturnedForQuery = new Effect<String>(){

            public void apply(String query) {
                SearchResult searchResult = TestWorklogAuthorSearching.this.executeJqlSearchAsUser(query, "admin");
                MatcherAssert.assertThat((Object)searchResult, AbstractWorklogSearchingTest.sizeEquals(2));
                MatcherAssert.assertThat((Object)searchResult, AbstractWorklogSearchingTest.containsIssues(issueWithWorklogsOn10thAnd13th, issueWithWorklogOn9thAnd14th));
            }
        };
        testBothIssuesReturnedForQuery.apply((Object)"worklogDate < 2014-08-11 OR worklogAuthor = fred");
        testBothIssuesReturnedForQuery.apply((Object)"worklogAuthor = admin OR worklogAuthor = fred");
        testBothIssuesReturnedForQuery.apply((Object)"worklogAuthor = admin AND worklogDate = 2014-08-10 OR worklogAuthor = fred AND worklogDate = 2014-08-09");
    }
}

