/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.SearchClient;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.RestFuncTest;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.meterware.httpunit.WebResponse;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

abstract class AbstractWorklogSearchingTest
extends RestFuncTest {
    protected static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final long DEFAULT_PERMISSION_SCHEME_ID = 0L;
    protected final String defaultStartDate = "2014-08-06";
    protected WorklogClient worklogClient;
    protected IssueClient issueClient;
    protected final DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");

    AbstractWorklogSearchingTest() {
    }

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.backdoor.applicationProperties().setOption("jira.default.timezone", true);
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_OWN_WORKLOGS, "jira-users");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.DELETE_OWN_WORKLOGS, "jira-users");
        this.worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
    }

    protected Worklog createWorklog(String issueKey, String date) {
        return this.createWorklog(issueKey, date, "admin");
    }

    protected Worklog createWorklog(String issueKey, String date, String userName) {
        return this.createWorklog(issueKey, this.dateTimeFormatter.parseDateTime(date), userName);
    }

    protected Worklog createWorklogAsUser(String issueKey, String userName) {
        return this.createWorklog(issueKey, DateTime.now(), userName);
    }

    private Worklog createWorklog(String issueKey, DateTime date, String userName) {
        Worklog worklog = new Worklog();
        worklog.started = new SimpleDateFormat(TIME_FORMAT).format(date.toDate());
        worklog.timeSpent = "1h";
        return (Worklog)((WorklogClient)this.worklogClient.loginAs((String)userName)).post((String)issueKey, (Worklog)worklog).body;
    }

    protected String getDateFromString(String date) {
        DateTime dateTime = this.dateTimeFormatter.parseDateTime(date);
        return new SimpleDateFormat(TIME_FORMAT).format(dateTime.toDate());
    }

    protected String createDefaultIssue() {
        return this.backdoor.issues().createIssue((String)"HSP", (String)"test issue!", (String)"admin").key;
    }

    protected SearchResult executeEqualWorklogDateSearch(String date) {
        return ((SearchClient)this.backdoor.search().loginAs("fred", "fred")).getSearch(new SearchRequest().jql("worklogDate=" + date));
    }

    protected SearchResult executeEqualWorklogDateSearchAsUser(String date, String user) {
        return ((SearchClient)this.backdoor.search().loginAs(user, user)).getSearch(new SearchRequest().jql("worklogDate=" + date));
    }

    protected SearchResult executeJqlSearch(String query) {
        return this.executeJqlSearchAsUser(query, "fred");
    }

    protected SearchResult executeJqlSearchAsUser(String query, String user) {
        return ((SearchClient)this.backdoor.search().loginAs(user)).getSearch(new SearchRequest().jql(query));
    }

    protected int getResponseCode(String jql) throws Exception {
        WebResponse webResponse2 = this.GET("/rest/api/2/search?jql=" + jql);
        return webResponse2.getResponseCode();
    }

    protected static Matcher<SearchResult> containsIssues(final String ... issueKeys) {
        return new TypeSafeMatcher<SearchResult>(){

            protected boolean matchesSafely(SearchResult searchResult) {
                return Iterables.any((Iterable)searchResult.issues, (Predicate)new Predicate<Issue>(){

                    public boolean apply(Issue issue) {
                        return Lists.newArrayList((Object[])issueKeys).contains(issue.key);
                    }
                });
            }

            public void describeTo(Description description) {
                description.appendText("Search result containing issue keys ").appendValue((Object)Arrays.toString(issueKeys));
            }
        };
    }

    protected static Matcher<SearchResult> sizeEquals(final int size) {
        return new TypeSafeMatcher<SearchResult>(){

            protected boolean matchesSafely(SearchResult searchResult) {
                return searchResult.total == size;
            }

            public void describeTo(Description description) {
                description.appendText("Search results of size ").appendValue((Object)size);
            }
        };
    }
}

