/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING, Category.WORKLOGS})
public class TestWorkLogOperationVisibility
extends FuncTestCase {
    private static final String BUG = "HSP-1";
    private static final String NEW_FEATURE = "HSP-2";

    public TestWorkLogOperationVisibility(String name) {
        this.setName(name);
    }

    @Override
    public void setUpTest() {
        this.administration.restoreData("TestWorkLogVisibility.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    public void testWorkLogOperationVisibility() throws Exception {
        this.navigation.issue().viewIssue(BUG);
        this.assertLogWorkOperationPresent();
        this.navigation.issue().viewIssue(NEW_FEATURE);
        this.assertLogWorkOperationNotPresent();
        this.flipVisibilityInFieldConfigEnterprise();
        this.navigation.issue().viewIssue(BUG);
        this.assertLogWorkOperationNotPresent();
        this.navigation.issue().viewIssue(NEW_FEATURE);
        this.assertLogWorkOperationPresent();
    }

    public void testCreateWorkActionVisibility() throws Exception {
        this.navigation.issue().viewIssue(BUG);
        this.assertLogWorkOperationPresent();
        this.getTester().clickLink("log-work");
        this.assertWorkLogFormPresent();
        this.getTester().gotoPage("/secure/CreateWorklog!default.jspa?id=10010");
        this.assertWorkLogFormNotPresent();
        this.getTester().gotoPage(this.page.addXsrfToken("/secure/CreateWorklog.jspa?id=10010&timeLogged=1h&startDate=26/Sep/07%2005:41%20PM"));
        this.assertWorkLogFormNotPresent();
        this.flipVisibilityInFieldConfigEnterprise();
        this.getTester().gotoPage("/secure/CreateWorklog!default.jspa?id=10000");
        this.assertWorkLogFormNotPresent();
        this.getTester().gotoPage(this.page.addXsrfToken("/secure/CreateWorklog.jspa?id=10000&timeLogged=1h&startDate=26/Sep/07%2005:41%20PM"));
        this.assertWorkLogFormNotPresent();
        this.navigation.issue().viewIssue(NEW_FEATURE);
        this.assertLogWorkOperationPresent();
        this.getTester().clickLink("log-work");
        this.assertWorkLogFormPresent();
    }

    private void flipVisibilityInFieldConfigEnterprise() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.getTester().clickLink("configure-Default Field Configuration");
        this.getTester().clickLink("show_18");
        this.getTester().clickLink("view_fieldlayouts");
        this.getTester().clickLink("configure-Bug Field Configuration");
        this.getTester().clickLink("hide_18");
    }

    private void assertWorkLogFormPresent() {
        this.text.assertTextPresent("Log Work");
        this.text.assertTextNotPresent("Access Denied");
        this.text.assertTextNotPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    private void assertWorkLogFormNotPresent() {
        this.text.assertTextNotPresent("This form allows you to log work that you have done on this issue.");
        this.text.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    private void assertLogWorkOperationNotPresent() {
        this.getTester().assertLinkNotPresent("log-work");
        this.getTester().assertLinkNotPresentWithText("Log work");
    }

    private void assertLogWorkOperationPresent() {
        this.getTester().assertLinkPresent("log-work");
        this.getTester().assertLinkPresentWithText("Log work");
    }
}

