/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebResponseUtil;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.REPORTS, Category.TIME_TRACKING})
public class TestTimeTrackingExcelReport
extends JIRAWebTest {
    private static String EXCEL_REPORT_URL = "/secure/ConfigureReport!excelView.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:time-tracking&Next=Next&versionId=10001&sortingOrder=least&completedFilter=all";

    public TestTimeTrackingExcelReport(String name) {
        super(name);
    }

    public void testTimeTrackingExcelReport() throws SAXException {
        this.restoreData("TestTimeTrackingReport.xml");
        this.gotoPage("/secure/ConfigureReport!excelView.jspa?Next=Next&versionId=-1&reportKey=com.atlassian.jira.plugin.system.reports:time-tracking&sortingOrder=least&selectedProjectId=10000&completedFilter=all");
        if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
            TestTimeTrackingExcelReport.fail((String)"Failed to replace response content type with 'text/html'");
        }
        WebTable reportTable = this.getDialog().getResponse().getTableWithID("time_tracking_report_table");
        this.assertTableRowEquals(reportTable, 3, new Object[]{"Bug", "HSP-1", "Open", "Major", "massive bug", "14400", "8370", "6030", "0"});
        this.assertTableRowEquals(reportTable, 4, new Object[]{"Bug", "HSP-2", "Open", "Major", "bug2", "1440", "1230", "210", "0"});
        this.assertTableRowEquals(reportTable, 5, new Object[]{"", "", "", "", "Total", "15840", "9600", "6240", "0", "0"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInternationalizationOfExcelReport() {
        this.restoreData("TestTimeTrackingExcelReport.xml");
        this.activateTimeTracking();
        try {
            if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
                TestTimeTrackingExcelReport.log("Failed to replace response content type with 'text/html'");
                TestTimeTrackingExcelReport.fail();
            } else {
                this.gotoPage(EXCEL_REPORT_URL);
                this.assertTextPresent("In Progress");
                this.assertTextPresent("Open");
            }
        }
        catch (Exception e) {
            TestTimeTrackingExcelReport.log("Failed to parse the printable view", e);
            TestTimeTrackingExcelReport.fail();
        }
        this.gotoPage("/secure/Dashboard.jspa");
        this.setLocaleTo("Deutsch (Deutschland)");
        try {
            if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
                TestTimeTrackingExcelReport.log("Failed to replace response content type with 'text/html'");
                TestTimeTrackingExcelReport.fail();
            } else {
                this.gotoPage(EXCEL_REPORT_URL);
                this.assertTextPresent(this.getBackdoor().i18n().getText("jira.translation.status.inprogress.name", "de_DE"));
                this.assertTextPresent(this.getBackdoor().i18n().getText("jira.translation.status.open.name", "de_DE"));
            }
        }
        catch (Exception e) {
            TestTimeTrackingExcelReport.log("Failed to parse the printable view", e);
            TestTimeTrackingExcelReport.fail();
        }
        finally {
            this.gotoPage("/secure/Dashboard.jspa");
            this.navigation.userProfile().changeUserLanguageToJiraDefault();
        }
    }

    public void testExcelReportResponseCanBeCached() throws SAXException {
        this.restoreData("TestTimeTrackingReport.xml");
        this.gotoPage("/secure/ConfigureReport!excelView.jspa?Next=Next&versionId=-1&reportKey=com.atlassian.jira.plugin.system.reports:time-tracking&sortingOrder=least&selectedProjectId=10000&completedFilter=all");
        if (!WebResponseUtil.replaceResponseContentType(this.getDialog().getResponse(), "text/html")) {
            TestTimeTrackingExcelReport.fail((String)"Failed to replace response content type with 'text/html'");
        }
        this.assertResponseCanBeCached();
    }

    private void setLocaleTo(String localeName) {
        this.navigation.userProfile().changeUserLanguage(localeName);
    }
}

