/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import java.util.Arrays;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.TIME_TRACKING})
public class TestTimeTrackingAggregates
extends JIRAWebTest {
    public TestTimeTrackingAggregates(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestTimeTrackingAggregates.xml");
    }

    public void testAllTest() throws SAXException {
        this._testNoValues();
        this._testNoOrigValue();
        this._testNoTimeSpent();
        this._testAllValuesTotalGreaterThanOrigNoSubs();
        this._testNoValuesWithSubstasks();
        this._testWithNoValueSubTaskAsStartingPoint();
        this._testWithValuesWithSubstasksWithValues();
        this._testWithRemainingZeroValue();
        this._testPermissionedSubtasks();
        this._testCantSeeSubTasks();
    }

    public void testTimeTrackingDisabled() {
        this.deactivateTimeTracking();
        this.gotoIssue("HSP-1");
        this.assertHeadingNotPresent();
        this.assertTextNotPresent("Estimated:");
        this.assertTextNotPresent("subtasks_resolution_percentage");
        this.gotoIssue("HSP-6");
        this.assertHeadingNotPresent();
        this.assertTextNotPresent("Estimated:");
        this.assertTextPresent("subtasks_resolution_percentage");
    }

    public void testTimeTrackingHidden() {
        this.setHiddenFields("Time Tracking");
        this.gotoIssue("HSP-1");
        this.assertTextNotPresent("tt_single_text_orig");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        this.gotoIssue("HSP-6");
        this.assertTextNotPresent("tt_single_text_orig");
        this.assertTextNotPresent("tt_aggregate_text_orig");
    }

    public void _testNoValues() throws SAXException {
        this.gotoIssue("HSP-2");
        TestTimeTrackingAggregates.assertEquals((int)0, (int)new IdLocator(this.tester, "tt_single_table_info").getNodes().length);
    }

    public void _testNoOrigValue() throws SAXException {
        this.gotoIssue("HSP-3");
        this.assertHeadingPresent();
        this.assertTextNotPresent("tt_aggregate_text_orig");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "Not Specified", "Remaining", "2d", "Logged:", "2d");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:50%");
    }

    public void _testNoTimeSpent() throws SAXException {
        this.gotoIssue("HSP-4");
        this.assertHeadingPresent();
        this.assertTextNotPresent("tt_aggregate_text_orig");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "3d", "Remaining", "3d", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
    }

    public void _testAllValuesTotalGreaterThanOrigNoSubs() throws SAXException {
        this.gotoIssue("HSP-5");
        this.assertHeadingPresent();
        this.assertTextNotPresent("tt_aggregate_text_orig");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "1w 1d", "Remaining", "4d", "Logged:", "4d");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:75%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:25%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:50%");
    }

    public void _testNoValuesWithSubstasks() throws SAXException {
        this.gotoIssue("HSP-6");
        TestTimeTrackingAggregates.assertEquals((int)0, (int)new IdLocator(this.tester, "tt_single_table_info").getNodes().length);
        TestTimeTrackingAggregates.assertEquals((int)0, (int)new IdLocator(this.tester, "tt_aggregate_table_info").getNodes().length);
        this.assertHeadingNotPresent();
        this.assertTextNotPresent("subtasks_resolution_percentage");
    }

    public void _testWithNoValueSubTaskAsStartingPoint() throws SAXException {
        this.gotoIssue("HSP-7");
        this.assertHeadingNotPresent();
        TestTimeTrackingAggregates.assertEquals((int)0, (int)new IdLocator(this.tester, "tt_single_table_info").getNodes().length);
    }

    public void _testWithValuesWithSubstasksWithNoValues() throws SAXException {
        this.gotoIssue("HSP-9");
        this.assertHeadingPresent();
        this.assertTextPresent("tt_aggregate_text_orig");
        this.assertTextPresent("Issue & Sub-Tasks");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "3d", "Remaining", "3d", "Logged:", "1d");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 0, "width:75%");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 1, "width:25%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 0, "width:25%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 1, "width:75%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 0, "width:25%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 1, "width:75%");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "Not Specified", "Remaining", "Not Specified", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_percent_HSP-10"), "50%");
        this.assertGraphContainerAttribute("tt_graph_inner_HSP-10", "width:100%");
        this.assertGraphElementAttribute("tt_graph_orig_HSP-10", 0, "width:50%");
        this.assertGraphElementAttribute("tt_graph_orig_HSP-10", 1, "width:50%");
        this.assertGraphElementAttribute("tt_graph_progress_HSP-10", 0, "width:50%");
        this.assertGraphElementAttribute("tt_graph_progress_HSP-10", 2, "width:50%");
        this.text.assertTextNotPresent(new IdLocator(this.tester, "tt_percent_HSP-11"), "%");
        this.assertGraphContainerAttribute("tt_graph_inner_HSP-11", "width:100%");
        this.assertGraphElementAttribute("tt_graph_orig_HSP-11", 0, "width:100%");
        this.assertGraphElementAttribute("tt_graph_progress_HSP-11", 0, "width:100%");
    }

    public void _testWithAllValueSubTaskAsStartingPoint() throws SAXException {
        this.gotoIssue("HSP-10");
        this.assertHeadingPresent();
        this.assertTextNotPresent("tt_aggregate_text_orig");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "1d", "Remaining", "1d", "Logged:", "1d");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:50%");
    }

    public void _testWithValuesWithSubstasksWithValues() throws SAXException {
        this.gotoIssue("HSP-12");
        this.assertHeadingPresent();
        this.assertTextPresent("tt_aggregate_text_orig");
        this.assertTextPresent("Include sub-tasks");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_aggregate_table_info"), "Estimated", "1w 1d", "Remaining", "4d", "Logged", "1w");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 0, "width:66%");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 1, "width:34%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 0, "width:55%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 1, "width:45%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 0, "width:55%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 1, "width:45%");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "4d", "Remaining", "4d", "Logged:", "1d");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:80%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:20%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:20%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:80%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:20%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:80%");
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_dpb_percent_HSP-13"), "100%");
        this.assertGraphContainerAttribute("tt_dpb_graph_inner_HSP-13", "width:100%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-13", 0, "width:57%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-13", 1, "width:43%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-13", 0, "width:100%");
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_dpb_percent_HSP-14"), "100%");
        this.assertGraphContainerAttribute("tt_dpb_graph_inner_HSP-14", "width:14%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-14", 0, "width:0%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-14", 0, "width:100%");
    }

    public void _testWithRemainingZeroValue() throws SAXException {
        this.gotoIssue("HSP-13");
        this.assertHeadingPresent();
        this.assertTextNotPresent("tt_aggregate_text_orig");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "2d", "Remaining", "0m", "Logged:", "3d 4h");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:57%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:43%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
    }

    public void _testPermissionedSubtasks() throws SAXException {
        this.login("fred", "fred");
        this.gotoIssue("HSP-15");
        this.assertHeadingPresent();
        this.assertTextPresent("tt_aggregate_text_orig");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "2d", "Remaining", "2d", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_aggregate_table_info"), "Estimated", "3d 2h", "Remaining", "3d 2h", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.login("admin", "admin");
        this.gotoIssue("HSP-15");
        this.assertHeadingPresent();
        this.assertTextPresent("tt_aggregate_text_orig");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "2d", "Remaining", "2d", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_aggregate_table_info"), "Estimated", "4d", "Remaining", "4d", "Logged:", "1d");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 0, "width:80%");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 1, "width:20%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 0, "width:20%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 1, "width:80%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 0, "width:20%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 1, "width:80%");
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_dpb_percent_HSP-16"), "33%");
        this.assertGraphContainerAttribute("tt_dpb_graph_inner_HSP-16", "width:100%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 0, "width:66%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 1, "width:34%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 0, "width:33%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 2, "width:67%");
        this.assertElementNotPresent("tt_dpb_graph_outer_HSP-17");
        this.assertElementNotPresent("tt_dpb_percent_HSP-17");
        this.assertElementNotPresent("tt_dpb_graph_inner_HSP-17");
        this.assertTextNotPresent("tt_dpb_graph_orig_HSP-17_empty_cell");
        this.assertTextNotPresent("tt_dpb_graph_progress_HSP-17_empty_cell");
        this.assertTextNotPresent("tt_dpb_graph_orig_HSP-18");
    }

    public void _testCantSeeSubTasks() throws SAXException {
        this.gotoIssue("HSP-19");
        this.assertHeadingPresent();
        this.assertTextNotPresent("tt_aggregate_text_orig");
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated", "1d", "Remaining", "1d", "Logged:", "Not Specified");
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
    }

    public void testProgressNavigableField() throws SAXException {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.displayAllIssues();
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_dpb_percent_HSP-16"), "33%");
        this.assertGraphContainerAttribute("tt_dpb_graph_inner_HSP-16", "width:100%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 0, "width:66%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 1, "width:34%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 0, "width:33%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 2, "width:67%");
        this.assertElementNotPresent("tt_dpb_graph_outer_HSP-17");
        this.assertElementNotPresent("tt_dpb_percent_HSP-17_");
        this.assertElementNotPresent("tt_dpb_graph_inner_HSP-17");
        this.assertTextNotPresent("tt_dpb_graph_orig_HSP-17_empty_cell");
        this.assertTextNotPresent("tt_dpb_graph_progress_HSP-17_empty_cell");
    }

    public void testAggregateProgressBar() throws SAXException {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertTextNotPresent("\u03a3 Estimated");
        this.backdoor.columnControl().addLoggedInUserColumns(Arrays.asList("aggregateprogress"));
        this.navigation.issueNavigator().displayAllIssues();
        this.assertTextPresent(" Progress");
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_apb_percent_HSP-19"), "0%");
        this.assertGraphContainerAttribute("tt_apb_graph_inner_HSP-19", "width:100%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-19", 0, "width:100%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-19", 0, "width:100%");
        this.assertElementNotPresent("tt_apb_graph_outer_HSP-17");
        this.assertElementNotPresent("tt_apb_percent_HSP-17_");
        this.assertElementNotPresent("tt_apb_graph_inner_HSP-17");
        this.assertTextNotPresent("tt_apb_graph_orig_HSP-17_empty_cell");
        this.assertTextNotPresent("tt_apb_graph_progress_HSP-17_empty_cell");
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_apb_percent_HSP-16"), "33%");
        this.assertGraphContainerAttribute("tt_apb_graph_inner_HSP-16", "width:100%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-16", 0, "width:66%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-16", 1, "width:34%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-16", 0, "width:33%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-16", 2, "width:67%");
        this.text.assertTextPresent(new IdLocator(this.tester, "tt_apb_percent_HSP-12"), "55%");
        this.assertGraphContainerAttribute("tt_apb_graph_inner_HSP-12", "width:100%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-12", 0, "width:66%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-12", 1, "width:34%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-12", 0, "width:55%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-12", 2, "width:45%");
    }

    private void assertHeadingPresent() {
        this.text.assertTextPresent(new XPathLocator(this.tester, "//h2"), "Time Tracking");
    }

    private void assertHeadingNotPresent() {
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//h2"), "Time Tracking");
    }

    private void assertGraphElementAttribute(String tableName, int col, String attribute) throws SAXException {
        WebTable table = this.getDialog().getResponse().getTableWithID(tableName);
        String style = table.getTableCell(0, col).getDOM().getAttributes().getNamedItem("style").getNodeValue();
        TestTimeTrackingAggregates.assertTrue((style.indexOf(attribute) != -1 ? 1 : 0) != 0);
    }

    private void assertGraphContainerAttribute(String tableId, String attributeValue) throws SAXException {
        String actualStyle = this.tester.getDialog().getElement(tableId).getAttribute("style");
        TestTimeTrackingAggregates.assertTrue((boolean)actualStyle.contains(attributeValue));
    }
}

