/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.TIME_TRACKING})
public class TestWorklogNotifications
extends EmailFuncTestCase {
    public static final String EMAIL_ADDRESS = "admin@example.com";
    public static final String EMAIL_ADDRESS_USER_LISTENING_TO_ISSUE_UPDATED = "fred@example.com";
    public static final String TEXT_ON_WORKLOG_ADDED_MAIL = "added a worklog";
    public static final String TEXT_ON_WORKLOG_UPDATED_MAIL = "updated a worklog";
    public static final String TEXT_ON_WORKLOG_DELETED_MAIL = "deleted a worklog";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestWorklogNotificationsIncludingUserThatListensToIssueUpdated.xml");
        this.configureAndStartSmtpServer();
    }

    public void testAddingNewWorkLogSendsEmail() throws Exception {
        this.logSomeWork("TEST-1");
        this.assertOneEmailWasSent(EMAIL_ADDRESS, TEXT_ON_WORKLOG_ADDED_MAIL);
    }

    public void testUpdatingWorkLogSendsEmail() throws Exception {
        this.updateWork("TEST-1");
        this.assertOneEmailWasSent(EMAIL_ADDRESS, TEXT_ON_WORKLOG_UPDATED_MAIL);
    }

    public void testDeletingWorklogSendsEmail() throws Exception {
        this.deleteWork("TEST-1");
        this.assertOneEmailWasSent(EMAIL_ADDRESS, TEXT_ON_WORKLOG_DELETED_MAIL);
    }

    public void testUsersWhoOnlyListenToIssueUpdatedEventsDoNotReceiveAnyEmailsWhenLoggingWork() throws Exception {
        this.logSomeWork("TEST-1");
        this.assertNoEmailsWereSentTo(EMAIL_ADDRESS_USER_LISTENING_TO_ISSUE_UPDATED);
    }

    public void testUsersWhoOnlyListenToIssueUpdatedEventsDoNotReceiveAnyEmailsWhenUpdatingWork() throws Exception {
        this.updateWork("TEST-1");
        this.assertNoEmailsWereSentTo(EMAIL_ADDRESS_USER_LISTENING_TO_ISSUE_UPDATED);
    }

    public void testUsersWhoOnlyListenToIssueUpdatedEventsDoNotReceiveAnyEmailsWhenDeletingWork() throws Exception {
        this.deleteWork("TEST-1");
        this.assertNoEmailsWereSentTo(EMAIL_ADDRESS_USER_LISTENING_TO_ISSUE_UPDATED);
    }

    private void logSomeWork(String issueKey) {
        this.navigation.issue().logWork(issueKey, "1h");
    }

    private void updateWork(String issueKey) {
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.tester.clickLink("edit_worklog_10000");
        this.tester.submit("Log");
    }

    private void deleteWork(String issueKey) {
        this.tester.beginAt("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.tester.clickLink("delete_worklog_10000");
        this.tester.submit("Delete");
    }

    private void assertOneEmailWasSent(String emailAddress, String expectedText) throws Exception {
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient(emailAddress);
        Assert.assertThat((Object)messagesForRecipient.size(), (Matcher)Matchers.is((Object)1));
        this.assertEmailBodyContains(messagesForRecipient.get(0), expectedText);
    }

    private void assertNoEmailsWereSentTo(String emailAddress) throws Exception {
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient(emailAddress);
        Assert.assertThat((Object)messagesForRecipient.size(), (Matcher)Matchers.is((Object)0));
    }
}

