/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SECURITY, Category.SUB_TASKS})
public class TestSubTaskToIssueConversionSecurityLevel
extends JIRAWebTest {
    private static final String SUB_SL_REQ_NO_VAL = "HSP-8";
    private static final String PARENT_NO_VAL = "HSP-7";
    private static final String SUB_SL_REQ_HAS_VAL = "HSP-6";
    private static final String SUB_SL_HIDDEN = "HSP-9";

    public TestSubTaskToIssueConversionSecurityLevel(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestSubTaskToIssueConversionSecurityLevel.xml");
    }

    public void testSubTaskToIssueConversionSecurityLevelNoValToOptional() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertTextPresent(SUB_SL_REQ_NO_VAL);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertTextNotPresent("Security Level:");
        this.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Bug", "issuetype");
        this.submit("Next >>");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextNotPresent("Security Level");
        this.submit("Finish");
        this.assertTextNotPresent("Security Level");
        this.assertTextNotPresent(PARENT_NO_VAL);
        this.clickLinkWithText("History");
        this.assertTextSequence(new String[]{"History", PARENT_NO_VAL});
        this.gotoIssue(PARENT_NO_VAL);
        this.assertTableNotPresent(SUB_SL_REQ_NO_VAL);
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertTextPresent(SUB_SL_REQ_NO_VAL);
    }

    public void testSubTaskToIssueConversionSecurityLevelNoValToHidden() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertTextPresent(SUB_SL_REQ_NO_VAL);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertTextNotPresent("Security Level:");
        this.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.submit("Next >>");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextNotPresent("Security Level");
        this.submit("Finish");
        this.assertTextNotPresent("Security Level");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertTextPresent(SUB_SL_REQ_NO_VAL);
    }

    public void testSubTaskToIssueConversionSecurityLevelNoValToRequired() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertTextPresent(SUB_SL_REQ_NO_VAL);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertTextNotPresent("Security Level:");
        this.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.submit("Next >>");
        this.assertTextPresent("Security Level");
        this.assertTextSequence(new String[]{"Security Level", "Developers"});
        this.selectOption("security", "Developers");
        this.submit("Next >>");
        this.assertTextSequence(new String[]{"Security Level", "None", "Developers"});
        this.submit("Finish");
        this.assertTextSequence(new String[]{"Security Level", "Developers"});
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_NO_VAL);
        this.assertTextPresent("Permission violation");
    }

    public void testSubTaskToIssueConversionSecurityLevelValToOptional() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.assertTextPresent("Permission violation");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.assertTextSequence(new String[]{"Security Level", "Developers"});
        this.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.submit("Next >>");
        this.assertTextNotPresent("Security Level");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextNotPresent("Security Level");
        this.submit("Finish");
        this.assertTextSequence(new String[]{"Security Level", "Developers"});
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.assertTextPresent("Permission violation");
    }

    public void testSubTaskToIssueConversionSecurityLevelValToHidden() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.assertTextPresent("Permission violation");
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.assertTextSequence(new String[]{"Security Level", "Developers"});
        this.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.submit("Next >>");
        this.assertTextNotPresent("Security Level");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextSequence(new String[]{"Security Level", "Developers"});
        this.submit("Finish");
        this.assertTextNotPresent("Security Level");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_REQ_HAS_VAL);
        this.assertTextPresent(SUB_SL_REQ_HAS_VAL);
    }

    public void testSubTaskToIssueConversionSecurityLevelHiddenToOptional() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_HIDDEN);
        this.assertTextPresent(SUB_SL_HIDDEN);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(SUB_SL_HIDDEN);
        this.assertTextNotPresent("Security Level");
        this.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Bug", "issuetype");
        this.submit("Next >>");
        this.assertTextNotPresent("Security Level");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextNotPresent("Security Level");
        this.submit("Finish");
        this.assertTextNotPresent("Security Level");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_HIDDEN);
        this.assertTextPresent(SUB_SL_HIDDEN);
    }

    public void testSubTaskToIssueConversionSecurityLevelHiddenToHidden() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_HIDDEN);
        this.assertTextPresent(SUB_SL_HIDDEN);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(SUB_SL_HIDDEN);
        this.assertTextNotPresent("Security Level");
        this.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("New Feature", "issuetype");
        this.submit("Next >>");
        this.assertTextNotPresent("Security Level");
        this.assertTextPresent("All fields will be updated automatically.");
        this.submit("Next >>");
        this.assertTextNotPresent("Security Level");
        this.submit("Finish");
        this.assertTextNotPresent("Security Level");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_HIDDEN);
        this.assertTextPresent(SUB_SL_HIDDEN);
    }

    public void testSubTaskToIssueConversionSecurityLevelHiddenToRequired() {
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_HIDDEN);
        this.assertTextPresent(SUB_SL_HIDDEN);
        this.logout();
        this.login("admin", "admin");
        this.gotoIssue(SUB_SL_HIDDEN);
        this.assertTextNotPresent("Security Level");
        this.clickLink("subtask-to-issue");
        this.navigation.issue().selectIssueType("Improvement", "issuetype");
        this.submit("Next >>");
        this.assertTextPresent("Security Level");
        this.assertTextSequence(new String[]{"Security Level", "Developers"});
        this.selectOption("security", "Developers");
        this.submit("Next >>");
        this.assertTextSequence(new String[]{"Security Level", "None", "Developers"});
        this.submit("Finish");
        this.assertTextSequence(new String[]{"Security Level", "Developers"});
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(SUB_SL_HIDDEN);
        this.assertTextPresent("Permission violation");
    }
}

