/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.Lists;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
public class TestSubTaskProgressBar
extends FuncTestCase {
    public static final int SUBTASK_COUNT = 5;

    public void testSubTaskProgressIsNotStuck() {
        int i;
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().disable();
        this.administration.subtasks().enable();
        String parentIssueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Parent Summary");
        ArrayList childIssueKeys = Lists.newArrayListWithCapacity((int)5);
        for (i = 0; i < 5; ++i) {
            childIssueKeys.add(this.navigation.issue().createSubTask(parentIssueKey, "Sub-task", "Child summary " + i, "Sub Task Desc"));
        }
        for (i = 0; i < 5; ++i) {
            this.navigation.issue().resolveIssue((String)childIssueKeys.get(i), "Fixed", "Resolving the Issue as Fixed. This should increase the progress in parent issue.");
            this.navigation.issue().gotoIssue(parentIssueKey);
            this.assertSubtaskProgressTableStyleCorrect(i);
        }
    }

    private void assertSubtaskProgressTableStyleCorrect(int i) {
        WebTable subtasksResolutionPercentage = this.tester.getDialog().getWebTableBySummaryOrId("subtasks_resolution_percentage");
        TableCell tableCell = subtasksResolutionPercentage.getTableCell(0, 0);
        Node attribute = tableCell.getDOM().getAttributes().getNamedItem("style");
        Assert.assertThat((Object)StringUtils.deleteWhitespace((String)attribute.getNodeValue()), (Matcher)Matchers.is((Object)this.getStyleForSubtask(i)));
    }

    private String getStyleForSubtask(int i) {
        return String.format("width:%d%%;background-color:#51A825", (i + 1) * 20);
    }
}

