/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.SUB_TASKS})
public class TestSecurityLevelOfSubtasks
extends JIRAWebTest {
    public TestSecurityLevelOfSubtasks(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestSecurityLevelOfSubtasks.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    public void testBulkEditWithSubtasksOnly() {
        int rat7Row;
        int rat9Row;
        this.showAllIssues();
        this.bulkChangeIncludeAllPages();
        this.checkCheckbox("bulkedit_10051", "on");
        this.checkCheckbox("bulkedit_10032", "on");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Step 2 of 4: Choose Operation", "Choose the operation you wish to perform on the selected 2 issue(s)."});
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Step 3 of 4: Operation Details", "Choose the bulk action(s) you wish to perform on the selected 2 issue(s)."});
        this.assertTableCellHasText("availableActionsTable", 1, 1, "Change Security Level");
        WebTable webTable = this.getWebTableWithID("availableActionsTable");
        TestSecurityLevelOfSubtasks.assertEquals((String)"The security level of subtasks is inherited from parents.", (String)webTable.getCellAsText(1, 2).trim());
        this.checkCheckbox("actions", "priority");
        this.selectOption("priority", "Minor");
        this.checkCheckbox("actions", "assignee");
        this.selectOption("assignee", "Henry Ford");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Step 4 of 4: Confirmation", "Updated Fields", "Priority", "Minor", "Assignee", "Henry Ford", "The above table summarises the changes you are about to make"});
        webTable = this.getWebTableWithID("issuetable");
        if (webTable.getCellAsText(1, 1).trim().equals("RAT-9")) {
            rat9Row = 1;
            rat7Row = 2;
        } else {
            rat9Row = 2;
            rat7Row = 1;
        }
        TestSecurityLevelOfSubtasks.assertEquals((String)"RAT-9", (String)webTable.getCellAsText(rat9Row, 1).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"Mark", (String)webTable.getCellAsText(rat9Row, 3).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"Level KingRat", (String)webTable.getCellAsText(rat9Row, 11).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"RAT-7", (String)webTable.getCellAsText(rat7Row, 1).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"Henry Ford", (String)webTable.getCellAsText(rat7Row, 3).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"Level Mouse", (String)webTable.getCellAsText(rat7Row, 11).trim());
        this.submit("Confirm");
        this.waitAndReloadBulkOperationProgressPage();
        webTable = this.getWebTableWithID("issuetable");
        TestSecurityLevelOfSubtasks.assertEquals((String)"RAT-9", (String)webTable.getCellAsText(1, 1).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"Henry Ford", (String)webTable.getCellAsText(1, 3).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"Level KingRat", (String)webTable.getCellAsText(1, 11).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"RAT-7", (String)webTable.getCellAsText(3, 1).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"Henry Ford", (String)webTable.getCellAsText(3, 3).trim());
        TestSecurityLevelOfSubtasks.assertEquals((String)"Level Mouse", (String)webTable.getCellAsText(3, 11).trim());
    }

    public void testBulkEditWithStandardIssueAndSubTask() {
        this.showAllIssues();
        this.bulkChangeIncludeAllPages();
        this.checkCheckbox("bulkedit_10032", "on");
        this.checkCheckbox("bulkedit_10050", "on");
        this.submit("Next");
        this.assertCollapsedTextSequence(new String[]{"Step 2 of 4: Choose Operation", "Choose the operation you wish to perform on the selected 2 issue(s)."});
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.assertTextPresent("Change Security Level");
        this.checkCheckbox("actions", "security");
        this.selectOption("security", "None");
        this.submit("Next");
        this.assertTextPresent("Step 4 of 4: Confirmation");
        this.assertTextPresent("Updated Fields");
        this.assertTextPresent("None");
        this.assertTextPresent("The above table summarises the changes you are about to make to the following <strong>2</strong> issues. Do you wish to continue?");
        this.submit("Confirm");
        this.waitAndReloadBulkOperationProgressPage();
        WebTable issueTable = this.getWebTableWithID("issuetable");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-9");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(2, 11).trim());
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-7");
        this.assertTableCellHasText("issuetable", 3, 2, "RAT-5");
        TestSecurityLevelOfSubtasks.assertEquals((String)"Level Mouse", (String)issueTable.getCellAsText(3, 11).trim());
    }

    public void testEditParentIssue() {
        this.showAllIssues();
        this.clickLinkWithText("RAT-8");
        this.assertTextPresent("A top level task.");
        this.clickLink("edit-issue");
        this.assertTextPresent("Edit Issue");
        this.selectOption("security", "None");
        this.submit("Update");
        this.navigation.issue().returnToSearch();
        WebTable issueTable = this.getWebTableWithID("issuetable");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-9");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(2, 11).trim());
        this.clickLinkWithText("RAT-8");
        this.assertTextPresent("A top level task.");
        this.clickLink("edit-issue");
        this.assertTextPresent("Edit Issue");
        this.selectOption("security", "Level KingRat");
        this.submit("Update");
        this.navigation.issue().returnToSearch();
        issueTable = this.getWebTableWithID("issuetable");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-9");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"Level KingRat", (String)issueTable.getCellAsText(1, 11).trim());
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"Level KingRat", (String)issueTable.getCellAsText(2, 11).trim());
    }

    public void testWorkflowTransitionParentIssue() {
        this.showAllIssues();
        this.clickLinkWithText("RAT-8");
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.assertTextPresent("Resolve Issue");
        this.assertTextPresent("Resolving an issue indicates that the developers are satisfied the issue is finished.");
        this.selectOption("security", "None");
        this.submit("Transition");
        this.assertTextNotPresent("Security Level");
        this.navigation.issue().returnToSearch();
        WebTable issueTable = this.getWebTableWithID("issuetable");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-9");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(1, 11).trim());
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"", (String)issueTable.getCellAsText(2, 11).trim());
    }

    public void testWorkflowTransitionSubtask() {
        this.showAllIssues();
        this.clickLinkWithText("RAT-9");
        this.assertTextPresent("Security Level:");
        this.assertTextPresent("Level KingRat");
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.assertTextPresent("Resolve Issue");
        this.assertTextPresent("Resolving an issue indicates that the developers are satisfied the issue is finished.");
        this.assertFormElementNotPresent("security");
        this.assertTextPresent("The security level of subtasks is inherited from parents.");
        this.submit("Transition");
        this.assertTextPresent("Security Level:");
        this.assertTextPresent("Level KingRat");
        this.navigation.issue().returnToSearch();
        WebTable issueTable = this.getWebTableWithID("issuetable");
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-9");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"Level KingRat", (String)issueTable.getCellAsText(1, 11).trim());
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-8");
        TestSecurityLevelOfSubtasks.assertEquals((String)"Level KingRat", (String)issueTable.getCellAsText(2, 11).trim());
    }

    public void testChangeProjectsSecurityLevelScheme() {
        this.assertPrecondition();
        Long projectId = this.backdoor.project().getProjectId("RAT");
        Long schemeId = this.backdoor.project().getSchemes((Long)projectId).issueSecurityScheme.id;
        this.tester.gotoPage("/secure/project/SelectProjectIssueSecurityScheme!default.jspa?projectId=" + projectId + "&schemeId=" + schemeId);
        this.selectOption("newSchemeId", "DogSecurityScheme");
        this.submit("Next >>");
        this.assertTextPresent("Associate Issue Security Scheme to Project");
        this.selectOption("level_10025", "Level Red");
        this.selectOption("level_10026", "Level Green");
        this.submit("Associate");
        Assert.assertThat((Object)new ProjectClient((JIRAEnvironmentData)this.environmentData).get((String)"RAT").name, (Matcher)CoreMatchers.equalTo((Object)"Rattus"));
        this.displayAllIssues();
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-9");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-8");
        this.assertTableCellHasText("issuetable", 1, 11, "Level Red");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-8");
        this.assertTableCellHasText("issuetable", 2, 11, "Level Red");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-7");
        this.assertTableCellHasText("issuetable", 3, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 3, 11, "Level Green");
        this.assertTableCellHasText("issuetable", 4, 1, "RAT-6");
        this.assertTableCellHasText("issuetable", 4, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 4, 11, "Level Green");
        this.assertTableCellHasText("issuetable", 5, 1, "RAT-5");
        this.assertTableCellHasText("issuetable", 5, 11, "Level Green");
    }

    private void assertPrecondition() {
        this.showAllIssues();
    }

    private void showAllIssues() {
        this.displayAllIssues();
        this.assertTableCellHasText("issuetable", 1, 1, "RAT-9");
        this.assertTableCellHasText("issuetable", 1, 2, "RAT-8");
        this.assertTableCellHasText("issuetable", 1, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 2, 1, "RAT-8");
        this.assertTableCellHasText("issuetable", 2, 11, "Level KingRat");
        this.assertTableCellHasText("issuetable", 3, 1, "RAT-7");
        this.assertTableCellHasText("issuetable", 3, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 3, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 4, 1, "RAT-6");
        this.assertTableCellHasText("issuetable", 4, 2, "RAT-5");
        this.assertTableCellHasText("issuetable", 4, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 5, 1, "RAT-5");
        this.assertTableCellHasText("issuetable", 5, 11, "Level Mouse");
        this.assertTableCellHasText("issuetable", 6, 1, "COW-37");
        this.assertTableCellHasText("issuetable", 6, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 6, 2, "Lets get a third milk bucket");
        this.assertTableCellHasText("issuetable", 7, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 7, 1, "COW-36");
        this.assertTableCellHasText("issuetable", 7, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 7, 2, "Get another milk bucket");
        this.assertTableCellHasText("issuetable", 7, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 8, 1, "COW-35");
        this.assertTableCellHasText("issuetable", 8, 2, "No more milk");
        this.assertTableCellHasText("issuetable", 8, 11, "MyFriendsOnly");
        this.assertTableCellHasText("issuetable", 9, 1, "COW-34");
        this.assertTableCellHasText("issuetable", 9, 2, "COW-35");
        this.assertTableCellHasText("issuetable", 9, 2, "Get new milk bucket");
        this.assertTableCellHasText("issuetable", 9, 11, "MyFriendsOnly");
    }
}

