/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
public class TestIssueToSubtaskConversionNotifications
extends EmailFuncTestCase {
    private static final String ISSUE_TO_CONVERT_ID = "10001";
    private static final String PARENT_ISSUE = "TEST-1";
    private static final String SUBTASK_TYPE_ID = "5";
    public static final String EMAIL_ADDRESS = "admin@example.com";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueToSubtaskConversionNotifications.xml");
        this.configureAndStartSmtpServer();
    }

    public void testEmailIsSentWhenIssueIsConvertedToSubtask() throws Exception {
        this.convertIssueToSubtask(ISSUE_TO_CONVERT_ID);
        this.assertOneEmailWasSent(EMAIL_ADDRESS, "updated", "an issue", "Change By:", "Parent:", PARENT_ISSUE, "TEST-2", "Bug", "Sub-task", "Add Comment", "ViewProfile.jspa?name=admin", "This message was sent by Atlassian JIRA");
    }

    public void convertIssueToSubtask(String issueId) {
        this.tester.gotoPage("/secure/ConvertIssueSetIssueType.jspa?id=" + issueId + "&parentIssueKey=" + PARENT_ISSUE + "&issuetype=" + SUBTASK_TYPE_ID);
        this.tester.submit("Next >>");
        this.tester.submit("Finish");
    }

    private void assertOneEmailWasSent(String emailAddress, String ... expectedTexts) throws Exception {
        this.flushMailQueueAndWait(1);
        List<MimeMessage> messagesForRecipient = this.getMessagesForRecipient(emailAddress);
        MatcherAssert.assertThat((Object)messagesForRecipient.size(), (Matcher)Matchers.is((Object)1));
        for (String expectedText : expectedTexts) {
            this.assertEmailBodyContains(messagesForRecipient.get(0), expectedText);
        }
    }
}

