/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.SUB_TASKS})
public class TestIssueToSubTaskConversionStep1
extends JIRAWebTest {
    private static final String ISSUE_WITHOUT_SUBTASK = "HSP-1";
    private static final String ISSUE_WITHOUT_SUBTASK_ID = "10000";
    private static final String ISSUE_WITH_SUBTASK = "HSP-2";
    private static final String ISSUE_WITH_SUBTASK_ID = "10001";
    private static final String SUBTASK = "HSP-3";
    private static final String SUBTASK_ID = "10002";
    private static final String INVALID_ISSUE_1 = "HSP-9";
    private static final String INVALID_ISSUE_ID_1 = "1)%20Please%20login%20again%20at%20https://attacker.com%20";
    private static final String INVALID_ISSUE_ID_2 = "10000a";
    private static final String ISSUE_FROM_OTHER_PROJECT = "MKY-1";
    private static final String ISSUE_TO_CONVERT_ID = "10020";
    private static final String ISSUE_TO_CONVERT_KEY = "MKY-2";
    private static final String PARENT_ISSUE = "MKY-3";
    private static final String SUBTASK_TYPE = "Sub-task";
    private static final String SUBTASK_TYPE_ID = "5";
    private static final String TASK_TYPE = "Task";
    private static final String TASK_TYPE_ID = "3";
    private static final String SUBTASK_TYPE_2 = "Sub-task 2";
    private static final String SUBTASK_TYPE_2_ID = "6";
    private static final String SUBTASK_TYPE_3 = "Sub-task 3";
    private static final String SUBTASK_TYPE_3_ID = "7";
    private static final String INVALID_TYPE_ID = "976";

    public TestIssueToSubTaskConversionStep1(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueToSubTaskConversion.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    public void testParentIssueKeyIsTranslatedToCurrentKey() {
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.backdoor.project().addProjectKey(projectId, "OLD");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Select Parent Issue");
        this.assertTextPresent("Begin typing to search for issues to link");
        this.assertTextPresent("Only non-sub-task issues from the same project (HSP) can be selected.");
        this.setFormElement("parentIssueKey", "OLD-2");
        this.submit();
        this.assertTextPresentAfterText(ISSUE_WITH_SUBTASK, "Parent Issue:");
    }

    public void testIssueToSubTaskConversionWhenSubTaskNotEnabled() {
        this.gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Step 1 of 4");
        this.deleteIssue(SUBTASK);
        TestIssueToSubTaskConversionStep1.assertFalse((boolean)this.deactivateSubTasks());
        this.gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Errors");
        this.assertTextPresent("Sub-tasks are disabled.");
        this.assertTextNotPresent("Step 1 of 4");
    }

    public void testIssueToSubTaskConversionOnSubtask() {
        this.gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Step 1 of 4");
        this.gotoIssue(SUBTASK);
        this.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(SUBTASK_ID);
        this.assertTextPresent("Errors");
        this.assertTextPresent("Issue HSP-3 is already a sub-task.");
        this.assertTextNotPresent("Step 1 of 4");
    }

    public void testIssueToSubTaskConversionWhenIssueHasSubTasks() {
        this.gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Step 1 of 4");
        this.gotoIssue(ISSUE_WITH_SUBTASK);
        this.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITH_SUBTASK_ID);
        this.assertTextPresent("Errors");
        this.assertTextPresent("Can not convert issue HSP-2 with sub-tasks to a sub-task.");
        this.assertTextNotPresent("Step 1 of 4");
        this.assertTextPresentBeforeText("Return to", ISSUE_WITH_SUBTASK);
        this.assertLinkPresentWithText(ISSUE_WITH_SUBTASK);
    }

    public void testIssueToSubTaskConversionEditPermission() {
        this.gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Step 1 of 4");
        this.assertTextPresent("Select Parent Issue");
        this.assertTextPresent("Begin typing to search for issues to link");
        this.assertTextPresent("Only non-sub-task issues from the same project (HSP) can be selected.");
        this.logout();
        this.login("fred", "fred");
        this.gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Access Denied");
        this.assertTextNotPresent("Step 1 of 4");
    }

    public void testIssueToSubTaskConversionWhenNotInIssueTypes() {
        this.gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.assertLinkPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Step 1 of 4");
        this.deleteIssue(SUBTASK);
        this.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=5");
        this.assertTextPresent("Delete Issue Type: Sub-task");
        this.submit("Delete");
        this.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=6");
        this.assertTextPresent("Delete Issue Type: Sub-task 2");
        this.submit("Delete");
        this.gotoPage("secure/admin/DeleteIssueType!default.jspa?id=7");
        this.assertTextPresent("Delete Issue Type: Sub-task 3");
        this.submit("Delete");
        this.gotoIssue(ISSUE_WITHOUT_SUBTASK);
        this.assertLinkNotPresent("issue-to-subtask");
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Errors");
        this.assertTextPresent("Project HSP associated with issue does not have any sub-task issue types available.");
        this.assertTextNotPresent("Step 1 of 4");
    }

    public void testIssueToSubTaskConversionIsProtectAgainstContentSpoofingThroughAnInvalidIssueId() {
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Step 1 of 4");
        this.gotoConvertIssue(INVALID_ISSUE_ID_1);
        this.assertTextPresent("Errors");
        this.assertTextPresent("Invalid issue id");
        this.assertTextNotPresent("attacker.com");
        this.assertTextNotPresent("Step 1 of 4");
        this.gotoConvertIssue(INVALID_ISSUE_ID_2);
        this.assertTextPresent("Errors");
        this.assertTextNotPresent(INVALID_ISSUE_ID_2);
        this.assertTextNotPresent("Step 1 of 4");
        this.assertTextPresentBeforeText("Return to", "Dashboard");
        this.assertLinkPresentWithText("Dashboard");
    }

    public void testIssueToSubTaskConversionInvalidParentIssue() {
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertTextPresent("Select Parent Issue");
        this.assertTextPresent("Begin typing to search for issues to link");
        this.assertTextPresent("Only non-sub-task issues from the same project (HSP) can be selected.");
        this.setFormElement("parentIssueKey", "");
        this.submit();
        this.assertTextPresent("Parent issue key not specified.");
        this.setFormElement("parentIssueKey", INVALID_ISSUE_1);
        this.submit();
        this.assertTextPresent("Parent issue with key HSP-9 not found.");
        this.setFormElement("parentIssueKey", ISSUE_FROM_OTHER_PROJECT);
        this.submit();
        this.assertTextPresent("Parent issue MKY-1 must be from the same project as issue HSP-1");
        this.setFormElement("parentIssueKey", ISSUE_WITHOUT_SUBTASK);
        this.submit();
        this.assertTextPresent("Issue HSP-1 can not be parent of itself.");
        this.setFormElement("parentIssueKey", SUBTASK);
        this.submit();
        this.assertTextPresent("Parent issue HSP-3 can not be sub-task.");
    }

    public void testIssueToSubTaskConversionSubTaskType() {
        this.gotoConvertIssue(ISSUE_WITHOUT_SUBTASK_ID);
        this.assertOptionsEqual("issuetype", new String[]{SUBTASK_TYPE, SUBTASK_TYPE_2, SUBTASK_TYPE_3});
        this.assertOptionValueNotPresent("issuetype", TASK_TYPE);
        this.gotoConvertIssue(ISSUE_TO_CONVERT_ID);
        this.assertOptionsEqual("issuetype", new String[]{SUBTASK_TYPE, SUBTASK_TYPE_3});
        this.assertOptionValueNotPresent("issuetype", SUBTASK_TYPE_2);
    }

    public void testIssueToSubTaskConversionInvalidSubTaskType() {
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, INVALID_TYPE_ID);
        this.assertTextPresent("Selected issue type not found.");
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, SUBTASK_TYPE_2_ID);
        this.assertTextPresent("Issue type Sub-task 2 not applicable for this project");
        this.gotoConvertIssueStep2(ISSUE_TO_CONVERT_ID, PARENT_ISSUE, TASK_TYPE_ID);
        this.assertTextPresent("Issue type Task is not a sub-task");
    }

    public void testIssueToSubTaskConversionPanelStep1() {
        this.gotoConvertIssue(ISSUE_TO_CONVERT_ID);
        this.assertTextPresent("Select Parent Issue");
        this.assertTextPresent("Begin typing to search for issues to link");
        this.assertTextPresent("Only non-sub-task issues from the same project (MKY) can be selected.");
        this.assertSubTaskConversionPanelSteps(ISSUE_TO_CONVERT_KEY, 1);
    }
}

