/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.SUB_TASKS})
public class TestCreateSubTasks
extends JIRAWebTest {
    private static final String PROJECT_MONKEY_ID = "10001";

    public TestCreateSubTasks(String name) {
        super(name);
    }

    @Override
    public void tearDown() {
        this.getBackdoor().darkFeatures().disableForSite("jira.no.frother.reporter.field");
        super.tearDown();
    }

    public void testCreateSubTaskInJiraWithSingleSubTaskType() {
        this.administration.restoreData("TestOneProjectWithOneIssueType.xml");
        this.administration.project().addProject("neanderthal", "NEA", "admin");
        Long projectId = this.backdoor.project().getProjectId("HSP");
        this.tester.gotoPage("/secure/admin/SelectIssueTypeSchemeForProject!default.jspa?projectId=" + projectId);
        this.tester.checkCheckbox("createType", "chooseScheme");
        this.tester.selectOption("schemeId", "Bugs & Sub-tasks");
        this.tester.submit();
        this.navigation.issue().createIssue("homosapien", "Bug", "First issue");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLink("create-subtask");
        this.tester.assertTextNotPresent("Choose the project and issue type");
        this.tester.assertTextPresent("Create Sub-Task");
        this.assertTextSequence(new String[]{"Project", "homosapien", "Issue Type", "Sub-task"});
        this.tester.assertFormElementPresent("summary");
    }

    public void testCreateSubTasks() {
        this.administration.restoreBlankInstance();
        this.getBackdoor().darkFeatures().enableForSite("no.frother.assignee.field");
        this.getBackdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.administration.project().addProject("neanderthal", "NDT", "admin");
        this.administration.subtasks().addSubTaskType("Custom Sub Task", "Custom Sub Task");
        this.resetFields();
        String issueKeyNormal = this.addIssue("homosapien", "HSP", "Bug", "test for sub tasks", "Minor", null, null, null, "Administrator", "test environment 1", "test description for sub tasks", null, null, null);
        this.subTasksWithSubTasksEnabled(issueKeyNormal);
        this.subTasksCreateSubTaskWithCustonType(issueKeyNormal);
        this.subTasksWithCreatePermission(issueKeyNormal);
        this.subTaskWithNoSummary(issueKeyNormal);
        this.subTaskWithRequiredFields(issueKeyNormal);
        this.subTaskWithHiddenFields(issueKeyNormal);
        this.subTaskWithInvalidDueDate(issueKeyNormal);
        this.subTaskWithSchedulePermission(issueKeyNormal);
        this.subTaskWithAssignPermission(issueKeyNormal);
        this.subTaskWithModifyReporterPermission(issueKeyNormal);
        this.subTaskWithTimeTracking(issueKeyNormal);
        this.subTaskWithUnassignableUser(issueKeyNormal);
        this.subTaskMoveIssueWithSubTask(issueKeyNormal);
        this.deleteIssue(issueKeyNormal);
    }

    public void testCreateSubtaskSkipStep1OnlyOneProjectAndOneIssueType() {
        this.administration.restoreData("TestCreateSubtaskOneProjectOneSubtaskType.xml");
        this.assertRedirectAndFollow("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000", ".*CreateSubTaskIssue\\.jspa\\?parentIssueId=10000&pid=10001&issuetype=4$");
        this.assertTextSequence(new String[]{"Create Sub-Task", "Project", "monkey", "Issue Type", "Sub-task", "Summary"});
    }

    public void testCreateIssueSkipStep1IssueTypeSchemeInfersOneProjectAndIssueType() {
        this.administration.restoreData("TestCreateMonkeyHasOneIssueType.xml");
        this.assertRedirectAndFollow("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000", ".*CreateSubTaskIssue\\.jspa\\?parentIssueId=10000&pid=10001&issuetype=5$");
        this.assertTextSequence(new String[]{"Create Sub-Task", "Project", "monkey", "Issue Type", "Sub-task", "Summary"});
        this.tester.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10001");
        this.tester.assertFormPresent("subtask-create-start");
        this.navigation.logout();
        this.tester.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000");
        this.tester.assertTextPresent("You are not logged in");
        this.tester.clickLinkWithText("Log In");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        this.assertTextSequence(new String[]{"Create Sub-Task", "Project", "monkey", "Issue Type", "Sub-task", "Summary"});
    }

    private void subTasksWithSubTasksEnabled(String issueKey) {
        this.administration.subtasks().enable();
        TestCreateSubTasks.log("Sub Task Create: Tests the availability of the 'Sub Task' Link with 'Sub Tasks' enabled");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent("create-subtask");
        this.administration.subtasks().disable();
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkNotPresent("create-subtask");
    }

    private void subTasksCreateSubTaskWithCustonType(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Tests the ability to create a sub task using a custom-made sub task type");
        this.createSubTaskStep1(issueKey, "Custom Sub Task");
        this.tester.setFormElement("summary", "Custom Sub Task of Test 5");
        this.tester.submit();
        this.tester.assertTextPresent("Custom Sub Task of Test 5");
        this.tester.assertTextPresent("test for sub tasks");
        this.deleteCurrentIssue();
        this.administration.subtasks().disable();
        this.tester.assertTextPresent("Enable");
    }

    private void subTasksWithCreatePermission(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Test availability of 'Create Sub Task' link with 'Create Issue' permission.");
        this.administration.subtasks().enable();
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkNotPresent("create-subtask");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent("create-subtask");
        this.administration.subtasks().disable();
    }

    private void subTaskWithNoSummary(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Adding sub task without summary");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.selectOption("priority", "Minor");
        this.tester.submit();
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertTextPresent("You must specify a summary of the issue.");
        this.administration.subtasks().disable();
    }

    private void subTaskWithRequiredFields(String issueKey) {
        this.setRequiredFields();
        TestCreateSubTasks.log("Sub Task Create: Test the creation of a sub task using required fields");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.setFormElement("summary", "This is a new summary");
        this.tester.setFormElement("reporter", "");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertTextPresent("Component/s is required");
        this.tester.assertTextPresent("Affects Version/s is required");
        this.tester.assertTextPresent("Fix Version/s is required");
        this.resetFields();
        this.administration.subtasks().disable();
    }

    private void subTaskWithHiddenFields(String issueKey) {
        this.setHiddenFields("Component/s");
        this.setHiddenFields("Affects Version/s");
        this.setHiddenFields("Fix Version/s");
        TestCreateSubTasks.log("Sub Task Create: Test the creation of a sub task using hidden fields");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertLinkNotPresent("components");
        this.tester.assertLinkNotPresent("versions");
        this.tester.assertLinkNotPresent("fixVersions");
        this.resetFields();
        this.administration.subtasks().disable();
    }

    private void subTaskWithInvalidDueDate(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Creating sub task with invalid due date");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.setFormElement("summary", "stuff");
        this.tester.setFormElement("duedate", "stuff");
        this.tester.submit("Create");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.assertTextPresent("You did not enter a valid date. Please enter the date in the format &quot;d/MMM/yy&quot;");
        this.administration.subtasks().disable();
    }

    private void subTaskWithSchedulePermission(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Test prescence of 'Due Date' field with 'Schedule Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertTextNotPresent("Due Date");
        this.administration.subtasks().disable();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.SCHEDULE_ISSUES, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertTextPresent("Due Date");
        this.administration.subtasks().disable();
    }

    private void subTaskWithAssignPermission(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Test ability to specify assignee with 'Assign Issue' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementNotPresent("assignee");
        this.administration.subtasks().disable();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementPresent("assignee");
        this.administration.subtasks().disable();
    }

    private void subTaskWithModifyReporterPermission(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Test availability of Reporter with 'Modify Reporter' permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementNotPresent("reporter");
        this.administration.subtasks().disable();
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MODIFY_REPORTER, "jira-administrators");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementPresent("reporter");
        this.administration.subtasks().disable();
    }

    private void subTaskWithTimeTracking(String issueKey) {
        TestCreateSubTasks.log("Sub task Create: Test availability of the original esitmate field with time tracking activated");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementNotPresent("timetracking");
        this.administration.subtasks().disable();
        this.activateTimeTracking();
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.assertFormElementPresent("timetracking");
        this.deactivateTimeTracking();
        this.administration.subtasks().disable();
    }

    private void subTaskWithUnassignableUser(String issueKey) {
        TestCreateSubTasks.log("Sub Task Create: Attempt to set the assignee to be an unassignable user ...");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.submit("Create");
        this.tester.assertTextPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.administration.subtasks().disable();
    }

    private void subTaskMoveIssueWithSubTask(String issueKey) {
        TestCreateSubTasks.log("Sub Task Move: Move issue with a sub task");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.setFormElement("summary", "Sub Task of Test 5");
        this.tester.submit();
        this.tester.assertTextPresent("Sub Task of Test 5");
        this.tester.assertTextPresent("test for sub tasks");
        try {
            this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MOVE_ISSUES, "jira-developers");
        }
        catch (UniformInterfaceException uniformInterfaceException) {
            // empty catch block
        }
        this.gotoIssue(issueKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectProject("neanderthal", "10000_1_pid");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.tester.submit("Next");
        this.gotoIssue(issueKey);
        this.tester.clickLinkWithText("Sub Task of Test 5");
        this.tester.assertTextPresent("neanderthal");
        this.deleteCurrentIssue();
        this.administration.subtasks().disable();
    }

    private void subTaskMoveSubTask(String issueKey) {
        String subTaskKey;
        TestCreateSubTasks.log("Sub Task Move; Move a sub task to a different sub task type.");
        this.createSubTaskStep1(issueKey, "Sub-task");
        this.tester.setFormElement("summary", "Sub Task of Test 5");
        this.tester.submit();
        this.tester.assertTextPresent("Sub Task of Test 5");
        this.tester.assertTextPresent("test for sub tasks");
        try {
            String text = this.tester.getDialog().getResponse().getText();
            int projectIdLocation = text.indexOf("[NDT") + 1;
            int endOfIssueKey = text.indexOf("]", projectIdLocation);
            subTaskKey = text.substring(projectIdLocation, endOfIssueKey);
        }
        catch (IOException t) {
            TestCreateSubTasks.fail((String)"Unable to obtain sub-task key");
            return;
        }
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.gotoIssue(subTaskKey);
        this.tester.assertLinkNotPresent("move-issue");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.MOVE_ISSUES, "jira-developers");
        this.gotoIssue(subTaskKey);
        this.tester.clickLink("move-issue");
        this.navigation.issue().selectIssueType("Custom Sub Task", "issuetype");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Step 2 of 3");
        this.tester.getDialog().setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertTextPresent("Step 4 of 4");
        this.tester.submit("Move");
        this.tester.assertTextPresent("Custom Sub Task");
        this.tester.assertTextPresent("Details");
        this.gotoIssue(subTaskKey);
        this.deleteCurrentIssue();
        this.administration.subtasks().disable();
    }
}

