/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.sendheadearly;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@WebTest(value={Category.FUNC_TEST, Category.HTTP})
public class TestSendHeadEarly
extends FuncTestCase {
    private static final String SEND_HEAD_EARLY_FOR_DASHBOARD_DISABLE_FEATURE_KEY = "com.atlassian.plugins.dashboard.SEND_HEAD_EARLY.disabled";

    public void testDashboard() {
        this.compareEnabledVsDisabled("/secure/Dashboard.jspa");
    }

    private void compareEnabledVsDisabled(String url) {
        this.navigation.login("admin", "admin");
        this.backdoor.darkFeatures().enableForSite(SEND_HEAD_EARLY_FOR_DASHBOARD_DISABLE_FEATURE_KEY);
        PageResult disabledResponse = this.getPage(url);
        this.backdoor.darkFeatures().disableForSite(SEND_HEAD_EARLY_FOR_DASHBOARD_DISABLE_FEATURE_KEY);
        PageResult enabledResponse = this.getPage(url);
        TestSendHeadEarly.assertEquals((String)disabledResponse.content, (String)enabledResponse.content);
        TestSendHeadEarly.assertEquals((String)disabledResponse.titleTag, (String)enabledResponse.titleTag);
        TestSendHeadEarly.assertEquals((String)disabledResponse.osdTag, (String)enabledResponse.osdTag);
    }

    private PageResult getPage(String url) {
        String[] patterns;
        String[] selectors;
        this.tester.gotoPage(url);
        String response = this.tester.getDialog().getResponseText();
        Document doc = Jsoup.parse((String)response);
        Element titleElement = doc.select("title").first();
        String title = titleElement.outerHtml();
        titleElement.remove();
        Element osdElement = doc.select("link[rel=search][type*=opensearchdescription]").first();
        String osd = osdElement.outerHtml();
        osdElement.remove();
        for (String selector : selectors = new String[]{"meta[name=ajs-enabled-dark-features]", "form#jira_request_timing_info"}) {
            doc.select(selector).remove();
        }
        String filteredResponse = doc.outerHtml();
        for (String pattern : patterns = new String[]{"AG\\.DashboardManager\\.setup\\(\\{.*?\\}\\);", "<!--\\s+REQUEST ID.*?-->"}) {
            filteredResponse = this.replace(pattern, filteredResponse);
        }
        filteredResponse = filteredResponse.replaceAll("\\s+", " ");
        return new PageResult(filteredResponse, title, osd);
    }

    private final String replace(String pattern, String response) {
        Pattern regex = Pattern.compile(pattern, 34);
        return regex.matcher(response).replaceAll("");
    }

    private static final class PageResult {
        private final String content;
        private final String titleTag;
        private final String osdTag;

        private PageResult(String content, String titleTag, String osdTag) {
            this.content = content;
            this.titleTag = titleTag;
            this.osdTag = osdTag;
        }
    }
}

