/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.sendheadearly;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.matchers.JUnitMatchers;

@WebTest(value={Category.FUNC_TEST, Category.HTTP})
public class TestCommittedResponseHtmlErrorRecovery
extends FuncTestCase {
    private static final String OPENING_HTML_TAG = "<html";
    private static final String CLOSING_HTML_TAG = "</html>";
    private static final String MAGIC_JAVASCRIPT_MARKER = "'\"-->>]]>";
    private static final String POST_FLUSH_CONTENT = "POST_FLUSH_CONTENT";

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.navigation.login("admin", "admin");
    }

    @Override
    protected void tearDownTest() {
        this.navigation.logout();
    }

    public void testWithFlushAndContent() {
        this.tester.gotoPage("/CommittedResponseExceptionThrowingAction.jspa");
        String response = this.tester.getDialog().getResponseText();
        TestCommittedResponseHtmlErrorRecovery.assertNotNull((String)"Expected a response", (Object)response);
        Assert.assertThat((String)"Expected to see an opening HTML tag in the response", (Object)response, (Matcher)JUnitMatchers.containsString((String)OPENING_HTML_TAG));
        Assert.assertThat((String)"Expected to NOT see a closing HTML tag in the response", (Object)response, (Matcher)Matchers.not((Matcher)JUnitMatchers.containsString((String)CLOSING_HTML_TAG)));
        Assert.assertThat((String)"Expected to see magic javascript injected in the response", (Object)response, (Matcher)JUnitMatchers.containsString((String)MAGIC_JAVASCRIPT_MARKER));
        Assert.assertThat((String)"Expected to NOT to see any post-flush content in the response", (Object)response, (Matcher)Matchers.not((Matcher)JUnitMatchers.containsString((String)POST_FLUSH_CONTENT)));
    }
}

