/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security.plugin;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.rest.api.issue.IssueUpdateRequest;
import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.CommentClient;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.Response;
import com.atlassian.jira.testkit.client.restclient.Visibility;
import java.io.IOException;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY, Category.REFERENCE_PLUGIN})
public class TestPermissionOverride
extends FuncTestCase {
    private static final String TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE = "com.atlassian.jira.dev.reference-plugin:brad.odlaw.cant.transition.issue";
    private static final String COMMENT_ISSUE_PERMISSION_OVERRIDE_MODULE = "com.atlassian.jira.dev.reference-plugin:brad.odlaw.cant.comment";
    private static final String EDIT_ISSUE_PERMISSION_OVERRIDE_MODULE = "com.atlassian.jira.dev.reference-plugin:brad.odlaw.cant.edit.issue";
    private static final String BRAD = "brad_the_odlaw";
    private IssueClient issueClient;
    private CommentClient commentClient;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.backdoor.usersAndGroups().addUser(BRAD, BRAD, BRAD, "odlaw@atlassiqan.com").addUserToGroup(BRAD, "jira-developers");
        this.issueClient = new IssueClient((JIRAEnvironmentData)this.environmentData);
        this.commentClient = new CommentClient((JIRAEnvironmentData)this.environmentData);
    }

    public void testPermissionToEditIssueOverridden() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "issue summary");
        this.backdoor.plugins().disablePluginModule(EDIT_ISSUE_PERMISSION_OVERRIDE_MODULE);
        Response response = ((IssueClient)this.issueClient.loginAs(BRAD, BRAD)).updateResponse(issue.key(), this.summary("new summary"));
        Assert.assertThat((Object)response.statusCode, this.statusCode(Response.Status.NO_CONTENT));
        this.backdoor.plugins().enablePluginModule(EDIT_ISSUE_PERMISSION_OVERRIDE_MODULE);
        Response updateWithoutPermissionResponse = ((IssueClient)this.issueClient.loginAs(BRAD, BRAD)).updateResponse(issue.key(), this.summary("summary which will never be set"));
        Assert.assertThat((Object)updateWithoutPermissionResponse.statusCode, (Matcher)Matchers.not(this.statusCodeFamily(200)));
    }

    public void testPermissionToCommentIssueOverridden() {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "issue summary");
        this.backdoor.plugins().disablePluginModule(COMMENT_ISSUE_PERMISSION_OVERRIDE_MODULE);
        Response response = ((CommentClient)this.commentClient.loginAs(BRAD, BRAD)).post(issue.key(), this.comment("I comment because I can"));
        Assert.assertThat((Object)response.statusCode, (Matcher)Matchers.is((Object)Response.Status.CREATED.getStatusCode()));
        this.backdoor.plugins().enablePluginModule(COMMENT_ISSUE_PERMISSION_OVERRIDE_MODULE);
        Response commentWithoutPermissionResponse = ((CommentClient)this.commentClient.loginAs(BRAD, BRAD)).post(issue.key(), this.comment("I try to comment"));
        Assert.assertThat((Object)commentWithoutPermissionResponse.statusCode, (Matcher)Matchers.not(this.statusCodeFamily(200)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPermissionToTransitionIssueOverridden() throws IOException {
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "issue summary");
        try (JiraRestClient jiraRestClient = this.createRestClient(BRAD);){
            this.backdoor.plugins().disablePluginModule(TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE);
            Assert.assertThat(this.getIssueTransitions(jiraRestClient, issue.key()), (Matcher)Matchers.not((Matcher)Matchers.emptyIterable()));
            this.backdoor.plugins().enablePluginModule(TRANSITION_ISSUE_PERMISSION_OVERRIDE_MODULE);
            Assert.assertThat(this.getIssueTransitions(jiraRestClient, issue.key()), (Matcher)Matchers.emptyIterable());
        }
    }

    private IssueUpdateRequest summary(String summary) {
        return new IssueUpdateRequest().fields(new IssueFields().summary(summary));
    }

    private Comment comment(String commentText) {
        Comment comment = new Comment();
        comment.body = commentText;
        comment.visibility = new Visibility("group", "jira-users");
        return comment;
    }

    private Matcher<? super Integer> statusCode(Response.Status status) {
        return Is.is((Object)status.getStatusCode());
    }

    private Matcher<? super Integer> statusCodeFamily(int family) {
        int statusCodeFamilyLowerBound = family / 100 * 100;
        return Matchers.allOf((Matcher[])new Matcher[]{Matchers.lessThan((Comparable)Integer.valueOf(statusCodeFamilyLowerBound + 100)), Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(statusCodeFamilyLowerBound))});
    }

    private JiraRestClient createRestClient(String user) {
        return this.createRestClient(user, user);
    }

    private Iterable<Transition> getIssueTransitions(JiraRestClient jiraRestClient, String issueKey) {
        IssueRestClient issueClient = jiraRestClient.getIssueClient();
        Issue restClientIssue = (Issue)issueClient.getIssue(issueKey).claim();
        return (Iterable)issueClient.getTransitions(restClientIssue).claim();
    }
}

