/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
public class TestWebResourceRetrievalDoesNotExposeProtectedResources
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testWebInfResourceCannotBeRetrieved() throws Exception {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.tester.gotoPage("s/1519/3/1.0/_/WEB-INF/classes/seraph-config.xml");
        TestWebResourceRetrievalDoesNotExposeProtectedResources.assertEquals((int)this.tester.getDialog().getResponse().getResponseCode(), (int)404);
        TestWebResourceRetrievalDoesNotExposeProtectedResources.assertTrue((boolean)this.tester.getDialog().getResponse().getText().contains("dead link"));
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
    }

    public void testWebInfResourceCannotBeRetrievedWithParentTransversal() throws Exception {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.tester.gotoPage("s/1519/3/1.0/_/WEB-INF/images/../classes/seraph-config.xml");
        TestWebResourceRetrievalDoesNotExposeProtectedResources.assertEquals((int)this.tester.getDialog().getResponse().getResponseCode(), (int)404);
        TestWebResourceRetrievalDoesNotExposeProtectedResources.assertTrue((boolean)this.tester.getDialog().getResponse().getText().contains("dead link"));
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
    }
}

