/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.page.Error404;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
public class TestWebActionResolution
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testFullyQualifiedClassNameInUrlCanNotBeResolvedToAnAction() throws Exception {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.tester.gotoPage("com.atlassian.jira.web.action.user.ViewUserIssueColumns.jspa");
        TestWebActionResolution.assertFalse((boolean)this.tester.getDialog().getResponse().getText().contains("securitybreach"));
        Assert.assertThat((Object)new Error404(this.tester), Error404.isOn404Page());
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(true);
    }

    public void testCanResolveARootActionGivenThatNoExplicitAliasHasBeenDefinedForIt() throws Exception {
        this.tester.gotoPage("Dashboard.jspa");
        TestWebActionResolution.assertTrue((boolean)this.locator.id("dashboard").exists());
    }

    public void testCanResolveACommandActionGivenAnAliasHasBeenDefinedForIt() throws Exception {
        this.navigation.login("admin");
        this.tester.gotoPage("AddNewWorkflow.jspa");
        TestWebActionResolution.assertTrue((boolean)this.locator.id("add-workflow").exists());
    }

    public void testCanNotResolveARootActionGivenThatTheUserDoesNotHaveTheRolesRequiredForIt() throws Exception {
        this.navigation.login("fred");
        this.tester.gotoPage("ImportWorkflowFromXml!default.jspa");
        TestWebActionResolution.assertTrue((boolean)this.locator.id("login-form").exists());
    }

    public void testCanNotResolveACommandActionGivenThatTheUserDoesNotHaveTheRolesRequiredForItByInheritance() throws Exception {
        this.navigation.login("fred");
        this.tester.gotoPage("IssueLinkingActivate.jspa?atl_token=" + this.page.getFreshXsrfToken());
        TestWebActionResolution.assertTrue((boolean)this.locator.id("login-form").exists());
    }

    private static class ViewUserIssueColumnsAction {
        private ViewUserIssueColumnsAction() {
        }

        private static class Views {
            public static final String SECURITY_BREACH = "securitybreach";

            private Views() {
            }
        }
    }
}

