/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
public class TestRedirectAfterLogin
extends FuncTestCase {
    private String context;

    @Override
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        String xsrfTokenValue = this.page.getXsrfToken();
        this.navigation.logout();
        String expectedLogoutPage = "/secure/Logout!default.jspa?atl_token=" + xsrfTokenValue;
        TestRedirectAfterLogin.assertTrue((boolean)this.getCurrentUrl().endsWith(expectedLogoutPage));
        this.context = this.getCurrentUrl().substring(0, this.getCurrentUrl().length() - expectedLogoutPage.length());
    }

    public void testRedirectWithRelativeUrl() throws Exception {
        this.tester.gotoPage("login.jsp?os_destination=%2Fsecure%2Fadmin%2Fuser%2FUserBrowser.jspa");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        TestRedirectAfterLogin.assertEquals((String)(this.context + "/secure/admin/user/UserBrowser.jspa"), (String)this.getCurrentUrl());
        this.tester.assertTextPresent("Filter Users");
    }

    public void testRedirectWithAbsoluteUrlSameContext() throws Exception {
        String absoluteUrl = this.context + "/secure/admin/user/UserBrowser.jspa";
        this.tester.gotoPage("login.jsp?os_destination=" + URLEncoder.encode(absoluteUrl, System.getProperty("file.encoding")));
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        TestRedirectAfterLogin.assertEquals((String)(this.context + "/secure/admin/user/UserBrowser.jspa"), (String)this.getCurrentUrl());
        this.tester.assertTextPresent("Filter Users");
    }

    public void testRedirectWithAbsoluteUrlDifferentContext() throws Exception {
        String absoluteUrl = "http://www.atlassian.com";
        this.tester.gotoPage("login.jsp?os_destination=" + URLEncoder.encode(absoluteUrl, System.getProperty("file.encoding")));
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        TestRedirectAfterLogin.assertEquals((String)(this.context + "/secure/Dashboard.jspa"), (String)this.getCurrentUrl());
        this.tester.assertTextPresent("jWebTest JIRA installation");
    }

    public void testRedirectWithHeaderInjectionCRLF() throws Exception {
        this._testRedirectWithHeaderInjection("\r\n");
    }

    public void testRedirectWithHeaderInjectionCR() throws Exception {
        this._testRedirectWithHeaderInjection("\r");
    }

    public void testRedirectWithHeaderInjectionLF() throws Exception {
        this._testRedirectWithHeaderInjection("\n");
    }

    private void _testRedirectWithHeaderInjection(String newlineChars) throws UnsupportedEncodingException {
        this.tester.gotoPage("login.jsp?os_destination=%2Fsecure%2Fadmin%2Fuser%2FUserBrowser.jspa" + URLEncoder.encode(newlineChars + "http://www.atlassian.com", System.getProperty("file.encoding")));
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
        TestRedirectAfterLogin.assertEquals((String)(this.context + "/secure/Dashboard.jspa"), (String)this.getCurrentUrl());
        this.tester.assertTextPresent("jWebTest JIRA installation");
    }

    private String getCurrentUrl() {
        return this.tester.getDialog().getWebClient().getCurrentPage().getURL().toString();
    }
}

