/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.backdoor.PermissionControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
public class TestGlobalPermissions
extends FuncTestCase {
    public static final String GLOBAL_PERMISSION_COMPLETE = "com.atlassian.jira.dev.func-test-plugin:func.test.global.permission";
    public static final String GLOBAL_PERMISSION_ANNON_ALLOWED_COMPLETE = "com.atlassian.jira.dev.func-test-plugin:func.global.permission.anon.allowed";
    public static final String GLOBAL_PERMISSION = "func.test.global.permission";
    public static final String GLOBAL_PERMISSION_ANNON_ALLOWED = "func.global.permission.anon.allowed";
    private PermissionControlExt permissionsControl;

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.permissionsControl = new PermissionControlExt(this.environmentData);
        this.restartPluginModule(GLOBAL_PERMISSION_COMPLETE);
        this.restartPluginModule(GLOBAL_PERMISSION_ANNON_ALLOWED_COMPLETE);
    }

    public void testAddingGlobalPermissionToGroup() {
        this.permissionsControl.addGlobalPermissionByKey(GLOBAL_PERMISSION, "jira-users");
        MatcherAssert.assertThat(this.permissionsControl.getGlobalPermissionGroupsByKey(GLOBAL_PERMISSION), (Matcher)Matchers.hasItem((Object)"jira-users"));
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestGlobalPermissions.this.permissionsControl.addAnyoneGlobalPermissionByKey(TestGlobalPermissions.GLOBAL_PERMISSION);
                return null;
            }
        }, Response.Status.INTERNAL_SERVER_ERROR);
        this.permissionsControl.addAnyoneGlobalPermissionByKey(GLOBAL_PERMISSION_ANNON_ALLOWED);
    }

    public void testAddingPluggableGlobalPermissionWhenModuleDown() {
        this.backdoor.plugins().disablePluginModule(GLOBAL_PERMISSION_COMPLETE);
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestGlobalPermissions.this.permissionsControl.addGlobalPermissionByKey(TestGlobalPermissions.GLOBAL_PERMISSION, "jira-users");
                return null;
            }
        }, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public void testRemovingPluggableGlobalPermissionWhenModuleDown() {
        this.permissionsControl.addGlobalPermissionByKey(GLOBAL_PERMISSION, "jira-users");
        this.backdoor.plugins().disablePluginModule(GLOBAL_PERMISSION_COMPLETE);
        PropertyAssertions.assertUniformInterfaceException(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestGlobalPermissions.this.permissionsControl.removeGlobalPermissionByKey(TestGlobalPermissions.GLOBAL_PERMISSION, "jira-users");
                return null;
            }
        }, Response.Status.INTERNAL_SERVER_ERROR);
    }

    public void testGroupDoesntHavePluggableGlobalPermissionAfterModulRestart() {
        this.permissionsControl.addGlobalPermissionByKey(GLOBAL_PERMISSION, "jira-users");
        MatcherAssert.assertThat(this.permissionsControl.getGlobalPermissionGroupsByKey(GLOBAL_PERMISSION), (Matcher)Matchers.hasItem((Object)"jira-users"));
        this.backdoor.plugins().disablePluginModule(GLOBAL_PERMISSION_COMPLETE);
        TestGlobalPermissions.assertTrue((boolean)this.permissionsControl.getGlobalPermissionGroupsByKey(GLOBAL_PERMISSION).isEmpty());
        this.backdoor.plugins().enablePluginModule(GLOBAL_PERMISSION_COMPLETE);
        MatcherAssert.assertThat(this.permissionsControl.getGlobalPermissionGroupsByKey(GLOBAL_PERMISSION), (Matcher)Matchers.hasItem((Object)"jira-users"));
    }

    private void restartPluginModule(String globalPermissionModuleCompleteKey) {
        this.backdoor.plugins().disablePluginModule(globalPermissionModuleCompleteKey);
        this.backdoor.plugins().enablePluginModule(globalPermissionModuleCompleteKey);
    }
}

