/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.plugins.rest.common.security.CorsHeaders;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.core.UriBuilder;
import junit.framework.Assert;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;

@WebTest(value={Category.FUNC_TEST, Category.SECURITY})
public class TestCorsAllowedResource
extends FuncTestCase {
    private final HttpClient client = new HttpClient();
    private static final String allowedOrigin = "http://localhost:8550/";
    private static final String notAllowedOrigin = "http://localhost:8560/";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestCorsAllowedResource.xml");
    }

    public void testRequestToResourceWithCorsAllowedAnnotationFromAllowedOrigin() throws IOException, URISyntaxException {
        String requestURI = this.restURI("/rest/api/2/project").toString();
        GetMethod getRequest = new GetMethod(requestURI);
        getRequest.addRequestHeader(CorsHeaders.ORIGIN.value(), allowedOrigin);
        int statusCode = this.client.executeMethod((HttpMethod)getRequest);
        Assert.assertEquals((int)200, (int)statusCode);
        Header accessControlResponseHeader = getRequest.getResponseHeader(CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.value());
        Assert.assertEquals((String)allowedOrigin, (String)accessControlResponseHeader.getValue());
    }

    public void testRequestToResourceWithCorsAllowedAnnotationFromNotAllowedOrigin() throws IOException, URISyntaxException {
        String requestURI = this.restURI("/rest/api/2/project").toString();
        GetMethod getRequest = new GetMethod(requestURI);
        getRequest.addRequestHeader(CorsHeaders.ORIGIN.value(), notAllowedOrigin);
        int statusCode = this.client.executeMethod((HttpMethod)getRequest);
        Assert.assertEquals((int)200, (int)statusCode);
        Header accessControlResponseHeader = getRequest.getResponseHeader(CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.value());
        Assert.assertNull((Object)accessControlResponseHeader);
    }

    public void testRequestToResourceWithCorsAllowedAnnotationFromAllowedOriginWithPreflight() throws IOException, URISyntaxException {
        String requestURI = this.restURI("/rest/api/2/project").toString();
        GetMethod getRequest = new GetMethod(requestURI);
        getRequest.addRequestHeader(CorsHeaders.ORIGIN.value(), allowedOrigin);
        int statusCode = this.client.executeMethod((HttpMethod)getRequest);
        Assert.assertEquals((int)200, (int)statusCode);
        Header accessControlResponseHeader = getRequest.getResponseHeader(CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.value());
        Assert.assertNotNull((Object)accessControlResponseHeader);
    }

    public void testRequestToResourceWithCorsAllowedAnnotationFromNotAllowedOriginWithPreflight() throws IOException, URISyntaxException {
        String requestURI = this.restURI("/rest/api/2/project").toString();
        GetMethod getRequest = new GetMethod(requestURI);
        getRequest.addRequestHeader(CorsHeaders.ORIGIN.value(), notAllowedOrigin);
        int statusCode = this.client.executeMethod((HttpMethod)getRequest);
        Assert.assertEquals((int)200, (int)statusCode);
        Header accessControlResponseHeader = getRequest.getResponseHeader(CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.value());
        Assert.assertNull((Object)accessControlResponseHeader);
    }

    public void testRequestToResourceWithoutCorsAllowedAnnotationFromAllowedOrigin() throws IOException, URISyntaxException {
        this.client.getParams().setAuthenticationPreemptive(true);
        this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        String requestURI = this.restURI("/rest/internal/1.0/darkFeatures/jira.user.darkfeature.admin").toString();
        GetMethod getRequest = new GetMethod(requestURI);
        getRequest.addRequestHeader(CorsHeaders.ORIGIN.value(), allowedOrigin);
        int statusCode = this.client.executeMethod((HttpMethod)getRequest);
        Assert.assertEquals((int)200, (int)statusCode);
        Header accessControlResponseHeader = getRequest.getResponseHeader(CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.value());
        Assert.assertNull((Object)accessControlResponseHeader);
    }

    public void testRequestToResourceWithoutCorsAllowedAnnotationFromNotAllowedOrigin() throws IOException, URISyntaxException {
        this.client.getParams().setAuthenticationPreemptive(true);
        this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        String requestURI = this.restURI("/rest/internal/1.0/darkFeatures/jira.user.darkfeature.admin").toString();
        GetMethod getRequest = new GetMethod(requestURI);
        getRequest.addRequestHeader(CorsHeaders.ORIGIN.value(), notAllowedOrigin);
        int statusCode = this.client.executeMethod((HttpMethod)getRequest);
        Assert.assertEquals((int)200, (int)statusCode);
        Header accessControlResponseHeader = getRequest.getResponseHeader(CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.value());
        Assert.assertNull((Object)accessControlResponseHeader);
    }

    private URI restURI(String resourceURI) throws URISyntaxException {
        URI jiraURI = this.environmentData.getBaseUrl().toURI();
        return UriBuilder.fromUri((URI)jiraURI).path(resourceURI).build(new Object[0]);
    }
}

