/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import com.atlassian.jira.testkit.client.restclient.Response;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS, Category.ROLES})
public class TestProjectRoles
extends FuncTestCase {
    private static final String ROLE_DESC = "this is a test role";
    private static final String ROLE_NAME = "test role";
    private static final String ROLE_NAME_UPPER_CASE = "Test role";
    private static final String ROLE_UPDATED_NAME = "testing role";
    private static final String ROLE_UPDATED_DESC = "this is an updated description";
    private static final String EDIT_USER_ACTORS = "edit_10000_atlassian-user-role-actor";
    private static final String EDIT_GROUP_ACTORS = "edit_10000_atlassian-group-role-actor";
    private static final String DELETE_ROLE = "delete_test role";

    public void testProjectRoleOperations() {
        this.administration.restoreBlankInstance();
        this.administration.roles().create(ROLE_NAME, ROLE_DESC);
        this.editProjectRole(ROLE_UPDATED_NAME);
        this.editProjectRole(ROLE_NAME_UPPER_CASE);
        this.ensureErrorForDuplicateRoleName();
        this.administration.roles().delete(ROLE_NAME);
        this.text.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_NAME);
        this.text.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_DESC);
    }

    public Response addGroupToProjectRole(String groupName, String projectKey, String roleName) {
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData);
        return projectRoleClient.addActors(projectKey, roleName, new String[]{groupName}, null);
    }

    public Response addUserToProjectRole(String userName, String projectKey, String roleName) {
        ProjectRoleClient projectRoleClient = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData);
        return projectRoleClient.addActors(projectKey, roleName, null, new String[]{userName});
    }

    public void testCreateIssueWithRolePermissions() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.navigation.gotoDashboard();
        this.tester.assertLinkNotPresent("create_link");
        this.addUserToProjectRole("admin", "HSP", ROLE_NAME);
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien"});
        this.addUserToProjectRole("admin", "MKY", ROLE_NAME);
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien", "monkey"});
    }

    public void testCreateIssueWithRolePermissionsForGroup() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.navigation.gotoDashboard();
        this.tester.assertLinkNotPresent("create_link");
        this.addGroupToProjectRole("jira-administrators", "HSP", ROLE_NAME);
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien"});
        this.addGroupToProjectRole("jira-administrators", "MKY", ROLE_NAME);
        this.navigation.gotoDashboard();
        this.tester.assertLinkPresent("create_link");
        this.tester.clickLink("create_link");
        this.assertions.getProjectFieldsAssertions().assertProjectsEquals(new String[]{"homosapien", "monkey"});
    }

    public void testAddDefaultUsersAndDefaultGroupsToRole() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.addAdministratorToDefaultRole();
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.setFormElement("userNames", "detkin");
        this.tester.submit("add");
        this.text.assertTextSequence(this.locator.css(".jiraform .aui-message.error"), "detkin", "could not be found");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.setFormElement("userNames", "admin");
        this.tester.submit("add");
        this.text.assertTextSequence(this.locator.css(".jiraform .aui-message.error"), "admin", "already a member");
        this.addGroupsToDefaultRole();
        this.deleteDefaultUsersForRole();
        this.deleteDefaultGroupsForRole();
    }

    public void testDeleteProjectRoleRemovesSchemeEntries() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.deleteProjectRole(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Notifications");
        this.tester.assertTextNotPresent(ROLE_NAME);
        this.administration.permissionSchemes().defaultScheme();
        this.tester.assertTextNotPresent(ROLE_NAME);
        this.administration.issueSecuritySchemes().getScheme("Default Issue Security Scheme");
        this.tester.assertTextNotPresent(ROLE_NAME);
    }

    public void testDeleteProjectRoleWorkflowConditions() {
        this.administration.restoreData("TestProjectRoles.xml");
        this.administration.workflows().goTo().workflowSteps("Copy of jira workflow");
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Only users in project role <b>test role</b> can execute this transition.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.setFormElement("name", "");
        this.tester.clickLink(DELETE_ROLE);
        this.tester.assertTextPresent("The following <strong>1</strong> workflow actions contain conditions that rely on the project role <strong>test role</strong>. If you delete this project role, these conditions will always fail.");
        this.tester.submit("Delete");
        this.administration.workflows().goTo().workflowSteps("Copy of jira workflow");
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Project Role (id=10000) is missing, now this condition will always fail.");
        this.tester.gotoPage("/secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira+workflow&workflowMode=live");
        this.tester.selectOption("jira.projectrole.id", "Users");
        this.tester.submit("Update");
        this.tester.assertTextPresent("Only users in project role <b>Users</b> can execute this transition.");
    }

    public void testViewUsages() {
        this.administration.restoreData("TestProjectRoleViewUsages.xml");
        this.gotoViewUsagesForUsersProjectRole();
        this.assertions.getLinkAssertions().assertLinkPresentWithExactTextById("relatednotificationschemes", "Default Notification Scheme");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactTextById("relatednotificationschemes", "Other Notification Scheme");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactTextById("relatedpermissionschemes", "Default Permission Scheme");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactTextById("relatedpermissionschemes", "Other Permission Scheme");
        this.text.assertTextSequence(this.locator.table("relatedpermissionschemes"), new String[]{"Default Permission Scheme", "homosapien", "3 (View)", "monkey", "2 (View)", "test", "1 (View)", "Other Permission Scheme", "None", "None"});
        this.tester.assertLinkPresentWithText("test issue security scheme");
        this.tester.assertLinkPresentWithText("jira workflow");
        this.tester.assertLinkPresentWithText("Start Progress");
        this.tester.assertLinkPresentWithText("Stop Progress");
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.assertTextPresent("Edit Notifications &mdash; Default Notification Scheme");
        this.tester.assertLinkPresentWithText("Add notification");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Other Notification Scheme");
        this.tester.assertTextPresent("Edit Notifications &mdash; Other Notification Scheme");
        this.tester.assertLinkPresentWithText("Add notification");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Other Permission Scheme");
        this.tester.assertTextPresent("Edit Permissions &mdash; Other Permission Scheme");
        this.tester.assertLinkPresentWithText("Grant permission");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Default Permission Scheme");
        this.tester.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        this.tester.assertLinkPresentWithText("Grant permission");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("test issue security scheme");
        this.tester.assertTextPresent("Edit Issue Security Levels");
        this.tester.assertTextPresent("test security level");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Start Progress");
        this.tester.assertTextPresent("Transition: Start Progress");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("Stop Progress");
        this.tester.assertTextPresent("Transition: Stop Progress");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLinkWithText("homosapien");
        this.assertions.assertNodeByIdHasText("project-config-header-name", "homosapien");
        this.gotoViewUsagesForUsersProjectRole();
        this.tester.clickLink("view_project_role_actors_10000");
        this.tester.assertElementPresent("project-config-panel-people");
    }

    private void gotoViewUsagesForUsersProjectRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("view_Users");
    }

    private void addGroupsToDefaultRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.assertTextPresent("None selected");
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent("Assign Default Groups to Project Role: test role");
        this.tester.setFormElement("groupNames", "jira-users, jira-developers, jira-administrators");
        this.tester.submit("add");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("jira-administrators");
        this.tester.assertTextPresent("jira-users");
        this.tester.assertTextPresent("jira-developers");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Project Role Browser");
    }

    private void addAdministratorToDefaultRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.assertTextPresent("None selected.");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextPresent("Assign Default Users to Project Role: test role");
        this.tester.setFormElement("userNames", "admin, fred");
        this.tester.submit("add");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Administrator");
        this.tester.clickLink("return_link");
        this.tester.assertTextPresent("Project Role Browser");
    }

    private void deleteDefaultUsersForRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.tester.clickLink(EDIT_USER_ACTORS);
        this.tester.assertTextPresent("Assign Default Users to Project Role: test role");
        this.tester.checkCheckbox("removeusers_admin", ".");
        this.tester.checkCheckbox("removeusers_fred", ".");
        this.tester.submit("remove");
        this.tester.assertTextPresent("There are currently no users assigned to this project role.");
    }

    private void deleteDefaultGroupsForRole() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("manage_test role");
        this.deleteGroupsFromRoleForm("Assign Default Groups to Project Role: test role");
    }

    private void deleteGroupsFromRoleForm(String textPresent) {
        this.tester.clickLink(EDIT_GROUP_ACTORS);
        this.tester.assertTextPresent(textPresent);
        this.tester.checkCheckbox("removegroups_jira-users", ".");
        this.tester.checkCheckbox("removegroups_jira-developers", ".");
        this.tester.checkCheckbox("removegroups_jira-administrators", ".");
        this.tester.submit("remove");
        this.tester.assertTextPresent("There are currently no groups assigned to this project role");
    }

    private void deleteProjectRole(boolean checkAssociatedSchemes) {
        this.tester.clickLink(DELETE_ROLE);
        this.tester.assertTextPresent("Are you sure you would like to delete project role");
        this.tester.assertTextPresent(ROLE_NAME);
        if (checkAssociatedSchemes) {
            this.tester.assertLinkPresentWithText("Default Notification Scheme");
            this.tester.assertLinkPresentWithText("Default Permission Scheme");
            this.tester.assertLinkPresentWithText("Default Issue Security Scheme");
            this.tester.assertTextPresent("Copy of jira workflow");
            this.tester.assertLinkPresentWithText("Start Progress");
        }
        this.tester.submit("Delete");
        this.text.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_NAME);
        this.text.assertTextNotPresent(this.locator.id("project-role-test role"), ROLE_DESC);
    }

    private void ensureErrorForDuplicateRoleName() {
        this.tester.setFormElement("name", ROLE_NAME);
        this.tester.setFormElement("description", "");
        this.tester.submit("Add Project Role");
        this.tester.assertTextPresent("A project role with name &#39;test role&#39; already exists.");
    }

    private void ensureErrorForDuplicateRoleNameOnEdit() {
        this.tester.clickLink("project_role_browser");
        this.tester.setFormElement("name", "anotherRole");
        this.tester.setFormElement("description", "test");
        this.tester.submit("Add Project Role");
        this.tester.clickLink("edit_anotherRole");
        this.tester.setFormElement("name", ROLE_NAME);
        this.tester.submit("Update");
        this.tester.assertTextPresent("A project role with name &#39;test role&#39; already exists.");
    }

    private void editProjectRole(String newRoleName) {
        this.administration.roles().edit(ROLE_NAME).setName(newRoleName);
        this.administration.roles().edit(newRoleName).setDescription(ROLE_UPDATED_DESC);
        this.tester.assertTextPresent(newRoleName);
        this.tester.assertTextPresent(ROLE_UPDATED_DESC);
        this.administration.roles().edit(newRoleName).setName(ROLE_NAME);
        this.administration.roles().edit(ROLE_NAME).setDescription(ROLE_DESC);
    }
}

