/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.PROJECTS})
public class TestProjectKeyEditOnSearch
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
    }

    public void testCanSearchProjectByHistoricalKeys() {
        long projectId = this.backdoor.project().addProject("Test", "ABC", "admin");
        this.backdoor.issues().createIssue("ABC", "test issue");
        this.backdoor.project().editProjectKey(projectId, "XYZ");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = ABC"));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("XYZ-1")));
    }

    public void testCanSearchProjectExcludingHistoricalKeys() {
        this.backdoor.project().addProject("Monkey 2", "TST", "admin");
        this.backdoor.issues().createIssue("TST", "test issue 1");
        long projectId = this.backdoor.project().addProject("Test", "ABC", "admin");
        this.backdoor.issues().createIssue("ABC", "test issue 2");
        this.backdoor.project().editProjectKey(projectId, "XYZ");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project != ABC"));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("TST-1")));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.not((Matcher)Matchers.contains(this.issue("XYZ-1"))));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.not((Matcher)Matchers.contains(this.issue("ABC-1"))));
    }

    public void testCanSearchIssueByHistoricalKeys() {
        long projectId = this.backdoor.project().addProject("Test", "ABC", "admin");
        this.backdoor.issues().createIssue("ABC", "test issue");
        this.backdoor.issues().createIssue("ABC", "test issue");
        this.backdoor.issues().createIssue("ABC", "test issue");
        this.backdoor.project().editProjectKey(projectId, "XYZ");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("issue = ABC-1"));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)1));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("XYZ-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("issue != ABC-1"));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)searchResult.issues, this.containsExpectedIssues());
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("issue > ABC-1"));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)2));
        Assert.assertThat((Object)searchResult.issues, this.containsExpectedIssues());
    }

    private Matcher<Iterable<Issue>> containsExpectedIssues() {
        return Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.issue("XYZ-2"), this.issue("XYZ-3")});
    }

    private BaseMatcher<Issue> issue(final String key) {
        return new BaseMatcher<Issue>(){

            public boolean matches(Object item) {
                return ((Issue)item).key.equals(key);
            }

            public void describeTo(Description description) {
                description.appendText("Issue with: key=").appendValue((Object)key);
            }
        };
    }
}

