/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.EntityRefBean;
import java.util.ArrayList;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.APP_LINKS, Category.PROJECTS})
public class TestProjectKeyEditOnEntityLinks
extends FuncTestCase {
    public void testCanSearchProjectByHistoricalKeys() {
        this.administration.restoreData("TestProjectKeyEditOnEntityLinks.xml");
        long projectId = this.backdoor.project().getProjectId("ABC");
        this.backdoor.project().editProjectKey(projectId, "TST");
        ArrayList entities = this.backdoor.project().getEntityLinks((Long)Long.valueOf((long)projectId)).entities;
        Assert.assertThat((Object)entities.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        Matcher hasItems = CoreMatchers.hasItems((Matcher[])new Matcher[]{this.entity("TT", "Jira TEST", "JiraApplicationType"), this.entity("CR-TEST", "Crucible TEST", "FishEyeCrucibleApplicationType"), this.entity("TEST", "FishEye TEST", "FishEyeCrucibleApplicationType")});
        Assert.assertThat((Object)entities, (Matcher)hasItems);
    }

    private Matcher<EntityRefBean> entity(final String key, final String name, final String type) {
        return new BaseMatcher<EntityRefBean>(){

            public boolean matches(Object item) {
                if (!(item instanceof EntityRefBean)) {
                    return false;
                }
                EntityRefBean entity = (EntityRefBean)item;
                return entity.key.equals(key) && entity.name.equals(name) && entity.type.applicationTypeClassName.contains(type);
            }

            public void describeTo(Description description) {
                description.appendText(String.format("entity with key: %s, name: %s, type: %s", key, name, type));
            }
        };
    }
}

