/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.assertions.LinkAssertions;
import com.atlassian.jira.functest.framework.assertions.LinkAssertionsImpl;
import com.atlassian.jira.functest.framework.parser.SystemInfoParserImpl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.AndCell;
import com.atlassian.jira.webtests.table.ImageCell;
import com.atlassian.jira.webtests.table.LinkCell;
import com.atlassian.jira.webtests.table.TextCell;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.COMPONENTS_AND_VERSIONS, Category.PROJECTS})
public class TestProjectComponentQuickSearch
extends JIRAWebTest {
    String appServer;
    private LinkAssertions linkAssertions;

    public TestProjectComponentQuickSearch(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestProjectComponentQuickSearch.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        SystemInfoParserImpl systemInfoParser = new SystemInfoParserImpl(this.getTester(), this.navigation);
        this.appServer = systemInfoParser.getSystemInfo().getAppServer();
        this.linkAssertions = new LinkAssertionsImpl(this.tester, this.getEnvironmentData());
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    public void testProjectComponentQuickSearchMultipleProjects() throws Exception {
        WebTable issueTable = this.assertComponentQuickSearch("", 5);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("c:one", 1);
        this.assertIssueTableHasHSP_12345(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced(" c:two ", 2);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("three c:three", 3);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_35(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("c:four four", 4);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("five c:five five", 5);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
    }

    public void testProjectComponentQuickSearchHomosapienProject() throws Exception {
        WebTable issueTable = this.assertComponentQuickSearch("hsp c:one", 1);
        this.assertIssueTableHasHSP_12345(issueTable);
        issueTable = this.assertComponentQuickSearch(" c:two homosapien ", 2);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        issueTable = this.assertComponentQuickSearch("three HSP c:three", 2);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        issueTable = this.assertComponentQuickSearch("c:four four HOMOSAPIEN", 3);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
        issueTable = this.assertComponentQuickSearch("hsp five c:five five", 3);
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
    }

    public void testProjectComponentQuickSearchMonkey() throws Exception {
        WebTable issueTable = this.assertComponentQuickSearch("c:one MONKEY", 2);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        issueTable = this.assertComponentQuickSearch(" MKY c:two ", 2);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        issueTable = this.assertComponentQuickSearch("monkey three c:three", 1);
        this.assertIssueTableHasMKY_35(issueTable);
        issueTable = this.assertComponentQuickSearch("c:four mky four", 1);
        this.assertIssueTableHasMKY_45(issueTable);
        issueTable = this.assertComponentQuickSearch("five c:five five monkey", 2);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
    }

    private WebTable assertComponentQuickSearch(String searchInput, int numOfResults) throws SAXException {
        this.runQuickSearch(searchInput);
        this.assertIssueNavigatorDisplaying("1", String.valueOf(numOfResults), String.valueOf(numOfResults));
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        TestProjectComponentQuickSearch.assertEquals((int)(numOfResults + 1), (int)issueTable.getRowCount());
        this.assertTableHasMatchingRowFromTo(issueTable, 0, 1, new Object[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due"});
        return issueTable;
    }

    private WebTable assertComponentQuickSearchOnAdvanced(String searchInput, int numOfResults) throws SAXException {
        this.runQuickSearch(searchInput);
        this.assertAdvacnedIssueNavigatorDisplaying("1", String.valueOf(numOfResults), String.valueOf(numOfResults));
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        TestProjectComponentQuickSearch.assertEquals((int)(numOfResults + 1), (int)issueTable.getRowCount());
        this.assertTableHasMatchingRowFromTo(issueTable, 0, 1, new Object[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due"});
        return issueTable;
    }

    private void assertAdvacnedIssueNavigatorDisplaying(String from, String to, String of) {
        this.assertTextPresent("<span class=\"results-count-start\">" + from + "</span>&ndash;<span class=\"results-count-end\">" + to + "</span> of <span class=\"results-count-total results-count-link\">" + of + "</span>");
    }

    private void assertIssueTableHasHSP_45(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/HSP-1", ""), new ImageCell("/images/icons/issuetypes/bug.png")), new LinkCell("/browse/HSP-1", "HSP-1"), "homo four five", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.png"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasHSP_12345(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/HSP-2", ""), new ImageCell("/images/icons/issuetypes/task.png")), new LinkCell("/browse/HSP-2", "HSP-2"), "one two homo three four five", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.png"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasHSP_2345(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/HSP-3", ""), new ImageCell("/images/icons/issuetypes/improvement.png")), new LinkCell("/browse/HSP-3", "HSP-3"), "two three homo four five", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.png"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasMKY_35(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/MKY-2", ""), new ImageCell("/images/icons/issuetypes/newfeature.png")), new LinkCell("/browse/MKY-2", "MKY-2"), "three monk five", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.png"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasMKY_45(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/MKY-1", ""), new ImageCell("/images/icons/issuetypes/bug.png")), new LinkCell("/browse/MKY-1", "MKY-1"), "monk five four", "Administrator", "Administrator", new ImageCell("/images/icons/priorities/major.png"), new TextCell("Open"), "Unresolved", "23/Nov/07", "23/Nov/07", ""});
    }
}

