/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
public class TestProjectCategory
extends JIRAWebTest {
    private static final String CATEGORY_NAME = "New Project Category For Testing";
    private static final String CATEGORY_DESCRIPTION = "Testing for project category";

    public TestProjectCategory(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreBlankInstance();
    }

    public void testProjectCategory() {
        this.administration.project().addProject("homosapien", "HSP", "admin");
        this.projectCategoryAddProjectCategory();
        this.projectCategoryDeleteProjectCategory();
        this.projectCategoryPlaceProjectInProjectCategory();
        this.projectCategoryAddDuplicateCategory();
        this.projectCategoryAddInvalidCategory();
        this.placeProjectInCategory("homosapien", "None");
        this.deleteProjectCategory(CATEGORY_NAME);
    }

    public void projectCategoryAddProjectCategory() {
        TestProjectCategory.log("Project Category: Add project category");
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.assertTextPresent(CATEGORY_NAME);
    }

    public void projectCategoryDeleteProjectCategory() {
        TestProjectCategory.log("Project Category: Delete project category");
        this.deleteProjectCategory(CATEGORY_NAME);
        this.assertTextNotPresent(CATEGORY_NAME);
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
    }

    public void projectCategoryPlaceProjectInProjectCategory() {
        TestProjectCategory.log("Project Category: Place a project in a project category");
        this.placeProjectInCategory("homosapien", CATEGORY_NAME);
        Assert.assertThat((Object)this.backdoor.project().getProjectCategoryName("HSP"), (Matcher)CoreMatchers.equalTo((Object)CATEGORY_NAME));
    }

    public void projectCategoryAddDuplicateCategory() {
        TestProjectCategory.log("Project Category: Attempt to create a project category with a duplicate name");
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("The project category 'New Project Category For Testing' already exists");
    }

    public void projectCategoryAddInvalidCategory() {
        TestProjectCategory.log("Project Category: Attempt to create a project category with an invalid name");
        this.createProjectCategory("", "");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Please specify a name");
    }
}

