/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.PROJECTS})
public class TestEditProjectLeadAndDefaultAssignee
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestEditProject.xml");
    }

    public void testProjectDoesNotExistAdmin() throws Exception {
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=999999");
        this.tester.assertTextPresent("There is not a project with the specified id. Perhaps it was deleted.");
    }

    public void testProjectDoesNotExistNonAdmin() throws Exception {
        this.navigation.logout();
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=999999");
        this.tester.assertTextPresent("You must log in to access this page.");
        this.navigation.login("gandhi");
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=999999");
        this.tester.assertTextPresent("Access Denied");
        this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
        this.tester.assertTextNotPresent("You cannot view this URL as a guest.");
    }

    public void testEditProjectSuccess() {
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project dog = pc.get("DOG");
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"DOG", (String)dog.key);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"Canine", (String)dog.name);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"", (String)dog.description);
        TestEditProjectLeadAndDefaultAssignee.assertEquals(null, (String)dog.url);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"murray", (String)dog.lead.name);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((Object)Project.AssigneeType.PROJECT_LEAD, (Object)dog.assigneeType);
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10020");
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "project-edit-lead-and-default-assignee", "Update");
        formParameterUtil.addOptionToHtmlSelect("lead", new String[]{"admin"});
        formParameterUtil.setFormElement("lead", "admin");
        formParameterUtil.submitForm();
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10020");
        this.tester.setFormElement("lead", "admin");
        this.tester.selectOption("assigneeType", "Unassigned");
        this.tester.submit("Update");
        dog = pc.get("DOG");
        Assert.assertThat((Object)dog.name, (Matcher)CoreMatchers.equalTo((Object)"Canine"));
        Project newDog = pc.get("DOG");
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"DOG", (String)newDog.key);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"Canine", (String)newDog.name);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"", (String)newDog.description);
        TestEditProjectLeadAndDefaultAssignee.assertEquals(null, (String)newDog.url);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"admin", (String)newDog.lead.name);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((Object)Project.AssigneeType.UNASSIGNED, (Object)newDog.assigneeType);
    }

    public void testEditProjectChangeNothing() {
        this.tester.gotoPage("secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=10020");
        this.tester.assertTextPresent("Edit Project Lead and Default Assignee for Project: Canine");
        this.tester.setFormElement("lead", "murray");
        this.tester.selectOption("assigneeType", "Project Lead");
        this.tester.submit("Update");
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project dog = pc.get("DOG");
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"DOG", (String)dog.key);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"Canine", (String)dog.name);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"", (String)dog.description);
        TestEditProjectLeadAndDefaultAssignee.assertEquals(null, (String)dog.url);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((String)"murray", (String)dog.lead.name);
        TestEditProjectLeadAndDefaultAssignee.assertEquals((Object)Project.AssigneeType.PROJECT_LEAD, (Object)dog.assigneeType);
    }
}

