/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.ADMINISTRATION, Category.SCHEMES, Category.PERMISSIONS, Category.PROJECTS, Category.ISSUE_TYPES, Category.SCREENS, Category.FIELDS, Category.CUSTOM_FIELDS, Category.SECURITY})
public class TestDeleteProject
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestDeleteProject.xml");
    }

    public void testDeleteProjectNoPermission() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/project/DeleteProject.jspa?pid=10000&confirm=true&returnUrl=ViewProjects.jspa");
        this.tester.assertTextPresent("Welcome to jWebTest JIRA installation");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.assertTextPresent("homosapien");
    }

    public void testDeleteProject() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.assertTextPresent("homosapien");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextPresent("Test issue 1");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertTextPresent("JIRA needs to be more Web 2.0");
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("delete_project_10000");
        this.tester.assertTextPresent("Delete Project: homosapien");
        this.tester.submit("Delete");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.assertTextPresent("Notification Schemes");
        this.tester.assertTextPresent("The table below shows the notification schemes currently configured for this server");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.assertTextPresent("Permission Schemes");
        this.tester.assertTextPresent("Permission Schemes allow you to create a set of permissions and apply this set of permissions to any project.");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.assertTextPresent("Custom Fields");
        this.tester.assertTextNotPresent("homosapien");
        this.tester.assertTextPresent("Not configured for any context");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextPresent("The issue you are trying to view does not exist.");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertTextPresent("The issue you are trying to view does not exist.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.assertTextPresent("Issue Security Schemes allow you to control who can and cannot view issues.");
        this.tester.assertTextNotPresent("homosapien");
        WorkflowSchemeData customerWorflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Customer workflow");
        TestDeleteProject.assertNotNull((Object)customerWorflowScheme);
        TestDeleteProject.assertFalse((boolean)customerWorflowScheme.isActive());
        WorkflowSchemeData copyOfCustomerWorkflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of Customer workflow");
        TestDeleteProject.assertNotNull((Object)copyOfCustomerWorkflowScheme);
        TestDeleteProject.assertFalse((boolean)copyOfCustomerWorkflowScheme.isActive());
        TestDeleteProject.assertEquals((String)"(This copy was automatically generated from a draft, when workflow scheme 'Customer workflow' was made inactive.)", (String)copyOfCustomerWorkflowScheme.getDescription());
        TestDeleteProject.assertEquals((Object)draft.getMappings(), (Object)copyOfCustomerWorkflowScheme.getMappings());
        this.assertNoDraft("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.tester.assertTextPresent("The table below shows the current Field Configuration Schemes and the projects they are associated with.");
        this.tester.assertTextNotPresent("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.ISSUE_TYPE_SCREEN_SCHEME);
        this.text.assertTextPresent(this.locator.css("h2"), "Issue Type Screen Schemes");
        this.tester.assertTextNotPresent("homosapien");
    }

    public void testDeleteProjectNotExists() {
        this.navigation.gotoAdmin();
        this.tester.gotoPage("secure/project/DeleteProject.jspa?pid=20000&confirm=true&returnUrl=ViewProjects.jspa&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent("Delete Project");
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Project with id '20,000' does not exist. Perhaps it was deleted?");
    }

    public void testDeleteProjectWithoutWorkflowSchemeDraft() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("delete_project_10010");
        this.tester.assertTextPresent("Delete Project: without draft WF scheme");
        this.tester.submit("Delete");
        this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOW_SCHEMES);
        this.tester.assertTextPresent("Workflow Schemes allow you to define which workflows apply to given issue types and projects.");
        this.tester.assertTextNotPresent("without draft WF scheme");
        this.tester.assertTextNotPresent("Copy of ");
        WorkflowSchemeData customerWorflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("without draft WF scheme");
        TestDeleteProject.assertNull((Object)customerWorflowScheme);
        WorkflowSchemeData copyOfCustomerWorkflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of without draft WF scheme");
        TestDeleteProject.assertNull((Object)copyOfCustomerWorkflowScheme);
        this.assertNoDraft("without draft WF scheme");
    }

    public void testDeleteProjectWithWorkflowSchemeDraftWithTheSameNameAsExistingWorkflowScheme() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        this.testDraftCopyRenaming("Copy of Customer workflow", "Customer workflow", "Copy 2 of Customer workflow");
    }

    public void testDeleteProjectWithWorkflowSchemeDraftWithTheSameNameAsExistingWorkflowSchemeAbbreviating() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        String existingSchemeName = "Copy of " + StringUtils.repeat((String)"1", (int)244) + "...";
        String originalSchemeName = StringUtils.repeat((String)"1", (int)255);
        String expectedCopyName = "Copy 2 of " + StringUtils.repeat((String)"1", (int)242) + "...";
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName(originalSchemeName));
        this.administration.project().associateWorkflowScheme("homosapien", originalSchemeName);
        this.administration.project().createWorkflowSchemeDraft("HSP");
        this.testDraftCopyRenaming(existingSchemeName, originalSchemeName, expectedCopyName);
    }

    private void testDraftCopyRenaming(String existingSchemeName, String originalSchemeName, String expectedCopyName) {
        this.backdoor.workflowSchemes().createScheme(new WorkflowSchemeData().setName(existingSchemeName));
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("delete_project_10000");
        this.tester.assertTextPresent("Delete Project: homosapien");
        this.tester.submit("Delete");
        WorkflowSchemeData originalScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound(originalSchemeName);
        TestDeleteProject.assertNotNull((Object)originalScheme);
        TestDeleteProject.assertFalse((boolean)originalScheme.isActive());
        WorkflowSchemeData existingScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound(existingSchemeName);
        TestDeleteProject.assertNotNull((Object)existingScheme);
        TestDeleteProject.assertFalse((boolean)existingScheme.isActive());
        WorkflowSchemeData copiedScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound(expectedCopyName);
        TestDeleteProject.assertNotNull((Object)copiedScheme);
        TestDeleteProject.assertFalse((boolean)copiedScheme.isActive());
        TestDeleteProject.assertEquals((String)("(This copy was automatically generated from a draft, when workflow scheme '" + originalSchemeName + "' was made inactive.)"), (String)copiedScheme.getDescription());
        TestDeleteProject.assertEquals((Object)draft.getMappings(), (Object)copiedScheme.getMappings());
        this.assertNoDraft("homosapien");
    }

    public void testDeleteProjectWithWorkflowSchemeDraftUsedByAnotherProject() {
        this.administration.restoreData("TestDeleteProjectEnterprise.xml");
        this.administration.project().associateWorkflowScheme("monkey", "Customer workflow");
        WorkflowSchemeData draftBeforeDelete = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("homosapien");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.tester.clickLink("delete_project_10000");
        this.tester.assertTextPresent("Delete Project: homosapien");
        this.tester.submit("Delete");
        WorkflowSchemeData copyOfCustomerWorkflowScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByNameNullIfNotFound("Copy of Customer workflow");
        TestDeleteProject.assertNull((Object)copyOfCustomerWorkflowScheme);
        WorkflowSchemeData draftAfterDelete = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound("monkey");
        TestDeleteProject.assertNotNull((Object)draftAfterDelete);
        TestDeleteProject.assertEquals((Object)draftBeforeDelete.getId(), (Object)draftAfterDelete.getId());
        TestDeleteProject.assertEquals((String)draftBeforeDelete.getName(), (String)draftAfterDelete.getName());
        TestDeleteProject.assertEquals((String)draftBeforeDelete.getDescription(), (String)draftAfterDelete.getDescription());
        TestDeleteProject.assertEquals((Object)draftBeforeDelete.getMappings(), (Object)draftAfterDelete.getMappings());
    }

    private void assertNoDraft(String projectName) {
        WorkflowSchemeData draft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound(projectName);
        TestDeleteProject.assertNull((Object)draft);
    }
}

