/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable.enabling;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import java.io.IOException;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN, Category.SLOW_IMPORT})
public class TestRestModuleEnabling
extends AbstractReloadablePluginsTest {
    private static final String REFERENCE_PLUGIN_REST_ENDPOINT_URL = "/rest/reference-plugin/1.0/endpoint";

    public void testShouldNotExistAndBeAccessibleBeforeEnablingThePlugin() throws Exception {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.tester.gotoPage(REFERENCE_PLUGIN_REST_ENDPOINT_URL);
        TestRestModuleEnabling.assertEquals((int)this.tester.getDialog().getResponse().getResponseCode(), (int)404);
    }

    public void testShouldBeReachableAfterEnablingTheReferencePlugin() throws IOException, JSONException {
        this.administration.plugins().referencePlugin().enable();
        this.tester.gotoPage(REFERENCE_PLUGIN_REST_ENDPOINT_URL);
        JSONObject endpointJSONResponse = new JSONObject(this.tester.getDialog().getResponse().getText());
        TestRestModuleEnabling.assertEquals((Object)endpointJSONResponse.get("endpoint"), (Object)false);
    }

    private static class NoSuchEndpoint {
        public static final int CODE = 404;

        private NoSuchEndpoint() {
        }
    }
}

