/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable.disabling;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import org.junit.Ignore;

@WebTest(value={Category.FUNC_TEST, Category.PLUGINS, Category.REFERENCE_PLUGIN, Category.SLOW_IMPORT})
public class TestComponentModuleTypeDisabling
extends AbstractReloadablePluginsTest {
    private static final String REFERENCE_COMPONENT_MODULE_KEY = ReferencePluginConstants.REFERENCE_PLUGIN_KEY + ":reference-component";

    public void testShouldBeAbleToDisableAPluginContainingAComponentModuleType() {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referencePlugin().disable();
        TestComponentModuleTypeDisabling.assertTrue((boolean)this.administration.plugins().referencePlugin().isDisabled());
    }

    public void testShouldNotBeAbleToDisableAComponentModuleTypeIndividually() {
        this.administration.plugins().referencePlugin().enable();
        TestComponentModuleTypeDisabling.assertFalse((boolean)this.canDisableReferenceComponentModule());
    }

    @Ignore(value="ohernandez -- Don B. says that this is the behaviour that is expected, but in practice it appears that it is not. Ignoring until we get more feedback from Don")
    public void testDisablingAPluginThatContainsAPublicComponentShouldCauseDependantPluginsToBeDisabled() {
        this.administration.plugins().referencePlugin().enable();
        this.administration.plugins().referenceDependentPlugin().enable();
        this.administration.plugins().referencePlugin().disable();
        TestComponentModuleTypeDisabling.assertTrue((boolean)this.administration.plugins().referencePlugin().isDisabled());
        TestComponentModuleTypeDisabling.assertTrue((boolean)this.administration.plugins().referenceDependentPlugin().isDisabled());
    }

    private boolean canDisableReferenceComponentModule() {
        return this.administration.plugins().canDisablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, REFERENCE_COMPONENT_MODULE_KEY);
    }
}

