/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.admin.plugins.WorkflowValidator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadableWorkflowComponentTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.WorkflowTestConstants;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN, Category.WORKFLOW, Category.SLOW_IMPORT})
public class TestWorkflowValidatorModuleReloadability
extends AbstractReloadableWorkflowComponentTest {
    private static final String TEST_ISSUE_NAME = "Test issue";
    private WorkflowValidator workflowValidator;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.workflowValidator = this.administration.plugins().referencePlugin().workflowValidator();
        this.setUpTestWorkflow();
    }

    public void testShouldNotBeVisibleInTheAdminWorkflowsSectionGivenPluginNotEnabled() throws Exception {
        this.assertWorkflowValidatorNotAccessible();
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenPluginEnabled() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.assertWorkflowValidatorAccessible();
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenTrueReturnValue() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpWorkflowValidator(true);
        this.text.assertTextSequence(this.transitionTableTabLocator(), this.workflowValidator.moduleName(), "will always validate as true");
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenFalseReturnValue() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpWorkflowValidator(false);
        this.text.assertTextSequence(this.transitionTableTabLocator(), this.workflowValidator.moduleName(), "will always validate as false");
    }

    public void testShouldBeExecutedOnViewIssueAndAllowTransition() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpWorkflowValidator(true);
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", TEST_ISSUE_NAME);
        this.assertStartProgressTransitionIsExecuted(issueKey);
    }

    public void testShouldBeExecutedOnViewIssueAndPreventTransition() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpWorkflowValidator(false);
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", TEST_ISSUE_NAME);
        this.assertStartProgressTransitionIsNotExecuted(issueKey);
    }

    public void testShouldBeAccessibleAfterReferencePluginEnablingAndDisabling() {
        this.referencePlugin.enable();
        this.assertWorkflowValidatorAccessible();
        this.referencePlugin.disable();
        this.assertWorkflowValidatorNotAccessible();
        this.referencePlugin.enable();
        this.assertWorkflowValidatorAccessible();
    }

    public void testShouldBeAccessibleAfterReferenceWorkflowValidatorModuleDisablingAndEnabling() {
        this.referencePlugin.enable();
        this.assertWorkflowValidatorAccessible();
        for (int i = 0; i < 3; ++i) {
            this.workflowValidator.disable();
            this.assertWorkflowValidatorNotAccessible();
            this.workflowValidator.enable();
            this.assertWorkflowValidatorAccessible();
        }
    }

    private void assertWorkflowValidatorAccessible() {
        TestWorkflowValidatorModuleReloadability.assertTrue((boolean)this.workflowValidator.canAddTo(WorkflowTestConstants.TEST_WORKFLOW_NAME, 1, 4));
    }

    private void assertWorkflowValidatorNotAccessible() {
        TestWorkflowValidatorModuleReloadability.assertFalse((boolean)this.workflowValidator.canAddTo(WorkflowTestConstants.TEST_WORKFLOW_NAME, 1, 4));
    }

    private void setUpWorkflowValidator(boolean result) {
        this.workflowValidator.addTo(WorkflowTestConstants.TEST_WORKFLOW_NAME, 1, 4, (Map<String, String>)ImmutableMap.of((Object)WorkflowTestConstants.REFERENCE_MODULE_RESULT_PARAM, (Object)Boolean.toString(result)));
    }

    private void assertStartProgressTransitionIsExecuted(String issueKey) {
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage(issueKey);
        this.tester.clickLink(WorkflowTestConstants.START_PROGRESS_LINK_ID);
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage(issueKey);
        this.assertions.getViewIssueAssertions().assertStatus("In Progress");
    }

    private void assertStartProgressTransitionIsNotExecuted(String issueKey) {
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage(issueKey);
        this.tester.clickLink(WorkflowTestConstants.START_PROGRESS_LINK_ID);
        this.assertions.getJiraMessageAssertions().assertHasMessage("Workflow Error");
        this.assertions.getJiraMessageAssertions().assertHasMessage(ReferencePluginConstants.REFERENCE_WORKFLOW_VALIDATOR_ERROR_MESSAGE);
    }

    private Locator transitionTableTabLocator() {
        return this.locator.id(WorkflowTestConstants.TRANSITION_TAB_TABLE_ID);
    }
}

