/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.admin.plugins.WorkflowFunction;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadableWorkflowComponentTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.WorkflowTestConstants;
import java.util.Collections;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN, Category.WORKFLOW, Category.SLOW_IMPORT})
public class TestWorkflowFunctionModuleReloadability
extends AbstractReloadableWorkflowComponentTest {
    private WorkflowFunction workflowFunction;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.workflowFunction = this.administration.plugins().referencePlugin().workflowFunction();
        this.setUpTestWorkflow();
    }

    public void testShouldNotBeVisibleInTheAdminWorkflowsSectionGivenPluginNotEnabled() throws Exception {
        this.assertWorkflowFunctionNotAccessible();
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenPluginEnabled() throws Exception {
        this.referencePlugin.enable();
        this.assertWorkflowFunctionAccessible();
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionAfterAddingGivenPluginEnabled() throws Exception {
        this.referencePlugin.enable();
        this.setUpWorkflowFunction();
        this.text.assertTextPresent(this.transitionTableTabLocator(), this.workflowFunction.moduleName());
    }

    public void testShouldBeExecutedOnIssueTransitionGivenPluginEnabled() throws Exception {
        this.referencePlugin.enable();
        this.setUpWorkflowFunction();
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test issue");
        this.startProgress();
        this.assertFunctionAppliedOnIssueTransition(issueKey);
    }

    public void testShouldBeAccessibleAfterReferencePluginEnablingAndDisabling() {
        this.referencePlugin.enable();
        this.assertWorkflowFunctionAccessible();
        this.referencePlugin.disable();
        this.assertWorkflowFunctionNotAccessible();
        this.referencePlugin.enable();
        this.assertWorkflowFunctionAccessible();
    }

    public void testShouldBeAccessibleAfterReferenceWorkflowFunctionModuleDisablingAndEnabling() {
        this.referencePlugin.enable();
        this.assertWorkflowFunctionAccessible();
        for (int i = 0; i < 3; ++i) {
            this.disableReferenceWorkflowFunctionModule();
            this.assertWorkflowFunctionNotAccessible();
            this.enableReferenceWorkflowFunctionModule();
            this.assertWorkflowFunctionAccessible();
        }
    }

    private void assertWorkflowFunctionAccessible() {
        TestWorkflowFunctionModuleReloadability.assertTrue((boolean)this.workflowFunction.canAddTo(WorkflowTestConstants.TEST_WORKFLOW_NAME, 1, 4));
    }

    private void assertWorkflowFunctionNotAccessible() {
        TestWorkflowFunctionModuleReloadability.assertFalse((boolean)this.workflowFunction.canAddTo(WorkflowTestConstants.TEST_WORKFLOW_NAME, 1, 4));
    }

    private void setUpWorkflowFunction() {
        this.workflowFunction.addTo(WorkflowTestConstants.TEST_WORKFLOW_NAME, 1, 4);
    }

    private String workflowFunctionComment(String issueKey) {
        return String.format("[ReferenceWorkflowFunction] transition ID %d of issue %s by %s", 4, issueKey, "admin");
    }

    private void assertFunctionAppliedOnIssueTransition(String issueKey) {
        this.assertions.comments(Collections.singletonList(this.workflowFunctionComment(issueKey))).areVisibleTo("admin", issueKey);
    }

    private void startProgress() {
        this.tester.clickLink(WorkflowTestConstants.START_PROGRESS_LINK_ID);
    }

    private Locator transitionTableTabLocator() {
        return this.locator.id(WorkflowTestConstants.TRANSITION_TAB_TABLE_ID);
    }

    private void enableReferenceWorkflowFunctionModule() {
        this.workflowFunction.enable();
    }

    private void disableReferenceWorkflowFunctionModule() {
        this.workflowFunction.disable();
    }
}

