/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.admin.plugins.WorkflowCondition;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadableWorkflowComponentTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.WorkflowTestConstants;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Ignore;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN, Category.WORKFLOW, Category.SLOW_IMPORT})
public class TestWorkflowConditionModuleReloadability
extends AbstractReloadableWorkflowComponentTest {
    private static final String TEST_ISSUE_NAME = "Test issue";
    private WorkflowCondition workflowCondition;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.workflowCondition = this.administration.plugins().referencePlugin().workflowCondition();
        this.setUpTestWorkflow();
    }

    public void testShouldNotBeVisibleInTheAdminWorkflowsSectionGivenPluginNotEnabled() throws Exception {
        this.assertWorkflowConditionNotAccessible();
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenPluginEnabled() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.assertWorkflowConditionAccessible();
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenTrueCondition() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpWorkflowCondition(true);
        this.text.assertTextSequence(this.transitionTableTabLocator(), this.workflowCondition.moduleName(), "will always return true");
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenFalseCondition() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpWorkflowCondition(false);
        this.text.assertTextSequence(this.transitionTableTabLocator(), this.workflowCondition.moduleName(), "will always return false");
    }

    public void testShouldBeExecutedOnViewIssueAndReturnTrue() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpWorkflowCondition(true);
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        this.navigation.issue().createIssue("homosapien", "Bug", TEST_ISSUE_NAME);
        this.assertStartProgressTransitionPresent();
    }

    public void testShouldBeExecutedOnViewIssueAndReturnFalse() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpWorkflowCondition(false);
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        this.navigation.issue().createIssue("homosapien", "Bug", TEST_ISSUE_NAME);
        this.assertStartProgressTransitionNotPresent();
    }

    public void testShouldBeAccessibleAfterReferencePluginEnablingAndDisabling() {
        this.administration.plugins().referencePlugin().enable();
        this.assertWorkflowConditionAccessible();
        this.administration.plugins().referencePlugin().disable();
        this.assertWorkflowConditionNotAccessible();
        this.administration.plugins().referencePlugin().enable();
        this.assertWorkflowConditionAccessible();
    }

    public void testShouldBeAccessibleAfterReferenceWorkflowModuleDisablingAndEnabling() {
        this.administration.plugins().referencePlugin().enable();
        this.assertWorkflowConditionAccessible();
        for (int i = 0; i < 3; ++i) {
            this.disableReferenceWorkflowConditionModule();
            this.assertWorkflowConditionNotAccessible();
            this.enableReferenceWorkflowConditionModule();
            this.assertWorkflowConditionAccessible();
        }
    }

    @Ignore(value="pending http://jira.atlassian.com/browse/JRA-23885 -- dkordonski")
    public void testConditionShouldNotBeExecutedWhenAddedToAnIssueAndTheReferencePluginSubsequentlyDisabled() {
        this.administration.plugins().referencePlugin().enable();
        this.setUpWorkflowCondition(false);
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        this.navigation.issue().createIssue("homosapien", "Bug", TEST_ISSUE_NAME);
        this.assertStartProgressTransitionNotPresent();
        this.administration.plugins().referencePlugin().disable();
        this.navigation.issue().gotoIssue("HSP-1");
        this.assertStartProgressTransitionPresent();
    }

    private void assertWorkflowConditionNotAccessible() {
        TestWorkflowConditionModuleReloadability.assertFalse((boolean)this.workflowCondition.canAddTo(WorkflowTestConstants.TEST_WORKFLOW_NAME, 1, 4));
    }

    private void assertWorkflowConditionAccessible() {
        TestWorkflowConditionModuleReloadability.assertTrue((boolean)this.workflowCondition.canAddTo(WorkflowTestConstants.TEST_WORKFLOW_NAME, 1, 4));
    }

    private void setUpWorkflowCondition(boolean result) {
        this.workflowCondition.addTo(WorkflowTestConstants.TEST_WORKFLOW_NAME, 1, 4, (Map<String, String>)ImmutableMap.of((Object)WorkflowTestConstants.REFERENCE_MODULE_RESULT_PARAM, (Object)Boolean.toString(result)));
    }

    private void assertStartProgressTransitionPresent() {
        this.tester.assertLinkPresent(WorkflowTestConstants.START_PROGRESS_LINK_ID);
    }

    private void assertStartProgressTransitionNotPresent() {
        this.tester.assertLinkNotPresent(WorkflowTestConstants.START_PROGRESS_LINK_ID);
    }

    private Locator transitionTableTabLocator() {
        return this.locator.id(WorkflowTestConstants.TRANSITION_TAB_TABLE_ID);
    }

    private void enableReferenceWorkflowConditionModule() {
        this.workflowCondition.enable();
    }

    private void disableReferenceWorkflowConditionModule() {
        this.workflowCondition.disable();
    }
}

