/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN, Category.SLOW_IMPORT})
public class TestServletModuleReloadability
extends AbstractReloadablePluginsTest {
    private static final int PAGE_NOT_FOUND = 404;
    private static final String USER_FRED = "fred";
    private static final String USER_BOB = "bob";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
    }

    public void testShouldNotExistAndBeAccessibleBeforeEnablingThePlugin() throws Exception {
        this.goToReferenceServlet(USER_FRED);
        this.assertServletNotAccessible(USER_FRED);
    }

    public void testShouldBeAccessibleAfterEnablingTheReferencePlugin() {
        this.administration.plugins().referencePlugin().enable();
        this.goToReferenceServlet(USER_FRED);
        this.assertServletAccessible(USER_FRED);
    }

    public void testShouldBeAccessibleAfterMultipleEnablingAndDisablingTheReferencePlugin() {
        this.administration.plugins().referencePlugin().enable();
        this.goToReferenceServlet(USER_FRED);
        this.assertServletAccessible(USER_FRED);
        this.administration.plugins().referencePlugin().disable();
        this.goToReferenceServlet(USER_BOB);
        this.assertServletNotAccessible(USER_BOB);
        this.administration.plugins().referencePlugin().enable();
        this.goToReferenceServlet(USER_BOB);
        this.assertServletAccessible(USER_BOB);
    }

    public void testShouldBeAccessibleAfterEnablingTheServletModule() {
        this.administration.plugins().referencePlugin().enable();
        for (int i = 0; i < 3; ++i) {
            this.goToReferenceServlet(USER_FRED);
            this.assertServletAccessible(USER_FRED);
            this.disableReferenceServletModule();
            this.goToReferenceServlet(USER_BOB);
            this.assertServletNotAccessible(USER_BOB);
            this.enableReferenceServletModule();
        }
    }

    private void goToReferenceServlet(String username) {
        this.tester.gotoPage("/plugins/servlet/reference-servlet?user=" + username);
    }

    private void assertServletAccessible(String expectedUsername) {
        this.text.assertTextPresent("Hello World Australia from: " + expectedUsername);
    }

    private void assertServletNotAccessible(String expectedUsername) {
        TestServletModuleReloadability.assertEquals((int)this.tester.getDialog().getResponse().getResponseCode(), (int)404);
        this.text.assertTextNotPresent("Hello World Australia from: " + expectedUsername);
    }

    private void enableReferenceServletModule() {
        this.administration.plugins().referencePlugin().enableModule(ReferencePluginConstants.REFERENCE_SERVLET_KEY);
    }

    private void disableReferenceServletModule() {
        this.administration.plugins().referencePlugin().disableModule(ReferencePluginConstants.REFERENCE_SERVLET_KEY);
    }
}

