/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN, Category.SLOW_IMPORT})
public class TestReportModuleReloadability
extends AbstractReloadablePluginsTest {
    private static final String ISSUE_COUNT_BY_PROJECT = "Issue count by Project";

    public void testReportModulePluginZeroToOn() throws Exception {
        this.shouldNotExistAndBeAccessibleBeforeEnablingThePlugin();
        this.shouldBeAccessibleAfterEnablingTheReferencePlugin();
    }

    private void shouldNotExistAndBeAccessibleBeforeEnablingThePlugin() throws Exception {
        this.assertPluginReportNotAccessible();
    }

    private void shouldBeAccessibleAfterEnablingTheReferencePlugin() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.assertPluginReportAccessible();
    }

    public void testReportModulePlugin() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.navigation.issue().createIssue("homosapien", "Bug", "Just a simple bug");
        this.goToProject();
        this.tester.clickLinkWithText(ISSUE_COUNT_BY_PROJECT);
        this.text.assertTextPresent(this.locator.css("td.fieldLabelArea"), "Project Key:");
        this.tester.submit("Next");
        this.text.assertTextPresent(this.locator.css("div.report"), "HSP has 1 issues");
    }

    public void testReportPluginModuleAccessibilityAfterMultipleReferencePluginEnablingAndDisabling() {
        this.assertPluginReportNotAccessible();
        this.administration.plugins().referencePlugin().enable();
        this.assertPluginReportAccessible();
        this.administration.plugins().referencePlugin().disable();
        this.assertPluginReportNotAccessible();
        this.administration.plugins().referencePlugin().enable();
        this.assertPluginReportAccessible();
    }

    public void testAccessibilityAfterReportPluginModuleEnablingAndDisabling() {
        this.administration.plugins().referencePlugin().enable();
        this.assertPluginReportAccessible();
        for (int i = 0; i < 3; ++i) {
            this.disableReportPluginModule();
            this.assertPluginReportNotAccessible();
            this.enableReportPluginModule();
            this.assertPluginReportAccessible();
        }
    }

    private void assertPluginReportAccessible() {
        this.goToProject();
        this.text.assertTextPresent(ISSUE_COUNT_BY_PROJECT);
    }

    private void assertPluginReportNotAccessible() {
        this.goToProject();
        this.text.assertTextNotPresent(ISSUE_COUNT_BY_PROJECT);
    }

    private void goToProject() {
        this.navigation.browseProject("HSP");
    }

    private void enableReportPluginModule() {
        this.administration.plugins().referencePlugin().enableModule(ReferencePluginConstants.REFERENCE_REPORT_KEY);
    }

    private void disableReportPluginModule() {
        this.administration.plugins().referencePlugin().disableModule(ReferencePluginConstants.REFERENCE_REPORT_KEY);
    }
}

