/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.admin.plugins.IssueTabPanel;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN, Category.ISSUES, Category.SLOW_IMPORT})
public class TestIssueTabPanelModuleTypeReloadability
extends AbstractReloadablePluginsTest {
    private IssueTabPanel issueTabPanel;
    private String testIssueKey;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueTabPanel = this.administration.plugins().referencePlugin().issueTabPanel();
        this.testIssueKey = this.createTestIssue();
    }

    private String createTestIssue() {
        return this.navigation.issue().createIssue("homosapien", "Bug", "Just a simple bug");
    }

    public void testShouldNotExistAndBeAccessibleBeforeEnablingThePlugin() throws Exception {
        this.assertNotAccessible();
    }

    public void testShouldBeReachableAfterEnablingTheReferencePlugin() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.assertAccessible();
    }

    public void testShouldBeAccesibleAfterMultipleReferencePluginEnablingAndDisabling() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.assertAccessible();
        this.administration.plugins().referencePlugin().disable();
        this.assertNotAccessible();
        this.administration.plugins().referencePlugin().enable();
        this.assertAccessible();
    }

    public void testShouldBeAccessibleAfterIssueTabModuleDisablingAndEnabling() {
        this.administration.plugins().referencePlugin().enable();
        this.assertAccessible();
        for (int i = 0; i < 3; ++i) {
            this.issueTabPanel.disable();
            this.assertNotAccessible();
            this.issueTabPanel.enable();
            this.assertAccessible();
        }
    }

    private void assertAccessible() {
        TestIssueTabPanelModuleTypeReloadability.assertTrue((boolean)this.issueTabPanel.isPresent(this.testIssueKey));
    }

    private void assertNotAccessible() {
        TestIssueTabPanelModuleTypeReloadability.assertFalse((boolean)this.issueTabPanel.isPresent(this.testIssueKey));
    }
}

