/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractCustomFieldPluginTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN, Category.SLOW_IMPORT})
@Splitable
public class TestCustomFieldTypeSearcherReloadability
extends AbstractCustomFieldPluginTest {
    private static final String TEST_XML = "ReloadablePluginsWithCustomTypesAndSearchersDisabled.xml";
    private static final String TEST_FIELD_INSTANCE_NAME = "Test reference labels field";
    private static final String CUSTOMFIELD_SEARCH_SECTION_ID = "navigator-filter-subheading-customfields";
    private static final String QUERY_STRING = "\"Test reference labels field\" = Fred";
    private static final String JQL_ERROR = "Field 'Test reference labels field' is not searchable, it is only sortable.";
    private final Map<String, String> searchersForCFTypes = MapBuilder.newBuilder().add("reference-labels", "reference-labelsearcher").add("reference-userpicker", "reference-userpickersearcher").add("reference-datetime", "reference-datetimesearcher").add("reference-textarea", "reference-textsearcher").add("reference-cascadingselect", "reference-labelsearcher").add("reference-select", "reference-labelsearcher").add("reference-multigrouppicker", "reference-labelsearcher").toMap();
    private final String[] LABELS_VALUES = new String[]{"Fred", "Barney", "Wilma"};

    @Override
    protected void setUpTest() {
        this.administration.restoreDataSlowOldWay(TEST_XML);
        this.navigation.login("admin", "admin");
        this.administration.plugins().referencePlugin().enable();
    }

    public void testCustomFieldTypesShouldBeAvailableAfterEnablement() throws Exception {
        for (String moduleKey : this.searchersForCFTypes.keySet()) {
            TestCustomFieldTypeSearcherReloadability.assertFalse((String)String.format("Plugin: %s should be disabled", moduleKey), (boolean)this.administration.plugins().isPluginModuleEnabled(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey(moduleKey)));
            this.administration.plugins().enablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey(moduleKey));
            TestCustomFieldTypeSearcherReloadability.assertTrue((String)String.format("Plugin: %s should be enabled", moduleKey), (boolean)this.administration.plugins().isPluginModuleEnabled(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey(moduleKey)));
        }
    }

    public void testEnabledCustomFieldTypeWithNoSearcher() {
        this.enableLabelCustomType();
        this.disableCustomLabelTypeSearcher();
        this.disableLabelTypeSearcher();
        this.setUpCustomFieldInstance(this.completeKey("reference-labels"), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this._assertCustomFieldSearcherNotVisibleInIssueNav();
    }

    public void testEnabledCustomFieldTypeWithSearcher() {
        this.enableLabelCustomType();
        this.enableCustomLabelTypeSearcher();
        this.setUpCustomFieldInstance(this.completeKey("reference-labels"), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this._assertCustomFieldSearcherVisibleInIssueNav();
    }

    public void testJqlSearchWithNoSearcher() {
        this.enableLabelCustomType();
        this.disableCustomLabelTypeSearcher();
        this.disableLabelTypeSearcher();
        this.setUpCustomFieldInstance(this.completeKey("reference-labels"), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this.createNewIssue("homosapien", "Bug", "Can't search labels field");
        this.performJqlSearch(QUERY_STRING);
        this.text.assertTextPresent(new IdLocator(this.tester, "jqlerror"), JQL_ERROR);
    }

    public void testJqlSearchWithSearcher() {
        this.enableLabelCustomType();
        this.enableCustomLabelTypeSearcher();
        this.setUpCustomFieldInstance(this.completeKey("reference-labels"), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this.createNewIssue("homosapien", "Bug", "Can search labels field");
        this.performJqlSearch(QUERY_STRING);
        this._assertSearchWithResults(QUERY_STRING, "HSP-1");
    }

    public void testCustomFieldSearchersShouldNotBeAccessibleAfterDisablingThePlugin() throws Exception {
        this.enableAllCustomFieldTypes();
        this.enableAllSearchers();
        this.setUpCustomFieldInstance(this.completeKey("reference-labels"), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this._assertCustomFieldSearcherVisibleInIssueNav();
        this.administration.plugins().referencePlugin().disable();
        this._assertCustomFieldSearcherNotVisibleInIssueNav();
    }

    public void testCustomFieldSearchersShouldBeAccessibleAfterMultiplePluginDisablingAndEnabling() throws Exception {
        this.enableAllCustomFieldTypes();
        this.enableAllSearchers();
        this.setUpCustomFieldInstance(this.completeKey("reference-labels"), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this.createNewIssue("homosapien", "Bug", "Can search labels field");
        this._assertCustomFieldSearcherVisibleInIssueNav();
        this.administration.plugins().referencePlugin().disable();
        this._assertCustomFieldSearcherNotVisibleInIssueNav();
        this.administration.plugins().referencePlugin().enable();
        this._assertCustomFieldSearcherVisibleInIssueNav();
        this.performJqlSearch(QUERY_STRING);
        this._assertSearchWithResults(QUERY_STRING, "HSP-1");
    }

    public void testDisablingOneCustomSearcherLeavesOtherOneVisible() throws Exception {
        this.enableAllCustomFieldTypes();
        this.enableAllSearchers();
        this.setUpCustomFieldInstance(this.completeKey("reference-labels"), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this.disableLabelTypeSearcher();
        this.createNewIssue("homosapien", "Bug", "Can search labels field");
        this._assertCustomFieldSearcherVisibleInIssueNav();
        this.performJqlSearch(QUERY_STRING);
        this._assertSearchWithResults(QUERY_STRING, "HSP-1");
    }

    private void _assertCustomFieldSearcherNotVisibleInIssueNav() {
        this.navigation.issueNavigator().displayAllIssues();
        TestCustomFieldTypeSearcherReloadability.assertFalse((String)"There should be no custom fields searcher", (boolean)this.issueNavigatorCustomFieldSearchLocator().exists());
    }

    private void _assertCustomFieldSearcherVisibleInIssueNav() {
        this.navigation.issueNavigator().displayAllIssues();
        TestCustomFieldTypeSearcherReloadability.assertTrue((String)"There should be a custom fields searcher", (boolean)this.issueNavigatorCustomFieldSearchLocator().exists());
    }

    void _assertSearchWithResults(String jqlString, String ... issueKeys) {
        this.navigation.issueNavigator().createSearch(jqlString);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(issueKeys);
    }

    private void createNewIssue(String projectName, String issueType, String summary) {
        this.navigation.issue().createIssue(projectName, issueType, summary, MapBuilder.newBuilder().add(this.customFieldId, this.LABELS_VALUES).toMap());
    }

    private void performJqlSearch(String queryString) {
        this.navigation.issueNavigator().createSearch(queryString);
    }

    private void enableAllSearchers() {
        this.enableLabelTypeSearcher();
        this.enableCustomLabelTypeSearcher();
    }

    private void enableAllCustomFieldTypes() {
        for (String moduleKey : this.searchersForCFTypes.keySet()) {
            this.administration.plugins().enablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey(moduleKey));
        }
    }

    private void enableLabelCustomType() {
        this.administration.plugins().enablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey("reference-labels"));
    }

    private void enableCustomLabelTypeSearcher() {
        this.administration.plugins().enablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey("reference-labelsearcher"));
    }

    private void disableCustomLabelTypeSearcher() {
        this.administration.plugins().disablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey("reference-labelsearcher"));
    }

    private void enableLabelTypeSearcher() {
        this.administration.plugins().enablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey("labelsearcher"));
    }

    private void disableLabelTypeSearcher() {
        this.administration.plugins().disablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey("labelsearcher"));
    }

    private String completeKey(String moduleKey) {
        return ReferencePluginConstants.REFERENCE_PLUGIN_KEY + ":" + moduleKey;
    }

    private Locator issueNavigatorCustomFieldSearchLocator() {
        return this.locator.id(CUSTOMFIELD_SEARCH_SECTION_ID);
    }
}

