/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.navigation.BulkChangeWizard;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractCustomFieldPluginTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import java.util.Collections;
import org.apache.commons.lang.ArrayUtils;

@Splitable
@WebTest(value={Category.FUNC_TEST, Category.RELOADABLE_PLUGINS, Category.REFERENCE_PLUGIN, Category.SLOW_IMPORT})
public class TestCustomFieldTypeModuleReloadability
extends AbstractCustomFieldPluginTest {
    private static final String TEST_FIELD_INSTANCE_NAME = "Test reference field";
    private static final String DEFAULT_FIELD_VALUE = "3";
    private static final String NONE_OPTION = "None";
    private static final String[] ALL_FIELD_VALUES = new String[]{"1", "2", "3", "4", "5"};
    private static final String[] ALL_VISIBLE_FIELD_VALUES = (String[])ArrayUtils.add((Object[])ALL_FIELD_VALUES, (int)0, (Object)"None");

    @Override
    protected void setUpTest() {
        super.setUpTest();
    }

    public void testShouldNotBeVisibleInTheAdminSectionGivenReferencePluginNotEnabled() throws Exception {
        this.navigation.gotoCustomFields();
        this.tester.clickLink("add_custom_fields");
        this.tester.assertRadioOptionNotPresent("fieldType", ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY);
    }

    public void testShouldBeVisibleInTheAdminSection() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.navigation.gotoCustomFields();
        this.tester.clickLink("add_custom_fields");
        this.tester.setWorkingForm("jiraform");
        this.tester.assertRadioOptionPresent("fieldType", ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY);
    }

    public void testShouldBeVisibleInTheCreateIssueScreen() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.text.assertTextPresent(this.editIssueCustomFieldLabelLocator(), TEST_FIELD_INSTANCE_NAME);
        this.tester.assertOptionEquals(this.customFieldId, DEFAULT_FIELD_VALUE);
        this.tester.assertOptionsEqual(this.customFieldId, ALL_VISIBLE_FIELD_VALUES);
    }

    public void testShouldBeVisibleInTheViewIssueScreen() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.navigation.issue().gotoIssue(this.createTestIssue("4"));
        this.text.assertTextSequence(this.viewIssueCustomFieldRowLocator(), TEST_FIELD_INSTANCE_NAME, "4");
    }

    public void testShouldBeVisibleInTheEditIssueScreen() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.navigation.issue().gotoEditIssue(this.createTestIssue("2"));
        this.text.assertTextPresent(this.editIssueCustomFieldLabelLocator(), TEST_FIELD_INSTANCE_NAME);
        this.tester.assertOptionEquals(this.customFieldId, "2");
        this.tester.assertOptionsEqual(this.customFieldId, ALL_VISIBLE_FIELD_VALUES);
    }

    public void testShouldBeVisibleInBulkEdit() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.createTestIssue("5");
        this.goToBulkEditOperationDetails();
        this.text.assertTextPresent(this.bulkEditIssueCustomFieldLabelLocator(), TEST_FIELD_INSTANCE_NAME);
        this.tester.assertOptionEquals(this.customFieldId, DEFAULT_FIELD_VALUE);
        this.tester.assertOptionsEqual(this.customFieldId, ALL_VISIBLE_FIELD_VALUES);
    }

    public void testShouldBeVisibleInConfigureDefaultScreen() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.createTestIssue("1");
        this.administration.viewFieldScreens().goTo().configureScreen("Default Screen");
        this.text.assertTextPresent(this.configurationFieldTableLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    public void testShouldBeVisibleInConfigureResolveIssueScreen() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.createTestIssue(DEFAULT_FIELD_VALUE);
        this.administration.viewFieldScreens().goTo().configureScreen("Resolve Issue Screen");
        this.text.assertTextPresent(this.configureScreenSelectFieldLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    public void testShouldBeVisibleInConfigureWorkflowScreen() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.createTestIssue(DEFAULT_FIELD_VALUE);
        this.administration.viewFieldScreens().goTo().configureScreen("Workflow Screen");
        this.text.assertTextPresent(this.configureScreenSelectFieldLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    public void testShouldBeVisibleInIssueNavigatorColumns() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.createTestIssue(DEFAULT_FIELD_VALUE);
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().goToConfigureColumns();
        this.text.assertTextPresent(this.configureColumnsSelectFieldLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    public void testShouldBeVisibleInFieldConfigurations() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.administration.fieldConfigurations().defaultFieldConfiguration();
        this.text.assertTextPresent(this.configurationFieldTableLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    public void testCustomFieldShouldNotBeAccessibleAfterDisablingThePluginModule() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.administration.plugins().referencePlugin().disableModule(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY);
        this._assertNotVisibleInFieldConfigurations();
        this._assertNotVisibleInTheCreateIssueScreen();
        this._assertNotVisibleInTheViewIssueScreen();
        this._assertNotVisibleInTheEditIssueScreen();
        this._assertNotVisibleInBulkEdit();
        this._assertNotVisibleInConfigureDefaultScreen();
        this._assertNotVisibleInConfigureResolveIssueScreen();
        this._assertNotVisibleInConfigureWorkflowScreen();
        this._assertNotVisibleInIssueNavigatorColumns();
    }

    public void testCustomFieldModuleReloadability() throws Exception {
        this.administration.plugins().referencePlugin().enable();
        this.setUpCustomFieldInstance(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY, TEST_FIELD_INSTANCE_NAME, DEFAULT_FIELD_VALUE, ALL_FIELD_VALUES);
        this.administration.plugins().referencePlugin().disableModule(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY);
        this._assertNotVisibleInTheCreateIssueScreen();
        this.administration.plugins().referencePlugin().enableModule(ReferencePluginConstants.SELECT_CUSTOM_FIELD_TYPE_KEY);
        this.administration.fieldConfigurations().defaultFieldConfiguration();
        this.text.assertTextPresent(this.configurationFieldTableLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private void _assertNotVisibleInTheCreateIssueScreen() {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Bug");
        this.text.assertTextNotPresent(this.editIssueCustomFieldLabelLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private void _assertNotVisibleInTheViewIssueScreen() {
        this.navigation.issue().gotoIssue(this.createTestIssue("4"));
        this.text.assertTextNotPresent(this.viewIssueCustomFieldRowLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private void _assertNotVisibleInTheEditIssueScreen() {
        this.navigation.issue().gotoEditIssue(this.createTestIssue("2"));
        this.text.assertTextNotPresent(this.editIssueCustomFieldLabelLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private void _assertNotVisibleInBulkEdit() {
        this.createTestIssue("5");
        this.goToBulkEditOperationDetails();
        this.text.assertTextNotPresent(this.bulkEditIssueCustomFieldLabelLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private void _assertNotVisibleInConfigureDefaultScreen() {
        this.createTestIssue("1");
        this.administration.viewFieldScreens().goTo().configureScreen("Default Screen");
        this.text.assertTextNotPresent(this.configurationFieldTableLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private void _assertNotVisibleInConfigureResolveIssueScreen() {
        this.createTestIssue(DEFAULT_FIELD_VALUE);
        this.administration.viewFieldScreens().goTo().configureScreen("Resolve Issue Screen");
        this.text.assertTextNotPresent(this.configureScreenSelectFieldLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private void _assertNotVisibleInConfigureWorkflowScreen() {
        this.createTestIssue(DEFAULT_FIELD_VALUE);
        this.administration.viewFieldScreens().goTo().configureScreen("Workflow Screen");
        this.text.assertTextNotPresent(this.configureScreenSelectFieldLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private void _assertNotVisibleInIssueNavigatorColumns() throws Exception {
        this.createTestIssue(DEFAULT_FIELD_VALUE);
        this.navigation.issueNavigator().displayAllIssues();
        this.navigation.issueNavigator().goToConfigureColumns();
        this.text.assertTextNotPresent(this.configureColumnsSelectFieldLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private void _assertNotVisibleInFieldConfigurations() {
        this.administration.fieldConfigurations().defaultFieldConfiguration();
        this.text.assertTextNotPresent(this.configurationFieldTableLocator(), TEST_FIELD_INSTANCE_NAME);
    }

    private String createTestIssue(String customFieldValue) {
        return this.navigation.issue().createIssue("homosapien", "Bug", "Test summary", Collections.singletonMap(this.customFieldId, new String[]{customFieldValue}));
    }

    private void goToBulkEditOperationDetails() {
        this.navigation.issueNavigator().displayAllIssues();
        BulkChangeWizard bulkChange = this.navigation.issueNavigator().bulkChange(IssueNavigatorNavigation.BulkChangeOption.ALL_PAGES);
        bulkChange.selectAllIssues().chooseOperation(BulkChangeWizard.BulkOperationsImpl.EDIT);
    }

    private CssLocator editIssueCustomFieldLabelLocator() {
        return this.locator.css("label[for=" + this.customFieldId + "]");
    }

    private Locator viewIssueCustomFieldRowLocator() {
        return this.locator.id("rowForcustomfield_" + this.customFieldNumericId);
    }

    private Locator bulkEditIssueCustomFieldLabelLocator() {
        return this.locator.css("label[for=cb" + this.customFieldId + "]");
    }

    private Locator configurationFieldTableLocator() {
        return this.locator.id(this.configurationFieldTableId());
    }

    private String configurationFieldTableId() {
        return "field_table";
    }

    private Locator configureScreenSelectFieldLocator() {
        return this.locator.css("select[name=fieldId]");
    }

    private Locator configureColumnsSelectFieldLocator() {
        return this.locator.id("issue-nav-add-columns-column-select");
    }
}

