/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.text;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestWildcardQuerySupport
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
    }

    public void testWildCardSearchMatchesZeroOrMoreCharactersInACamelCaseWord() throws Exception {
        this.backdoor.project().addProject("Wildcard Search Test", "WCST", "admin");
        this.backdoor.issues().createIssue("WCST", "KidVantage");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"kid*vantage\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"k*antage\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"kidvantage\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"KidVantage\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
    }

    public void testWildCardSearchMatchesZeroOrMoreCharactersInAJavaIdentifierCaseWord() throws Exception {
        this.backdoor.project().addProject("Wildcard Search Test", "WCST", "admin");
        this.backdoor.issues().createIssue("WCST", "premiumAdjustments");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"premiumadjustment\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"premiumadjustmen*\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"premiumadjustme*\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"premiumadjustm*\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"premiumadjust*\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
    }

    public void testWildCardSearchMatchesZeroOrMoreCharactersInAJavaExceptionWord() throws Exception {
        this.backdoor.project().addProject("Wildcard Search Test", "WCST", "admin");
        this.backdoor.issues().createIssue("WCST", "SEHException");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"SEHExcept*\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"SEHExcepti*\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"SEHExceptio*\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"SEHException*\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"SEHException\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("WCST-1")));
    }

    public void testWildCardSearchMatchesZeroOrMoreCharactersInAWordSubjectToStemming() {
        this.backdoor.project().addProject("Wildcard Search Test", "WCST", "admin");
        this.backdoor.issues().createIssue("WCST", "customize subject");
        this.backdoor.issues().createIssue("WCST", "customized subject");
        this.backdoor.issues().createIssue("WCST", "customizes searches");
        this.backdoor.issues().createIssue("WCST", "custom jira");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"custom*\""));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)4));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"customi*\""));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)3));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"customiz*\""));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)3));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"customize*\""));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)3));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"customized*\""));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)1));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"customizes*\""));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)1));
    }

    public void testWildCardSearchCanMatchOneCharacterInAWordSubjectToStemming() {
        this.backdoor.project().addProject("Wildcard Search Test", "WCST", "admin");
        this.backdoor.issues().createIssue("WCST", "customize subject");
        this.backdoor.issues().createIssue("WCST", "customized subject");
        this.backdoor.issues().createIssue("WCST", "customizes searches");
        this.backdoor.issues().createIssue("WCST", "custom jira");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = WCST AND summary ~\"customize?\""));
        Assert.assertThat((Object)searchResult.issues.size(), (Matcher)Matchers.equalTo((Object)2));
    }

    private BaseMatcher<Issue> issue(final String key) {
        return new BaseMatcher<Issue>(){

            public boolean matches(Object item) {
                return ((Issue)item).key.equals(key);
            }

            public void describeTo(Description description) {
                description.appendText("Issue with: key=").appendValue((Object)key);
            }
        };
    }
}

