/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.text;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.SearchRequest;
import com.atlassian.jira.testkit.client.restclient.SearchResult;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestPhraseQuerySupport
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
    }

    public void testSearchingForAPhraseWithWordsSubjectToStemmingShouldNotMatchTheStemOfThoseWords() throws Exception {
        this.backdoor.project().addProject("Phrase Query Support Test", "PQST", "admin");
        this.backdoor.issues().createIssue("PQST", "This is a customized engine");
        this.backdoor.issues().createIssue("PQST", "Boeing custom engine");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = PQST AND summary ~\"\\\"customized engine\\\"\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("PQST-1")));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.not((Matcher)Matchers.contains(this.issue("PQST-2"))));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = PQST AND summary ~\"\\\"custom engine\\\"\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.not((Matcher)Matchers.contains(this.issue("PQST-1"))));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("PQST-2")));
    }

    public void testSearchingForAPhraseWithStopWordsShouldOnlyMatchThatExactStopWord() throws Exception {
        this.backdoor.project().addProject("Phrase Query Support Test", "PQST", "admin");
        this.backdoor.issues().createIssue("PQST", "JIRA is a customized engine");
        SearchResult searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = PQST AND summary ~\"\\\"JIRA customized\\\"\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.not((Matcher)Matchers.contains(this.issue("PQST-1"))));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = PQST AND summary ~\"\\\"JIRA is customized\\\"\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.not((Matcher)Matchers.contains(this.issue("PQST-1"))));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = PQST AND summary ~\"\\\"JIRA is an customized\\\"\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.not((Matcher)Matchers.contains(this.issue("PQST-1"))));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = PQST AND summary ~\"\\\"JIRA are a customized\\\"\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.not((Matcher)Matchers.contains(this.issue("PQST-1"))));
        searchResult = this.backdoor.search().postSearch(new SearchRequest().jql("project = PQST AND summary ~\"\\\"JIRA is a customized\\\"\""));
        Assert.assertThat((Object)searchResult.issues, (Matcher)Matchers.contains(this.issue("PQST-1")));
    }

    private BaseMatcher<Issue> issue(final String key) {
        return new BaseMatcher<Issue>(){

            public boolean matches(Object item) {
                return ((Issue)item).key.equals(key);
            }

            public void describeTo(Description description) {
                description.appendText("Issue with: key=").appendValue((Object)key);
            }
        };
    }
}

