/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.status.daterange;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.AbstractChangeHistoryFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
public class TestSearchIssueStatusBeforeADate
extends AbstractChangeHistoryFuncTest {
    private static final String FIELD_NAME = "status";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestSearchIssueStatusBeforeADate.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testInvalidBeforeInput() {
        String expectedError = "The BEFORE predicate must be supplied with only 1 date value.";
        super.assertInvalidSearchProducesError(FIELD_NAME, "Closed", "BEFORE ('2011-07-01','2011-07-01')", expectedError);
        super.assertInvalidSearchProducesError(FIELD_NAME, "Closed", "BEFORE ('2011-07-01','2011-07-03','2012-07-03')", expectedError);
    }

    public void testReturnsTheIssuesThatWereInTheStatusGivenThatTheIssuesTransitionedInAndOutOfTheStatusBeforeTheDate() {
        this.navigation.issueNavigator().createSearch("project=svb and status was 'in progress' before '2011-02-21 10:30' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVB-1");
    }

    public void testReturnsTheIssuesThatWereInTheStatusGivenThatTheIssuesTransitionedDirectlyToTheStatusBeforeTheDate() {
        this.navigation.issueNavigator().createSearch("project=svb and status was 'resolved' before '2011-02-21 11:30' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVB-3", "SVB-4", "SVB-5");
    }

    public void testDoesNotReturnIssuesThatWereNeverInThatStatus() {
        this.navigation.issueNavigator().createSearch("project=svb and status was 'closed' before '2011-02-21 10:30' order by key");
    }

    public void testDoesNotReturnIssuesThatTransitionedToTheSpecifiedStatusAtTheDate() {
        this.navigation.issueNavigator().createSearch("project=svb and status was 'resolved' before '2011-02-21 10:30' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SVB-4");
    }

    public void testDoesNotReturnIssuesThatTransitionedToTheSpecifiedStatuesJustAfterTheDate() {
        this.navigation.issueNavigator().createSearch("project=svb and status was 'resolved' before '2011-02-21 10:30' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SVB-5");
    }

    public void testReturnsIssuesThatTransitionedToTheSpecifiedStatusJustBeforeTheDate() {
        this.navigation.issueNavigator().createSearch("project=svb and status was 'resolved' before '2011-02-21 10:30' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVB-3");
    }

    public void testReturnsIssuesThatTransitionedToTheSpecifiedStatusBeforeTheDateWhenWeHaveOneOrMoreStatii() {
        this.navigation.issueNavigator().createSearch("project=svb and status was in ('Closed') before '2011-03-29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVB-2");
        this.navigation.issueNavigator().createSearch("project=svb and status was in ('In Progress', 'Closed') before '2011-03-29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVB-1", "SVB-2");
        this.navigation.issueNavigator().createSearch("project=svb and status was in ('In Progress', 'Closed', 'Resolved') before '2011-03-29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("SVB-1", "SVB-2", "SVB-3", "SVB-4", "SVB-5");
    }
}

