/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.status.daterange;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.AbstractChangeHistoryFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
public class TestSearchIssueStatusAfterADate
extends AbstractChangeHistoryFuncTest {
    private static final String FIELD_NAME = "status";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestSearchIssueStatusAfterADate.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testInvalidAfterInput() {
        String expectedError = "The AFTER predicate must be supplied with only 1 date value.";
        super.assertInvalidSearchProducesError(FIELD_NAME, "Closed", "AFTER ('2011-07-01','2011-07-01')", expectedError);
        super.assertInvalidSearchProducesError(FIELD_NAME, "Closed", "AFTER ('2011-07-01','2011-07-03','2012-07-03')", expectedError);
    }

    public void testReturnsTheIssuesThatWereInTheStatusAndTransitionedToThatStatusAfterTheDate() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsContain("SHT-4", "SHT-5", "SHT-10");
    }

    public void testReturnsTheIssuesThatWereInTheStatusAndTransitionedToThatStatusBeforeTheDate() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsContain("SHT-1", "SHT-2");
    }

    public void testDoesNotReturnIssuesThatWereNeverInTheSpecifiedStatus() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SHT-6", "SHT-7");
    }

    public void testDoesNotReturnIssuesThatWereNotInTheStatusGivenThatTheIssuesWereInThatStatusAtADateOutsideTheRange() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SHT-6", "SHT-7");
    }

    public void testDoesNotReturnIssuesThatTransitionedToTheSpecifiedStatusAtTheDate() {
        this.navigation.issueNavigator().createSearch("project=sht and status was resolved after '2011-05-25 09:29' order by key");
        this.assertions.getIssueNavigatorAssertions().assertSearchResultsDoNotContain("SHT-3");
    }
}

