/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.fixversion;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.AbstractChangeHistoryFuncTest;
import com.google.common.collect.Sets;
import java.util.HashSet;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
public class TestFixVersionWasSearching
extends AbstractChangeHistoryFuncTest {
    private static final String FIELD_NAME = "fixversion";
    private static final String[] ALL_ISSUES = new String[]{"HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
    private static final String VERSION_1 = "'New Version 1'";
    private static final String VERSION_2 = "'New Version 4'";
    private static final String VERSION_3 = "'New Version 5'";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestFixVersionWasSearching.xml");
        this.navigation.login("admin");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testWasEmptySearch() {
        String[] issueKeys = new String[]{"HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        super.assertWasEmptySearchReturnsEmptyValuesUsingEmptyKeyword(FIELD_NAME, issueKeys);
    }

    public void testWasNotEmptySearch() {
        String[] issueKeys = new String[]{"HSP-13"};
        super.assertWasNotEmptySearchReturnsNotEmptyValuesWithEmptyKeyword(FIELD_NAME, issueKeys);
    }

    public void testWasSearchUsingSingleValueOperandsReturnsExpectedValues() {
        super.assertWasSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-1");
        super.assertWasSearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "HSP-12", "HSP-11", "HSP-10", "HSP-3");
        super.assertWasSearchReturnsExpectedValues(FIELD_NAME, VERSION_3, "HSP-12", "HSP-11", "HSP-3");
    }

    public void testWasSearchUsingListOperands() {
        HashSet versions = Sets.newHashSet((Object[])new String[]{VERSION_1, VERSION_2});
        super.assertWasInSearchReturnsExpectedValues(FIELD_NAME, versions, "HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-3", "HSP-1");
        versions = Sets.newHashSet((Object[])new String[]{VERSION_2, VERSION_3});
        super.assertWasInSearchReturnsExpectedValues(FIELD_NAME, versions, "HSP-12", "HSP-11", "HSP-10", "HSP-3");
    }

    public void testWasNotInSearchUsingListOperands() {
        HashSet versions = Sets.newHashSet((Object[])new String[]{VERSION_1, VERSION_3});
        String[] expected = new String[]{"HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-2"};
        super.assertWasNotInSearchReturnsExpectedValues(FIELD_NAME, versions, expected);
    }

    public void testWasSearchUsingByPredicate() {
        String[] expected = new String[]{"HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-1"};
        super.assertWasBySearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "admin", expected);
        expected = new String[]{};
        super.assertWasBySearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "fred", expected);
        expected = new String[]{"HSP-9"};
        super.assertWasBySearchUsingListOperandsReturnsExpectedValues(FIELD_NAME, "empty", Sets.newHashSet((Object[])new String[]{"fred", "bob"}), expected);
    }

    public void testWasSearchUsingDuringPredicate() {
        String[] expected = new String[]{"HSP-1"};
        super.assertWasDuringSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", "'2011/05/31'", expected);
    }

    public void testWasSearchUsingBeforePredicate() {
        String[] expected = new String[]{};
        super.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "'2011/05/01'", expected);
        expected = new String[]{"HSP-1"};
        super.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/19 10:55'", expected);
    }

    public void testWasSearchUsingAfterPredicate() {
        String[] expected = new String[]{"HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-1"};
        super.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", expected);
        expected = new String[]{"HSP-13", "HSP-12", "HSP-11", "HSP-1"};
        super.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/08/26 14:29'", expected);
    }

    public void testWasSearchUsingOnPredicate() {
        String[] expected = new String[]{};
        super.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", expected);
        expected = new String[]{"HSP-1"};
        super.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/06/01'", expected);
    }

    public void testWasSearchUsingLongOperandsIsValid() {
        super.assertWasSearchReturnsExpectedValues(FIELD_NAME, "10000", "HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-1");
    }

    public void testWasSearchUsingUnclosedListIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting ')' before the end of the query.";
        super.assertInvalidSearchProducesError(FIELD_NAME, "(fred, bob", "", expectedError);
    }

    public void testWasSearchUsingIncorrectPredicateIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting either 'OR' or 'AND' but got 'at'. (line 1, character 28)";
        super.assertInvalidSearchProducesError(FIELD_NAME, "(fred, bob)", "at '10:55'", expectedError);
    }
}

