/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.changed;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
public class TestChangedSearching
extends AbstractJqlFuncTest {
    private static final String FIELD_NAME = "fixversion";
    private static final String[] ALL_ISSUES = new String[]{"HSP-13", "HSP-12", "HSP-11", "HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
    private static final String VERSION_1 = "'New Version 1'";
    private static final String VERSION_2 = "'New Version 4'";
    private static final String VERSION_3 = "'New Version 5'";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestChangeSearching.xml");
        this.navigation.login("admin");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testChangedEmptySearch() {
        String[] issueKeys = new String[]{"HSP-12", "HSP-11", "HSP-10", "HSP-3", "HSP-1"};
        String jqlQuery = "fixVersion changed";
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    public void testChangedNotEmptySearch() {
        String[] issueKeys = new String[]{"HSP-13", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-2"};
        String jqlQuery = "not fixVersion changed";
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    public void testChangedFromSearchUsingSingleValueOperandsReturnsExpectedValues() {
        this.assertChangedFromSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "HSP-12", "HSP-11", "HSP-10");
        this.assertChangedFromSearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "HSP-12", "HSP-11", "HSP-10");
        this.assertChangedFromSearchReturnsExpectedValues(FIELD_NAME, VERSION_3, new String[0]);
        this.assertChangedFromSearchReturnsExpectedValues(FIELD_NAME, "EMPTY", "HSP-12", "HSP-11", "HSP-3", "HSP-1");
    }

    public void testChangedToSearchUsingSingleValueOperandsReturnsExpectedValues() {
        this.assertChangedToSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "HSP-12", "HSP-11", "HSP-10", "HSP-1");
        this.assertChangedToSearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "HSP-12", "HSP-11", "HSP-10", "HSP-3");
        this.assertChangedToSearchReturnsExpectedValues(FIELD_NAME, VERSION_3, "HSP-12", "HSP-11", "HSP-3");
        this.assertChangedToSearchReturnsExpectedValues(FIELD_NAME, "Empty", "HSP-12", "HSP-11", "HSP-10");
    }

    public void testChangedSearchUsingByPredicate() {
        String[] expected = new String[]{"HSP-12", "HSP-11", "HSP-10", "HSP-1"};
        this.assertChangedBySearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "admin", expected);
        this.assertChangedBySearchUsingListOperandsReturnsExpectedValues(FIELD_NAME, VERSION_1, Sets.newHashSet((Object[])new String[]{"fred", "admin"}), expected);
        expected = new String[]{};
        this.assertChangedBySearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "fred", expected);
        this.assertChangedBySearchUsingListOperandsReturnsExpectedValues(FIELD_NAME, "empty", Sets.newHashSet((Object[])new String[]{"fred", "bob"}), expected);
    }

    public void testChangedSearchUsingDuringPredicate() {
        String[] expected = new String[]{"HSP-1"};
        this.assertChangedDuringSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", "'2011/05/31'", expected);
        expected = new String[]{"HSP-12", "HSP-11", "HSP-10", "HSP-1"};
        this.assertChangedDuringSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", "'2011/08/31'", expected);
        expected = new String[]{"HSP-12", "HSP-11", "HSP-10"};
        this.assertChangedDuringSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/06/01'", "'2011/08/31'", expected);
    }

    public void testChangedSearchUsingBeforePredicate() {
        String[] expected = new String[]{};
        this.assertChangedBeforeSearchReturnsExpectedValues(FIELD_NAME, VERSION_2, "'2011/05/01'", expected);
        expected = new String[]{"HSP-1"};
        this.assertChangedBeforeSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/07/01 10:55'", expected);
    }

    public void testChangedSearchUsingAfterPredicate() {
        String[] expected = new String[]{"HSP-12", "HSP-11", "HSP-10", "HSP-1"};
        this.assertChangedAfterSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", expected);
        expected = new String[]{"HSP-12", "HSP-11"};
        this.assertChangedAfterSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/08/26 14:29'", expected);
    }

    public void testChangedSearchUsingOnPredicate() {
        String[] expected = new String[]{};
        this.assertChangedOnSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/01'", expected);
        expected = new String[]{"HSP-1"};
        this.assertChangedOnSearchReturnsExpectedValues(FIELD_NAME, VERSION_1, "'2011/05/18'", expected);
    }

    public void testChangedSearchUsingLongOperandsIsValid() {
        this.assertChangedFromSearchReturnsExpectedValues(FIELD_NAME, "10000", "HSP-12", "HSP-11", "HSP-10");
    }

    public void testChangedSearchUsingUnclosedListIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting ')' before the end of the query.";
        this.assertInvalidSearchProducesError(FIELD_NAME, "(fred, bob", "", expectedError);
    }

    protected void assertChangedFromSearchReturnsExpectedValues(String fieldName, String value, String ... issueKeys) {
        String jqlQuery = String.format("%s changed from %s", fieldName, value);
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    protected void assertChangedToSearchReturnsExpectedValues(String fieldName, String value, String ... issueKeys) {
        String jqlQuery = String.format("%s changed to %s", fieldName, value);
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    protected void assertChangedBySearchReturnsExpectedValues(String fieldName, String value, String actioner, String ... issueKeys) {
        String jqlQuery = String.format("%s changed to %s by %s", fieldName, value, actioner);
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    protected void assertChangedBySearchUsingListOperandsReturnsExpectedValues(String fieldName, String value, Set<String> actioners, String ... issueKeys) {
        String list = this.buildListString(actioners);
        String jqlQuery = String.format("%s changed to %s by %s", fieldName, value, list);
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    protected void assertChangedDuringSearchReturnsExpectedValues(String fieldName, String value, String from, String to, String ... issueKeys) {
        String list = String.format("(%s,%s)", from, to);
        String jqlQuery = String.format("%s changed to %s during %s", fieldName, value, list);
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    protected void assertChangedBeforeSearchReturnsExpectedValues(String fieldName, String value, String date, String ... issueKeys) {
        String jqlQuery = String.format("%s changed to %s before %s", fieldName, value, date);
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    protected void assertChangedAfterSearchReturnsExpectedValues(String fieldName, String value, String date, String ... issueKeys) {
        String jqlQuery = String.format("%s changed to %s after %s", fieldName, value, date);
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    protected void assertChangedOnSearchReturnsExpectedValues(String fieldName, String value, String date, String ... issueKeys) {
        String jqlQuery = String.format("%s changed to %s on %s", fieldName, value, date);
        this.assertSearchWithResults(jqlQuery, issueKeys);
    }

    protected void assertInvalidSearchProducesError(String fieldName, String value, String whereClause, String error) {
        String jqlQuery = String.format("%s changed %s %s", fieldName, value, whereClause);
        this.assertSearchWithError(jqlQuery, error);
    }

    private String buildListString(Set<String> listValues) {
        StringBuilder list = new StringBuilder();
        if (listValues != null) {
            list.append('(');
            Iterator<String> iter = listValues.iterator();
            while (iter.hasNext()) {
                list.append(iter.next());
                if (!iter.hasNext()) continue;
                list.append(',');
            }
            list.append(')');
        }
        return list.toString();
    }
}

