/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import java.io.IOException;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.SLOW_IMPORT})
public class TestUserQueriesCaseInsensitive
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreDataSlowOldWay("TestUserQueriesCaseInsensitive.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testUserQueries() throws Exception {
        TestUserQueriesCaseInsensitive.assertEquals((String)"Administrator from LDAP", (String)this.parse.header().getFullUserName());
        this.log("Running queries with (pseudo) LDAP directory first");
        this.runUserQueries();
        this.swapDirectories();
        TestUserQueriesCaseInsensitive.assertEquals((String)"Administrator in the Shadows", (String)this.parse.header().getFullUserName());
        this.log("Running queries with internal directory first");
        this.runUserQueries();
    }

    private void runUserQueries() {
        this.log("Running assignee queries");
        this.assertSearchWithResults("assignee = admin", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4");
        this.assertSearchWithResults("assignee = Admin", "NO-1", "MKY-1", "JRA-2", "HSP-1", "CONF-1", "ABC-4");
        this.assertSearchWithResults("assignee = fred", new String[0]);
        this.assertSearchWithResults("assignee = Fred", new String[0]);
        this.log("Running reporter queries");
        this.assertSearchWithResults("reporter = admin", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-3", "ABC-2");
        this.assertSearchWithResults("reporter = Admin", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-3", "ABC-2");
        this.assertSearchWithResults("reporter = currentUser()", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-3", "ABC-2");
        this.log("Running voter queries");
        this.assertSearchWithResults("voter = admin", "MKY-1");
        this.assertSearchWithResults("voter = Admin", "MKY-1");
        this.assertSearchWithResults("voter = fred", "MKY-1", "JRA-2");
        this.assertSearchWithResults("voter = Fred", "MKY-1", "JRA-2");
        this.log("Running watcher queries");
        this.assertSearchWithResults("watcher = admin", "JRA-2");
        this.assertSearchWithResults("watcher = Admin", "JRA-2");
        this.log("Running custom field queries");
        this.assertSearchWithResults("\"QA done by\" = John", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("\"QA done by\" = john", "CONF-1", "ABC-4", "ABC-3", "ABC-2");
        this.assertSearchWithResults("\"Interested parties\" = admin", "JRA-1", "HSP-1");
        this.assertSearchWithResults("\"Interested parties\" = Admin", "JRA-1", "HSP-1");
        this.assertSearchWithResults("\"Interested parties\" = John", "JRA-2", "HSP-1", "CONF-1");
        this.assertSearchWithResults("\"Interested parties\" = john", "JRA-2", "HSP-1", "CONF-1");
        this.log("Running change history queries");
        this.assertSearchWithResults("reporter was admin before \"2009-07-24\"", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-2");
        this.assertSearchWithResults("reporter was Admin before \"2009-07-24\"", "NO-1", "JRA-2", "JRA-1", "CONF-1", "ABC-2");
        this.assertSearchWithResults("reporter was not admin after \"2009-07-24\"", "MKY-1", "HSP-1", "ABC-4");
        this.assertSearchWithResults("reporter was not Admin after \"2009-07-24\"", "MKY-1", "HSP-1", "ABC-4");
    }

    public void swapDirectories() throws IOException, SAXException {
        this.log("Swap directory order");
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        this.tester.setWorkingForm("");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        WebLink link = userDirectoryTable.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLink(link);
    }
}

