/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestUserNameSearching
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestUserNameSearching.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testSystemFieldSearchByUserName() throws Exception {
        this._testSearchByUserNameFits("assignee", "assignee");
        this._testSearchByFullNameDoesntFit("assignee");
        this._testSearchByEmailDoesntFit("assignee");
        this._testSearchByEmailReturnsResultsByEmail("assignee");
    }

    public void testUserPickerSearchByUserName() throws Exception {
        this._testSearchByUserNameFits("userpicker", "customfield_10000");
        this._testSearchByFullNameDoesntFit("userpicker");
        this._testSearchByEmailDoesntFit("userpicker");
        this._testSearchByEmailReturnsResultsByEmail("userpicker");
    }

    public void testSearchingUsingDeletedUser() throws Exception {
        this.assertSearchWithResults("assignee = \"deleteduser\"", "HSP-2");
    }

    public void testSearchingUsingDeletedUserDoesntFit() throws Exception {
        String jql = "assignee = \"deleteduser\"";
        this.assertTooComplex(jql);
    }

    public void testUserGroupPickerSearchByUserName() throws Exception {
        this._testSearchByUserNameFits("usergrouppicker", "customfield_10001");
        this._testSearchByFullNameDoesntFit("usergrouppicker");
        this._testSearchByEmailDoesntFit("usergrouppicker");
        this._testSearchByEmailReturnsResultsByEmail("usergrouppicker");
    }

    public void _testSearchByUserNameFits(String field, String formName) throws Exception {
        String jql = field + " = admin";
        this.assertFitsFilterForm(jql, TestUserNameSearching.createFilterFormParam(formName, "admin"));
        this.assertSearchWithResults(jql, "HSP-1");
    }

    public void _testSearchByFullNameDoesntFit(String field) throws Exception {
        String jql = field + " = " + "Administrator";
        this.assertTooComplex(jql);
        this.assertSearchWithResults(jql, "HSP-1");
    }

    public void _testSearchByEmailDoesntFit(String field) throws Exception {
        String jql = field + " = 'admin@example.com'";
        this.assertTooComplex(jql);
        this.assertSearchWithResults(jql, "HSP-1");
    }

    public void _testSearchByEmailReturnsResultsByEmail(String field) throws Exception {
        this.assertSearchWithResults(field + " = 'email@example.com'", "HSP-3");
    }
}

