/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestTextClausesEscapingLuceneOperators
extends AbstractJqlFuncTest {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testQueryingForAnIssueThatContainsALuceneOperatorOnItsSummary() {
        ImmutableMap summaryPrefixAndOperatorToTest = ImmutableMap.builder().put((Object)"one", (Object)"+").put((Object)"two", (Object)"-").put((Object)"three", (Object)"&").put((Object)"four", (Object)"|").put((Object)"five", (Object)"!").put((Object)"six", (Object)"(").put((Object)"seven", (Object)")").put((Object)"eight", (Object)"{").put((Object)"nine", (Object)"}").put((Object)"ten", (Object)"[").put((Object)"eleven", (Object)"]").put((Object)"twelve", (Object)"^").put((Object)"thirteen", (Object)"~").put((Object)"fourteen", (Object)"*").put((Object)"fifteen", (Object)"?").build();
        for (Map.Entry summaryPrefixAndOperator : summaryPrefixAndOperatorToTest.entrySet()) {
            String summaryPrefix = (String)summaryPrefixAndOperator.getKey();
            String luceneOperator = (String)summaryPrefixAndOperator.getValue();
            String issue = this.createIssueWithSummary(summaryPrefix + luceneOperator);
            String query = this.queryWithLuceneOperatorEscaped(summaryPrefix, luceneOperator);
            this.assertSearchWithResults(query, issue);
        }
    }

    public void testQueryingForAnIssueThatContainsABackslashOnItsSummary() throws Exception {
        String issue = this.createIssueWithSummary("issue\\");
        String queryWithAnExplicitBackslash = "text ~ \"issue\\\\\"";
        this.assertSearchWithResults(queryWithAnExplicitBackslash, issue);
        String queryWithTheUnicodeCharacterForBackslash = "text ~ \"issue\\u005C\"";
        this.assertSearchWithResults(queryWithTheUnicodeCharacterForBackslash, issue);
    }

    private String createIssueWithSummary(String summary) {
        return this.navigation.issue().createIssue("homosapien", "Bug", summary);
    }

    private String queryWithLuceneOperatorEscaped(String summary, String luceneOperator) {
        return "text ~ \"" + summary + "\\\\" + luceneOperator + "\"";
    }
}

