/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

@Splitable
@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestSystemFieldOperatorUsage
extends FuncTestCase {
    public void testAffectedVersion() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsAffectedVersion.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "affectedVersion";
        String singleLit = "'New Version 4'";
        String listLit = "('New Version 1', 'New Version 4')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'New Version 4'", new String[]{"AFF-2"}));
        matrix.put("!=", new Result("'New Version 4'", new String[]{"AFF-3", "AFF-1"}));
        matrix.put("in", new Result("('New Version 1', 'New Version 4')", new String[]{"AFF-2", "AFF-1"}));
        matrix.put("not in", new Result("('New Version 1', 'New Version 4')", new String[]{"AFF-3"}));
        matrix.put("is", new Result("EMPTY", new String[]{"AFF-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"AFF-3", "AFF-2", "AFF-1"}));
        matrix.put("~", Result.error("'New Version 4'"));
        matrix.put("!~", Result.error("'New Version 4'"));
        matrix.put("<", new Result("'New Version 4'", new String[]{"AFF-1"}));
        matrix.put("<=", new Result("'New Version 4'", new String[]{"AFF-2", "AFF-1"}));
        matrix.put(">", new Result("'New Version 4'", new String[]{"AFF-3"}));
        matrix.put(">=", new Result("'New Version 4'", new String[]{"AFF-3", "AFF-2"}));
        this._testOperatorMatrix("affectedVersion", matrix);
    }

    public void testAssignee() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsAssignee.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "assignee";
        String singleLit = "fred";
        String listLit = "(fred, admin)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("fred", new String[]{"ASS-2"}));
        matrix.put("!=", new Result("fred", new String[]{"ASS-1"}));
        matrix.put("in", new Result("(fred, admin)", new String[]{"ASS-2", "ASS-1"}));
        matrix.put("not in", new Result("(fred, admin)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"ASS-3"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"ASS-2", "ASS-1"}));
        matrix.put("~", Result.error("fred"));
        matrix.put("!~", Result.error("fred"));
        matrix.put("<", Result.error("fred"));
        matrix.put("<=", Result.error("fred"));
        matrix.put(">", Result.error("fred"));
        matrix.put(">=", Result.error("fred"));
        this._testOperatorMatrix("assignee", matrix);
    }

    public void testCategory() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsCategory.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "category";
        String singleLit = "Category1";
        String listLit = "(Category1, Category2)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("Category1", new String[]{"CAT-1"}));
        matrix.put("!=", new Result("Category1", new String[]{"CATTWO-1"}));
        matrix.put("in", new Result("(Category1, Category2)", new String[]{"CATTWO-1", "CAT-1"}));
        matrix.put("not in", new Result("(Category1, Category2)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"NOT-1"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"CATTWO-1", "CAT-1"}));
        matrix.put("~", Result.error("Category1"));
        matrix.put("!~", Result.error("Category1"));
        matrix.put("<", Result.error("Category1"));
        matrix.put("<=", Result.error("Category1"));
        matrix.put(">", Result.error("Category1"));
        matrix.put(">=", Result.error("Category1"));
        this._testOperatorMatrix("category", matrix);
    }

    public void testComment() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsComment.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "comment";
        String singleLit = "TestComment1";
        String listLit = "(TestComment1)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", Result.error("TestComment1"));
        matrix.put("!=", Result.error("TestComment1"));
        matrix.put("in", Result.error("(TestComment1)"));
        matrix.put("not in", Result.error("(TestComment1)"));
        matrix.put("is", Result.errorEmptyNotSupported("EMPTY"));
        matrix.put("is not", Result.errorEmptyNotSupported("EMPTY"));
        matrix.put("~", new Result("TestComment1", new String[]{"COM-1"}));
        matrix.put("!~", new Result("TestComment1", new String[]{"COM-2"}));
        matrix.put("<", Result.error("TestComment1"));
        matrix.put("<=", Result.error("TestComment1"));
        matrix.put(">", Result.error("TestComment1"));
        matrix.put(">=", Result.error("TestComment1"));
        this._testOperatorMatrix("comment", matrix);
    }

    public void testComponent() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsComponent.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "component";
        String singleLit = "'Component 1'";
        String listLit = "('Component 1', 'Component 2')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'Component 1'", new String[]{"CMP-1"}));
        matrix.put("!=", new Result("'Component 1'", new String[]{"CMP-2"}));
        matrix.put("in", new Result("('Component 1', 'Component 2')", new String[]{"CMP-2", "CMP-1"}));
        matrix.put("not in", new Result("('Component 1', 'Component 2')", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"CMP-3"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"CMP-2", "CMP-1"}));
        matrix.put("~", Result.error("'Component 1'"));
        matrix.put("!~", Result.error("'Component 1'"));
        matrix.put("<", Result.error("'Component 1'"));
        matrix.put("<=", Result.error("'Component 1'"));
        matrix.put(">", Result.error("'Component 1'"));
        matrix.put(">=", Result.error("'Component 1'"));
        this._testOperatorMatrix("component", matrix);
    }

    public void testCreated() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsCreated.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "created";
        String singleLit = "'2009-05-14'";
        String listLit = "('2009-05-14')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-14'", new String[0]));
        matrix.put("!=", new Result("'2009-05-14'", new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("in", new Result("('2009-05-14')", new String[0]));
        matrix.put("not in", new Result("('2009-05-14')", new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("~", Result.error("'2009-05-14'"));
        matrix.put("!~", Result.error("'2009-05-14'"));
        matrix.put("<", new Result("'2009-05-14'", new String[]{"CRE-1"}));
        matrix.put("<=", new Result("'2009-05-14'", new String[]{"CRE-1"}));
        matrix.put(">", new Result("'2009-05-14'", new String[]{"CRE-3", "CRE-2"}));
        matrix.put(">=", new Result("'2009-05-14'", new String[]{"CRE-3", "CRE-2"}));
        this._testOperatorMatrix("created", matrix);
    }

    public void testCreatedDate() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsCreated.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "createddate";
        String singleLit = "'2009-05-14'";
        String listLit = "('2009-05-14')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-14'", new String[0]));
        matrix.put("!=", new Result("'2009-05-14'", new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("in", new Result("('2009-05-14')", new String[0]));
        matrix.put("not in", new Result("('2009-05-14')", new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("~", Result.error("'2009-05-14'"));
        matrix.put("!~", Result.error("'2009-05-14'"));
        matrix.put("<", new Result("'2009-05-14'", new String[]{"CRE-1"}));
        matrix.put("<=", new Result("'2009-05-14'", new String[]{"CRE-1"}));
        matrix.put(">", new Result("'2009-05-14'", new String[]{"CRE-3", "CRE-2"}));
        matrix.put(">=", new Result("'2009-05-14'", new String[]{"CRE-3", "CRE-2"}));
        this._testOperatorMatrix("createddate", matrix);
    }

    public void testDescription() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsDescription.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "description";
        String singleLit = "fun";
        String listLit = "(fun)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", Result.error("fun"));
        matrix.put("!=", Result.error("fun"));
        matrix.put("in", Result.error("(fun)"));
        matrix.put("not in", Result.error("(fun)"));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-3"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("~", new Result("fun", new String[]{"HSP-1"}));
        matrix.put("!~", new Result("fun", new String[]{"HSP-2"}));
        matrix.put("<", Result.error("fun"));
        matrix.put("<=", Result.error("fun"));
        matrix.put(">", Result.error("fun"));
        matrix.put(">=", Result.error("fun"));
        this._testOperatorMatrix("description", matrix);
    }

    public void testDue() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsDueDate.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "due";
        String singleLit = "'2009-05-14'";
        String listLit = "('2009-05-13', '2009-05-14')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-14'", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-1"}));
        matrix.put("in", new Result("('2009-05-13', '2009-05-14')", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("('2009-05-13', '2009-05-14')", new String[]{"HSP-3"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("'2009-05-14'"));
        matrix.put("!~", Result.error("'2009-05-14'"));
        matrix.put("<", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("'2009-05-14'", new String[]{"HSP-2", "HSP-1"}));
        matrix.put(">", new Result("'2009-05-14'", new String[]{"HSP-3"}));
        matrix.put(">=", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("due", matrix);
    }

    public void testDueDate() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsDueDate.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "duedate";
        String singleLit = "'2009-05-14'";
        String listLit = "('2009-05-13', '2009-05-14')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-14'", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-1"}));
        matrix.put("in", new Result("('2009-05-13', '2009-05-14')", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("('2009-05-13', '2009-05-14')", new String[]{"HSP-3"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("'2009-05-14'"));
        matrix.put("!~", Result.error("'2009-05-14'"));
        matrix.put("<", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("'2009-05-14'", new String[]{"HSP-2", "HSP-1"}));
        matrix.put(">", new Result("'2009-05-14'", new String[]{"HSP-3"}));
        matrix.put(">=", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("duedate", matrix);
    }

    public void testEnvironment() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsEnvironment.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "environment";
        String singleLit = "fun";
        String listLit = "(fun)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", Result.error("fun"));
        matrix.put("!=", Result.error("fun"));
        matrix.put("in", Result.error("(fun)"));
        matrix.put("not in", Result.error("(fun)"));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-3"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("~", new Result("fun", new String[]{"HSP-1"}));
        matrix.put("!~", new Result("fun", new String[]{"HSP-2"}));
        matrix.put("<", Result.error("fun"));
        matrix.put("<=", Result.error("fun"));
        matrix.put(">", Result.error("fun"));
        matrix.put(">=", Result.error("fun"));
        this._testOperatorMatrix("environment", matrix);
    }

    public void testFixVersion() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsFixVersion.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "fixVersion";
        String singleLit = "'New Version 4'";
        String listLit = "('New Version 1', 'New Version 4')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'New Version 4'", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("'New Version 4'", new String[]{"HSP-3", "HSP-1"}));
        matrix.put("in", new Result("('New Version 1', 'New Version 4')", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("('New Version 1', 'New Version 4')", new String[]{"HSP-3"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("'New Version 4'"));
        matrix.put("!~", Result.error("'New Version 4'"));
        matrix.put("<", new Result("'New Version 4'", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("'New Version 4'", new String[]{"HSP-2", "HSP-1"}));
        matrix.put(">", new Result("'New Version 4'", new String[]{"HSP-3"}));
        matrix.put(">=", new Result("'New Version 4'", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("fixVersion", matrix);
    }

    public void testIssue() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsIssue.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "issue";
        String singleLit = "'HSP-2'";
        String listLit = "('HSP-1', 'HSP-2')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'HSP-2'", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("'HSP-2'", new String[]{"HSP-3", "HSP-1"}));
        matrix.put("in", new Result("('HSP-1', 'HSP-2')", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("('HSP-1', 'HSP-2')", new String[]{"HSP-3"}));
        matrix.put("~", Result.error("'HSP-2'"));
        matrix.put("!~", Result.error("'HSP-2'"));
        matrix.put("<", new Result("'HSP-2'", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("'HSP-2'", new String[]{"HSP-2", "HSP-1"}));
        matrix.put(">", new Result("'HSP-2'", new String[]{"HSP-3"}));
        matrix.put(">=", new Result("'HSP-2'", new String[]{"HSP-3", "HSP-2"}));
        matrix.put("is", Result.error("EMPTY"));
        matrix.put("is not", Result.error("EMPTY"));
        this._testOperatorMatrix("issue", matrix);
    }

    public void testLevel() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsLevel.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "level";
        String singleLit = "'Level 2'";
        String listLit = "('Level 2')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'Level 2'", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("'Level 2'", new String[]{"HSP-1"}));
        matrix.put("in", new Result("('Level 2')", new String[]{"HSP-2"}));
        matrix.put("not in", new Result("('Level 2')", new String[]{"HSP-1"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-3"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("'Level 2'"));
        matrix.put("!~", Result.error("'Level 2'"));
        matrix.put("<", Result.error("'Level 2'"));
        matrix.put("<=", Result.error("'Level 2'"));
        matrix.put(">", Result.error("'Level 2'"));
        matrix.put(">=", Result.error("'Level 2'"));
        this._testOperatorMatrix("level", matrix);
    }

    public void testOriginalEstimate() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsTime.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "originalEstimate";
        String singleLit = "120";
        String listLit = "(60, 120)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("120", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("120", new String[]{"HSP-3", "HSP-1"}));
        matrix.put("in", new Result("(60, 120)", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(60, 120)", new String[]{"HSP-3"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("120"));
        matrix.put("!~", Result.error("120"));
        matrix.put("<", new Result("120", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("120", new String[]{"HSP-2", "HSP-1"}));
        matrix.put(">", new Result("120", new String[]{"HSP-3"}));
        matrix.put(">=", new Result("120", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("originalEstimate", matrix);
    }

    public void testParent() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsParent.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "parent";
        String singleLit = "'HSP-2'";
        String listLit = "('HSP-1', 'HSP-2')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'HSP-2'", new String[]{"HSP-4"}));
        matrix.put("!=", new Result("'HSP-2'", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("in", new Result("('HSP-1', 'HSP-2')", new String[]{"HSP-4", "HSP-3"}));
        matrix.put("not in", new Result("('HSP-1', 'HSP-2')", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("is", Result.error("EMPTY"));
        matrix.put("is not", Result.error("EMPTY"));
        matrix.put("~", Result.error("'HSP-2'"));
        matrix.put("!~", Result.error("'HSP-2'"));
        matrix.put("<", Result.error("'HSP-2'"));
        matrix.put("<=", Result.error("'HSP-2'"));
        matrix.put(">", Result.error("'HSP-2'"));
        matrix.put(">=", Result.error("'HSP-2'"));
        this._testOperatorMatrix("parent", matrix);
    }

    public void testPriority() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsPriority.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "priority";
        String singleLit = "Critical";
        String listLit = "(Blocker, Critical)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("Critical", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("Critical", new String[]{"HSP-3", "HSP-1"}));
        matrix.put("in", new Result("(Blocker, Critical)", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(Blocker, Critical)", new String[]{"HSP-3"}));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("Critical"));
        matrix.put("!~", Result.error("Critical"));
        matrix.put("<", new Result("Critical", new String[]{"HSP-3"}));
        matrix.put("<=", new Result("Critical", new String[]{"HSP-3", "HSP-2"}));
        matrix.put(">", new Result("Critical", new String[]{"HSP-1"}));
        matrix.put(">=", new Result("Critical", new String[]{"HSP-2", "HSP-1"}));
        this._testOperatorMatrix("priority", matrix);
    }

    public void testProject() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsProject.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "project";
        String singleLit = "homosapien";
        String listLit = "(monkey, homosapien)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("homosapien", new String[]{"HSP-1"}));
        matrix.put("!=", new Result("homosapien", new String[]{"MKY-1"}));
        matrix.put("in", new Result("(monkey, homosapien)", new String[]{"MKY-1", "HSP-1"}));
        matrix.put("not in", new Result("(monkey, homosapien)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"MKY-1", "HSP-1"}));
        matrix.put("~", Result.error("homosapien"));
        matrix.put("!~", Result.error("homosapien"));
        matrix.put("<", Result.error("homosapien"));
        matrix.put("<=", Result.error("homosapien"));
        matrix.put(">", Result.error("homosapien"));
        matrix.put(">=", Result.error("homosapien"));
        this._testOperatorMatrix("project", matrix);
    }

    public void testRemainingEstimate() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsTime.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "remainingEstimate";
        String singleLit = "60";
        String listLit = "(40, 60)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("60", new String[]{"HSP-3", "HSP-2"}));
        matrix.put("!=", new Result("60", new String[]{"HSP-1"}));
        matrix.put("in", new Result("(40, 60)", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(40, 60)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("60"));
        matrix.put("!~", Result.error("60"));
        matrix.put("<", new Result("60", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("60", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put(">", new Result("60", new String[0]));
        matrix.put(">=", new Result("60", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("remainingEstimate", matrix);
    }

    public void testReporter() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsReporter.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "reporter";
        String singleLit = "admin";
        String listLit = "(fred, admin)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("admin", new String[]{"HSP-1"}));
        matrix.put("!=", new Result("admin", new String[]{"HSP-2"}));
        matrix.put("in", new Result("(fred, admin)", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(fred, admin)", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("admin"));
        matrix.put("!~", Result.error("admin"));
        matrix.put("<", Result.error("admin"));
        matrix.put("<=", Result.error("admin"));
        matrix.put(">", Result.error("admin"));
        matrix.put(">=", Result.error("admin"));
        this._testOperatorMatrix("reporter", matrix);
    }

    public void testResolution() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsResolution.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "resolution";
        String singleLit = "\"Won't Fix\"";
        String listLit = "(\"Won't Fix\", Fixed)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("\"Won't Fix\"", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("\"Won't Fix\"", new String[]{"HSP-3", "HSP-1"}));
        matrix.put("in", new Result("(\"Won't Fix\", Fixed)", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(\"Won't Fix\", Fixed)", new String[]{"HSP-3"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("\"Won't Fix\""));
        matrix.put("!~", Result.error("\"Won't Fix\""));
        matrix.put("<", new Result("\"Won't Fix\"", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("\"Won't Fix\"", new String[]{"HSP-2", "HSP-1"}));
        matrix.put(">", new Result("\"Won't Fix\"", new String[]{"HSP-3"}));
        matrix.put(">=", new Result("\"Won't Fix\"", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("resolution", matrix);
    }

    public void testResolved() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsResolution.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "resolved";
        String singleLit = "'2009-05-14'";
        String listLit = "('2009-05-14')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-14'", new String[0]));
        matrix.put("!=", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("in", new Result("('2009-05-14')", new String[0]));
        matrix.put("not in", new Result("('2009-05-14')", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("'2009-05-14'"));
        matrix.put("!~", Result.error("'2009-05-14'"));
        matrix.put("<", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put(">", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-2"}));
        matrix.put(">=", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("resolved", matrix);
    }

    public void testResolutionDate() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsResolution.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "resolutionDate";
        String singleLit = "'2009-05-14'";
        String listLit = "('2009-05-14')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-14'", new String[0]));
        matrix.put("!=", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("in", new Result("('2009-05-14')", new String[0]));
        matrix.put("not in", new Result("('2009-05-14')", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("'2009-05-14'"));
        matrix.put("!~", Result.error("'2009-05-14'"));
        matrix.put("<", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put(">", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-2"}));
        matrix.put(">=", new Result("'2009-05-14'", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("resolutionDate", matrix);
    }

    public void testSavedFilter() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsSavedFilter.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "savedFilter";
        String singleLit = "Bugs";
        String listLit = "(Bugs, Tasks)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("Bugs", new String[]{"HSP-1"}));
        matrix.put("!=", new Result("Bugs", new String[]{"HSP-2"}));
        matrix.put("in", new Result("(Bugs, Tasks)", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(Bugs, Tasks)", new String[0]));
        matrix.put("is", Result.error("EMPTY"));
        matrix.put("is not", Result.error("EMPTY"));
        matrix.put("~", Result.error("Bugs"));
        matrix.put("!~", Result.error("Bugs"));
        matrix.put("<", Result.error("Bugs"));
        matrix.put("<=", Result.error("Bugs"));
        matrix.put(">", Result.error("Bugs"));
        matrix.put(">=", Result.error("Bugs"));
        this._testOperatorMatrix("savedFilter", matrix);
    }

    public void testStatus() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsStatus.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "status";
        String singleLit = "Open";
        String listLit = "(Open, 'In Progress')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("Open", new String[]{"HSP-1"}));
        matrix.put("!=", new Result("Open", new String[]{"HSP-2"}));
        matrix.put("in", new Result("(Open, 'In Progress')", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(Open, 'In Progress')", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("Open"));
        matrix.put("!~", Result.error("Open"));
        matrix.put("<", Result.error("Open"));
        matrix.put("<=", Result.error("Open"));
        matrix.put(">", Result.error("Open"));
        matrix.put(">=", Result.error("Open"));
        this._testOperatorMatrix("status", matrix);
    }

    public void testSummary() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsSummary.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "summary";
        String singleLit = "OneTwoThree";
        String listLit = "(OneTwoThree)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", Result.error("OneTwoThree"));
        matrix.put("!=", Result.error("OneTwoThree"));
        matrix.put("in", Result.error("(OneTwoThree)"));
        matrix.put("not in", Result.error("(OneTwoThree)"));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("~", new Result("OneTwoThree", new String[]{"HSP-1"}));
        matrix.put("!~", new Result("OneTwoThree", new String[]{"HSP-2"}));
        matrix.put("<", Result.error("OneTwoThree"));
        matrix.put("<=", Result.error("OneTwoThree"));
        matrix.put(">", Result.error("OneTwoThree"));
        matrix.put(">=", Result.error("OneTwoThree"));
        this._testOperatorMatrix("summary", matrix);
    }

    public void testText() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsSummary.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "text";
        String singleLit = "OneTwoThree";
        String listLit = "(OneTwoThree)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", Result.error("OneTwoThree"));
        matrix.put("!=", Result.error("OneTwoThree"));
        matrix.put("in", Result.error("(OneTwoThree)"));
        matrix.put("not in", Result.error("(OneTwoThree)"));
        matrix.put("is", Result.error("EMPTY"));
        matrix.put("is not", Result.error("EMPTY"));
        matrix.put("~", new Result("OneTwoThree", new String[]{"HSP-1"}));
        matrix.put("!~", Result.error("OneTwoThree"));
        matrix.put("<", Result.error("OneTwoThree"));
        matrix.put("<=", Result.error("OneTwoThree"));
        matrix.put(">", Result.error("OneTwoThree"));
        matrix.put(">=", Result.error("OneTwoThree"));
        this._testOperatorMatrix("text", matrix);
    }

    public void testTimeSpent() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsTime.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "timeSpent";
        String singleLit = "60";
        String listLit = "(20, 60)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("60", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("60", new String[]{"HSP-3", "HSP-1"}));
        matrix.put("in", new Result("(20, 60)", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(20, 60)", new String[]{"HSP-3"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("60"));
        matrix.put("!~", Result.error("60"));
        matrix.put("<", new Result("60", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("60", new String[]{"HSP-2", "HSP-1"}));
        matrix.put(">", new Result("60", new String[]{"HSP-3"}));
        matrix.put(">=", new Result("60", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("timeSpent", matrix);
    }

    public void testType() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsType.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "type";
        String singleLit = "Bug";
        String listLit = "(Bug, 'New Feature')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("Bug", new String[]{"HSP-1"}));
        matrix.put("!=", new Result("Bug", new String[]{"HSP-2"}));
        matrix.put("in", new Result("(Bug, 'New Feature')", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(Bug, 'New Feature')", new String[0]));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("Bug"));
        matrix.put("!~", Result.error("Bug"));
        matrix.put("<", Result.error("Bug"));
        matrix.put("<=", Result.error("Bug"));
        matrix.put(">", Result.error("Bug"));
        matrix.put(">=", Result.error("Bug"));
        this._testOperatorMatrix("type", matrix);
    }

    public void testUpdated() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsResolution.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "updated";
        String singleLit = "'2009-05-14'";
        String listLit = "('2009-05-14')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-14'", new String[0]));
        matrix.put("!=", new Result("'2009-05-14'", new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("in", new Result("('2009-05-14')", new String[0]));
        matrix.put("not in", new Result("('2009-05-14')", new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("'2009-05-14'"));
        matrix.put("!~", Result.error("'2009-05-14'"));
        matrix.put("<", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put(">", new Result("'2009-05-14'", new String[]{"HSP-4", "HSP-3", "HSP-2"}));
        matrix.put(">=", new Result("'2009-05-14'", new String[]{"HSP-4", "HSP-3", "HSP-2"}));
        this._testOperatorMatrix("updated", matrix);
    }

    public void testUpdatedDate() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsResolution.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "updateddate";
        String singleLit = "'2009-05-14'";
        String listLit = "('2009-05-14')";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("'2009-05-14'", new String[0]));
        matrix.put("!=", new Result("'2009-05-14'", new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("in", new Result("('2009-05-14')", new String[0]));
        matrix.put("not in", new Result("('2009-05-14')", new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("is", new Result("EMPTY", new String[0]));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("'2009-05-14'"));
        matrix.put("!~", Result.error("'2009-05-14'"));
        matrix.put("<", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("'2009-05-14'", new String[]{"HSP-1"}));
        matrix.put(">", new Result("'2009-05-14'", new String[]{"HSP-4", "HSP-3", "HSP-2"}));
        matrix.put(">=", new Result("'2009-05-14'", new String[]{"HSP-4", "HSP-3", "HSP-2"}));
        this._testOperatorMatrix("updateddate", matrix);
    }

    public void testVotes() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsVotes.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "votes";
        String singleLit = "1";
        String listLit = "(1, 2)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("1", new String[]{"HSP-1"}));
        matrix.put("!=", new Result("1", new String[]{"HSP-3", "HSP-2"}));
        matrix.put("in", new Result("(1, 2)", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(1, 2)", new String[]{"HSP-3"}));
        matrix.put("is", Result.error("EMPTY"));
        matrix.put("is not", Result.error("EMPTY"));
        matrix.put("~", Result.error("1"));
        matrix.put("!~", Result.error("1"));
        matrix.put("<", new Result("1", new String[]{"HSP-3"}));
        matrix.put("<=", new Result("1", new String[]{"HSP-3", "HSP-1"}));
        matrix.put(">", new Result("1", new String[]{"HSP-2"}));
        matrix.put(">=", new Result("1", new String[]{"HSP-2", "HSP-1"}));
        this._testOperatorMatrix("votes", matrix);
    }

    public void testWorkRatio() throws Exception {
        this.administration.restoreData("TestSystemFieldOperatorsTime.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "workRatio";
        String singleLit = "50";
        String listLit = "(33, 50)";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("=", new Result("50", new String[]{"HSP-2"}));
        matrix.put("!=", new Result("50", new String[]{"HSP-3", "HSP-1"}));
        matrix.put("in", new Result("(33, 50)", new String[]{"HSP-2", "HSP-1"}));
        matrix.put("not in", new Result("(33, 50)", new String[]{"HSP-3"}));
        matrix.put("is", new Result("EMPTY", new String[]{"HSP-4"}));
        matrix.put("is not", new Result("EMPTY", new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("~", Result.error("50"));
        matrix.put("!~", Result.error("50"));
        matrix.put("<", new Result("50", new String[]{"HSP-1"}));
        matrix.put("<=", new Result("50", new String[]{"HSP-2", "HSP-1"}));
        matrix.put(">", new Result("50", new String[]{"HSP-3"}));
        matrix.put(">=", new Result("50", new String[]{"HSP-3", "HSP-2"}));
        this._testOperatorMatrix("workRatio", matrix);
    }

    private void _testOperatorMatrix(String fieldName, Map<String, Result> matrix) {
        for (Map.Entry<String, Result> testEntry : matrix.entrySet()) {
            String operator = testEntry.getKey();
            Result result = testEntry.getValue();
            String operand = result.operand;
            String jqlQuery = String.format("%s %s %s", fieldName, operator, operand);
            String[] keys = result.issueKeys;
            ErrorType errorType = result.errorType;
            if (keys == null && errorType != null) {
                String errorMsg = errorType.formatError(fieldName, operator);
                this.issueTableAssertions.assertSearchWithError(jqlQuery, errorMsg);
                continue;
            }
            this.assertSearchResults(jqlQuery, keys);
        }
    }

    private void assertSearchResults(String jqlQuery, String ... issueKeys) {
        ArrayList<ContainsIssueKeysCondition> conditions = new ArrayList<ContainsIssueKeysCondition>();
        conditions.add(new ContainsIssueKeysCondition(this.assertions.getTextAssertions(), issueKeys));
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(conditions);
    }

    private static enum ErrorType {
        EMPTY_NOT_SUPPORTED{

            @Override
            String formatError(String fieldName, String operator) {
                return String.format("The field '%s' does not support searching for EMPTY values.", fieldName);
            }
        }
        ,
        OPERATOR_NOT_SUPPORTED{

            @Override
            String formatError(String fieldName, String operator) {
                return String.format("The operator '%s' is not supported by the '%s' field.", operator, fieldName);
            }
        };


        abstract String formatError(String var1, String var2);
    }

    private static class Result {
        private String operand;
        private String[] issueKeys;
        private ErrorType errorType;

        private static Result error(String operand) {
            return new Result(operand, null, ErrorType.OPERATOR_NOT_SUPPORTED);
        }

        private static Result errorEmptyNotSupported(String operand) {
            return new Result(operand, null, ErrorType.EMPTY_NOT_SUPPORTED);
        }

        private Result(String operand, String ... issueKeys) {
            this.operand = operand;
            this.issueKeys = issueKeys;
            this.errorType = null;
        }

        private Result(String operand, String[] issueKeys, ErrorType errorType) {
            this.operand = operand;
            this.issueKeys = issueKeys;
            this.errorType = errorType;
        }
    }
}

