/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.util.concurrent.atomic.AtomicBoolean;

@Splitable
@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestSystemFieldDoesItFitMultiple
extends AbstractJqlFuncTest {
    private static final ThreadLocal<AtomicBoolean> dataSetUp = new ThreadLocal<AtomicBoolean>(){

        @Override
        protected AtomicBoolean initialValue() {
            return new AtomicBoolean(false);
        }
    };

    @Override
    protected void setUpTest() {
        super.setUpTest();
        if (!dataSetUp.get().getAndSet(true)) {
            this.administration.restoreData("TestSystemFieldDoesItFitMultiple.xml");
            this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        }
    }

    public void testAffectedVersion() throws Exception {
        String fieldName = "affectedVersion";
        this.assertOrTooComplex("affectedVersion", "\"New Version 1\"", "\"New Version 4\"");
        this.assertAndTooComplex("affectedVersion", "\"New Version 1\"", "\"New Version 4\"");
        this.assertTooComplex("affectedVersion IN (10000, 100001)");
        this.assertAndWithHspFitsFilterForm("affectedVersion = \"New Version 1\"", TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", "New Version 1"));
        this.assertOrWithHspTooComplex("affectedVersion = \"New Version 1\"");
        this.assertAndWithHspTooComplex("affectedVersion != \"New Version 1\"");
        this.assertAndWithHspTooComplex("affectedVersion >= 10000");
        this.assertAndWithHspTooComplex("affectedVersion > 10000");
        this.assertAndWithHspTooComplex("affectedVersion <= 10000");
        this.assertAndWithHspTooComplex("affectedVersion < 10000");
        this.assertAndWithHspFitsFilterForm("affectedVersion is EMPTY", TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", "-1"));
        this.assertAndWithHspTooComplex("affectedVersion is not EMPTY");
        this.assertAndWithHspFitsFilterForm("affectedVersion in (\"New Version 1\", \"New Version 4\")", TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", "New Version 1", "New Version 4"));
        this.assertAndWithHspTooComplex("affectedVersion not in (\"New Version 1\", \"New Version 4\")");
        this.assertAndWithHspTooComplex("affectedVersion in releasedVersions(HSP)");
        this.assertAndWithHspFitsFilterForm("affectedVersion in releasedVersions()", TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", "-3"));
        this.assertAndWithHspTooComplex("affectedVersion not in releasedVersions()");
        this.assertAndWithHspTooComplex("affectedVersion in unreleasedVersions(HSP)");
        this.assertAndWithHspFitsFilterForm("affectedVersion in unreleasedVersions()", TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", "-2"));
        this.assertAndWithHspTooComplex("affectedVersion not in unreleasedVersions()");
        this.assertFitsFilterForm("affectedVersion = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("affectedVersion IN (\"New Version 1\", MonkeyVersion)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("project = MKY AND affectedVersion in releasedVersions()", TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", null));
        this.assertFitsFilterForm("project = MKY AND affectedVersion = MonkeyVersion", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "MKY"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", "MonkeyVersion"));
        this.assertFitsFilterForm("project in (HSP, MKY) AND affectedVersion = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("project = HSP AND affectedVersion IN (\"New Version 1\", MonkeyVersion)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "MKY"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", "10000", "MonkeyVersion"));
        this.assertFitsFilterForm("project = HSP AND (status = Open AND affectedVersion = MonkeyVersion)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("pid", "10000"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", "MonkeyVersion"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "1"));
    }

    public void testAssignee() throws Exception {
        String fieldName = "assignee";
        this.assertOrTooComplex("assignee", "admin", "fred");
        this.assertAndTooComplex("assignee", "admin", "fred");
        this.assertAndWithHspFitsFilterForm("assignee = fred", TestSystemFieldDoesItFitMultiple.createFilterFormParam("assignee", "fred"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("assigneeSelect", "specificuser"));
        this.assertOrWithHspTooComplex("assignee = fred");
    }

    public void testQuery() throws Exception {
        this.assertOrTooComplex("text", "~", "ccc", "ccc");
        this.assertAndTooComplex("text", "~", "ccc", "ccc");
        this.assertOrTooComplex("text", "~", "ccc", "different");
        IssueNavigatorAssertions.FilterFormParam queryGood = TestSystemFieldDoesItFitMultiple.createFilterFormParam("text", "ccc");
        this.assertFitsFilterForm("text ~ ccc", queryGood);
        this.assertTooComplex("comment ~ ccc OR environment ~ ccc");
        this.assertTooComplex("comment ~ ccc OR summary ~ ccc");
        this.assertTooComplex("comment ~ ccc OR description ~ ccc OR environment ~ ccc");
        this.assertTooComplex("comment ~ ccc OR description ~ ccc OR summary ~ ccc");
        this.assertTooComplex("comment ~ ccc OR environment ~ ccc OR summary ~ ccc");
        this.assertTooComplex("comment ~ ccc OR description ~ ccc OR environment ~ ccc OR summary ~ ccc");
        this.assertTooComplex("description ~ ccc OR environment ~ ccc");
        this.assertTooComplex("description ~ ccc OR summary ~ ccc");
        this.assertTooComplex("description ~ ccc OR environment ~ ccc OR summary ~ ccc");
        this.assertTooComplex("environment ~ ccc OR summary ~ ccc");
        this.assertTooComplex("comment ~ ccc OR description !~ ccc");
        this.assertTooComplex("comment ~ ccc OR description ~ different");
        this.assertTooComplex("comment ~ ccc OR description is EMPTY");
        this.assertTooComplex("(comment ~ ccc OR description ~ ccc) OR (environment ~ ccc OR summary ~ ccc)");
    }

    public void testComponent() throws Exception {
        String fieldName = "component";
        this.assertOrTooComplex("component", "\"New Component 1\"", "\"New Component 2\"");
        this.assertAndTooComplex("component", "\"New Component 1\"", "\"New Component 2\"");
        this.assertTooComplex("component IN (10000, 100001)");
        this.assertAndWithHspFitsFilterForm("component = \"New Component 1\"", TestSystemFieldDoesItFitMultiple.createFilterFormParam("component", "New Component 1"));
        this.assertOrWithHspTooComplex("component = \"New Component 1\"");
        this.assertAndWithHspTooComplex("component != \"New Component 1\"");
        this.assertAndWithHspFitsFilterForm("component is EMPTY", TestSystemFieldDoesItFitMultiple.createFilterFormParam("component", "-1"));
        this.assertAndWithHspTooComplex("component is not EMPTY");
        this.assertAndWithHspFitsFilterForm("component in (\"New Component 1\", \"New Component 2\")", TestSystemFieldDoesItFitMultiple.createFilterFormParam("component", "New Component 1", "New Component 2"));
        this.assertAndWithHspTooComplex("component not in (\"New Component 1\", \"New Component 2\")");
        this.assertFitsFilterForm("component = \"New Component 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("component IN (\"New Component 1\", MonkeyComponent)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("project = MKY AND component = MonkeyComponent", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "MKY"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("component", "MonkeyComponent"));
        this.assertFitsFilterForm("project in (HSP, MKY) AND component = \"New Component 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("project = HSP AND component IN (\"New Component 1\", MonkeyComponent)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "MKY"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("version", "New Component 1", "MonkeyComponent"));
        this.assertFitsFilterForm("project = HSP AND (status = Open AND component = MonkeyComponent)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("pid", "10000"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("component", "MonkeyComponent"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "1"));
    }

    public void testCreated() throws Exception {
        IssueNavigatorAssertions.FilterFormParam afterAbs = TestSystemFieldDoesItFitMultiple.createFilterFormParam("created:after", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = TestSystemFieldDoesItFitMultiple.createFilterFormParam("created:before", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeRel = TestSystemFieldDoesItFitMultiple.createFilterFormParam("created:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = TestSystemFieldDoesItFitMultiple.createFilterFormParam("created:previous", "1d");
        this.assertFitsFilterForm("created >= '2009-05-11' AND created <= '2009-05-11'", afterAbs, beforeAbs);
        this.assertFitsFilterForm("created >= '2009-05-11' AND created <= '1d'", afterAbs, beforeRel);
        this.assertFitsFilterForm("created >= '1d' AND created <= '2009-05-11'", afterRel, beforeAbs);
        this.assertFitsFilterForm("created >= '1d' AND created <= '1d'", afterRel, beforeRel);
        this.assertFitsFilterForm("created >= '2009-05-11' AND created <= '2009-05-11' AND created >= '1d'", afterAbs, beforeAbs, afterRel);
        this.assertFitsFilterForm("created >= '2009-05-11' AND created <= '2009-05-11' AND created <= '1d'", afterAbs, beforeAbs, beforeRel);
        this.assertFitsFilterForm("created >= '1d' AND created <= '2009-05-11' AND created >= '2009-05-11'", afterRel, beforeAbs, afterAbs);
        this.assertFitsFilterForm("created >= '1d' AND created <= '1d' AND created <= '2009-05-11'", afterRel, beforeRel, beforeAbs);
        this.assertFitsFilterForm("created >= '1d' AND created <= '1d' AND created >= '2009-05-11' AND created <= '2009-05-11'", afterRel, beforeRel, afterAbs, beforeAbs);
        this.assertTooComplex("created >= '1d' OR created <= '1d'");
        this.assertTooComplex("created >= '1d' AND created >= '2d'");
        this.assertTooComplex("created <= '1d' AND created <= '2d'");
        this.assertTooComplex("created > '1d' AND created <= '1d' AND created >= '2009-05-11' AND created <= '2009-05-11'");
        this.assertTooComplex("created >= 1234567890 AND created <= '1d' AND created >= '2009-05-11' AND created <= '2009-05-11'");
        this.assertFitsFilterForm("(project = HSP AND created <= '1d') AND (status = Open AND created <= '2009-05-11')", TestSystemFieldDoesItFitMultiple.createFilterFormParam("pid", "10000"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "1"), beforeRel, beforeAbs);
        this.assertAndWithHspFitsFilterForm("created >= '1d'", afterRel);
        this.assertOrWithHspTooComplex("created >= '1d'");
    }

    public void testDueDate() throws Exception {
        IssueNavigatorAssertions.FilterFormParam afterAbs = TestSystemFieldDoesItFitMultiple.createFilterFormParam("duedate:after", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = TestSystemFieldDoesItFitMultiple.createFilterFormParam("duedate:before", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeRel = TestSystemFieldDoesItFitMultiple.createFilterFormParam("duedate:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = TestSystemFieldDoesItFitMultiple.createFilterFormParam("duedate:previous", "1d");
        this.assertFitsFilterForm("due >= '2009-05-11' AND due <= '2009-05-11'", afterAbs, beforeAbs);
        this.assertFitsFilterForm("due >= '2009-05-11' AND due <= '1d'", afterAbs, beforeRel);
        this.assertFitsFilterForm("due >= '1d' AND due <= '2009-05-11'", afterRel, beforeAbs);
        this.assertFitsFilterForm("due >= '1d' AND due <= '1d'", afterRel, beforeRel);
        this.assertFitsFilterForm("due >= '2009-05-11' AND due <= '2009-05-11' AND due >= '1d'", afterAbs, beforeAbs, afterRel);
        this.assertFitsFilterForm("due >= '2009-05-11' AND due <= '2009-05-11' AND due <= '1d'", afterAbs, beforeAbs, beforeRel);
        this.assertFitsFilterForm("due >= '1d' AND due <= '2009-05-11' AND due >= '2009-05-11'", afterRel, beforeAbs, afterAbs);
        this.assertFitsFilterForm("due >= '1d' AND due <= '1d' AND due <= '2009-05-11'", afterRel, beforeRel, beforeAbs);
        this.assertFitsFilterForm("due >= '1d' AND due <= '1d' AND due >= '2009-05-11' AND due <= '2009-05-11'", afterRel, beforeRel, afterAbs, beforeAbs);
        this.assertTooComplex("due >= '1d' OR due <= '1d'");
        this.assertTooComplex("due >= '1d' AND due >= '2d'");
        this.assertTooComplex("due <= '1d' AND due <= '2d'");
        this.assertTooComplex("due > '1d' AND due <= '1d' AND due >= '2009-05-11' AND due <= '2009-05-11'");
        this.assertTooComplex("due >= 1234567890 AND due <= '1d' AND due >= '2009-05-11' AND due <= '2009-05-11'");
        this.assertFitsFilterForm("(project = HSP AND due <= '1d') AND (status = Open AND due <= '2009-05-11')", TestSystemFieldDoesItFitMultiple.createFilterFormParam("pid", "10000"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "1"), beforeRel, beforeAbs);
        this.assertAndWithHspFitsFilterForm("due >= '1d'", afterRel);
        this.assertOrWithHspTooComplex("due >= '1d'");
    }

    public void testFixVersion() throws Exception {
        String fieldName = "fixVersion";
        this.assertOrTooComplex("fixVersion", "\"New Version 1\"", "\"New Version 4\"");
        this.assertAndTooComplex("fixVersion", "\"New Version 1\"", "\"New Version 4\"");
        this.assertTooComplex("fixVersion IN (10000, 100001)");
        this.assertAndWithHspFitsFilterForm("fixVersion = \"New Version 1\"", TestSystemFieldDoesItFitMultiple.createFilterFormParam("fixfor", "New Version 1"));
        this.assertOrWithHspTooComplex("fixVersion = \"New Version 1\"");
        this.assertAndWithHspTooComplex("fixVersion != \"New Version 1\"");
        this.assertAndWithHspTooComplex("fixVersion >= 10000");
        this.assertAndWithHspTooComplex("fixVersion > 10000");
        this.assertAndWithHspTooComplex("fixVersion <= 10000");
        this.assertAndWithHspTooComplex("fixVersion < 10000");
        this.assertAndWithHspFitsFilterForm("fixVersion is EMPTY", TestSystemFieldDoesItFitMultiple.createFilterFormParam("fixfor", "-1"));
        this.assertAndWithHspTooComplex("fixVersion is not EMPTY");
        this.assertAndWithHspFitsFilterForm("fixVersion in (\"New Version 1\", \"New Version 4\")", TestSystemFieldDoesItFitMultiple.createFilterFormParam("fixfor", "New Version 1", "New Version 4"));
        this.assertAndWithHspTooComplex("fixVersion not in (\"New Version 1\", \"New Version 4\")");
        this.assertAndWithHspTooComplex("fixVersion in releasedVersions(HSP)");
        this.assertAndWithHspFitsFilterForm("fixVersion in releasedVersions()", TestSystemFieldDoesItFitMultiple.createFilterFormParam("fixfor", "-3"));
        this.assertAndWithHspTooComplex("fixVersion not in releasedVersions()");
        this.assertAndWithHspTooComplex("fixVersion in unreleasedVersions(HSP)");
        this.assertAndWithHspFitsFilterForm("fixVersion in unreleasedVersions()", TestSystemFieldDoesItFitMultiple.createFilterFormParam("fixfor", "-2"));
        this.assertAndWithHspTooComplex("fixVersion not in unreleasedVersions()");
        this.assertFitsFilterForm("fixVersion = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("fixVersion IN (\"New Version 1\", MonkeyVersion)", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("project = MKY AND fixVersion in releasedVersions()", TestSystemFieldDoesItFitMultiple.createFilterFormParam("fixfor", null));
        this.assertFitsFilterForm("project = MKY AND fixVersion = MonkeyVersion", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "MKY"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("fixfor", "MonkeyVersion"));
        this.assertFitsFilterForm("project in (HSP, MKY) AND fixVersion = \"New Version 1\"", new IssueNavigatorAssertions.FilterFormParam[0]);
        this.assertFitsFilterForm("project = HSP AND fixVersion IN (\"New Version 1\", MonkeyVersion)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "MKY"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("fixfor", "10000", "MonkeyVersion"));
        this.assertFitsFilterForm("project = HSP AND (status = Open AND affectedVersion = MonkeyVersion)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("pid", "10000"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("fixfor", "MonkeyVersion"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "1"));
    }

    public void testPriority() throws Exception {
        String fieldName = "priority";
        this.assertOrTooComplex("priority", "Blocker", "Critical");
        this.assertAndTooComplex("priority", "Blocker", "Critical");
        this.assertAndWithHspFitsFilterForm("priority = Blocker", TestSystemFieldDoesItFitMultiple.createFilterFormParam("priority", "1"));
        this.assertAndWithHspFitsFilterForm("priority IN (Blocker, Critical)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("priority", "1", "2"));
        this.assertOrWithHspTooComplex("priority = Blocker");
    }

    public void testProject() throws Exception {
        String fieldName = "project";
        this.assertOrTooComplex("project", "HSP", "MKY");
        this.assertAndTooComplex("project", "HSP", "MKY");
    }

    public void testReporter() throws Exception {
        String fieldName = "reporter";
        this.assertOrTooComplex("reporter", "admin", "fred");
        this.assertAndTooComplex("reporter", "admin", "fred");
        this.assertAndWithHspFitsFilterForm("reporter = fred", TestSystemFieldDoesItFitMultiple.createFilterFormParam("reporter", "fred"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("reporterSelect", "specificuser"));
        this.assertOrWithHspTooComplex("reporter = fred");
    }

    public void testResolution() throws Exception {
        String fieldName = "resolution";
        this.assertOrTooComplex("resolution", "Fixed", "Duplicate");
        this.assertAndTooComplex("resolution", "Fixed", "Duplicate");
        this.assertAndWithHspFitsFilterForm("resolution = Fixed", TestSystemFieldDoesItFitMultiple.createFilterFormParam("resolution", "1"));
        this.assertAndWithHspFitsFilterForm("resolution IN (Fixed, Duplicate)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("resolution", "1", "3"));
        this.assertOrWithHspTooComplex("resolution = Fixed");
    }

    public void testResolutionDate() throws Exception {
        IssueNavigatorAssertions.FilterFormParam afterAbs = TestSystemFieldDoesItFitMultiple.createFilterFormParam("resolutiondate:after", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = TestSystemFieldDoesItFitMultiple.createFilterFormParam("resolutiondate:before", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeRel = TestSystemFieldDoesItFitMultiple.createFilterFormParam("resolutiondate:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = TestSystemFieldDoesItFitMultiple.createFilterFormParam("resolutiondate:previous", "1d");
        this.assertFitsFilterForm("resolved >= '2009-05-11' AND resolved <= '2009-05-11'", afterAbs, beforeAbs);
        this.assertFitsFilterForm("resolved >= '2009-05-11' AND resolved <= '1d'", afterAbs, beforeRel);
        this.assertFitsFilterForm("resolved >= '1d' AND resolved <= '2009-05-11'", afterRel, beforeAbs);
        this.assertFitsFilterForm("resolved >= '1d' AND resolved <= '1d'", afterRel, beforeRel);
        this.assertFitsFilterForm("resolved >= '2009-05-11' AND resolved <= '2009-05-11' AND resolved >= '1d'", afterAbs, beforeAbs, afterRel);
        this.assertFitsFilterForm("resolved >= '2009-05-11' AND resolved <= '2009-05-11' AND resolved <= '1d'", afterAbs, beforeAbs, beforeRel);
        this.assertFitsFilterForm("resolved >= '1d' AND resolved <= '2009-05-11' AND resolved >= '2009-05-11'", afterRel, beforeAbs, afterAbs);
        this.assertFitsFilterForm("resolved >= '1d' AND resolved <= '1d' AND resolved <= '2009-05-11'", afterRel, beforeRel, beforeAbs);
        this.assertFitsFilterForm("resolved >= '1d' AND resolved <= '1d' AND resolved >= '2009-05-11' AND resolved <= '2009-05-11'", afterRel, beforeRel, afterAbs, beforeAbs);
        this.assertTooComplex("resolved >= '1d' OR resolved <= '1d'");
        this.assertTooComplex("resolved >= '1d' AND resolved >= '2d'");
        this.assertTooComplex("resolved <= '1d' AND resolved <= '2d'");
        this.assertTooComplex("resolved > '1d' AND resolved <= '1d' AND resolved >= '2009-05-11' AND resolved <= '2009-05-11'");
        this.assertTooComplex("resolved >= 1234567890 AND resolved <= '1d' AND resolved >= '2009-05-11' AND resolved <= '2009-05-11'");
        this.assertFitsFilterForm("(project = HSP AND resolved <= '1d') AND (status = Open AND resolved <= '2009-05-11')", TestSystemFieldDoesItFitMultiple.createFilterFormParam("pid", "10000"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "1"), beforeRel, beforeAbs);
        this.assertAndWithHspFitsFilterForm("resolved >= '1d'", afterRel);
        this.assertOrWithHspTooComplex("resolved >= '1d'");
    }

    public void testStatus() throws Exception {
        String fieldName = "status";
        this.assertOrTooComplex("status", "Open", "Resolved");
        this.assertAndTooComplex("status", "Open", "Resolved");
        this.assertAndWithHspFitsFilterForm("status = Open", TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "1"));
        this.assertAndWithHspFitsFilterForm("status IN (Open, Resolved)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "1", "5"));
        this.assertOrWithHspTooComplex("status = Open");
        this.assertAndWithHspFitsFilterForm("status = hsp_status", TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "10001"));
        this.assertFitsFilterForm("project = HSP and status = mky_status", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "HSP"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "mky_status"));
        this.assertFitsFilterForm("project = HSP and status = mky_bug_status", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "HSP"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "mky_status"));
        this.assertFitsFilterForm("project = HSP and type = bug and status = mky_bug_status", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "HSP"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "bug"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "mky_bug_status"));
        this.assertFitsFilterForm("project = MKY and type = improvement and status = mky_bug_status", TestSystemFieldDoesItFitMultiple.createFilterFormParam("project", "MKY"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "improvement"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "mky_bug_status"));
        this.assertFitsFilterForm("project = MKY and status = mky_bug_status", TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "10002"));
        this.assertFitsFilterForm("project = MKY and type = bug and status = mky_bug_status", TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "10002"));
    }

    public void testType() throws Exception {
        this.administration.activateSubTasks();
        String fieldName = "type";
        this.assertOrTooComplex("type", "Bug", "Task");
        this.assertAndTooComplex("type", "Bug", "Task");
        this.assertAndWithHspFitsFilterForm("type = Bug", TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "1"));
        this.assertOrWithHspTooComplex("type = Bug");
        this.assertAndWithHspFitsFilterForm("type in (Bug, Task)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "1", "3"));
        this.assertAndWithHspFitsFilterForm("type in standardIssueTypes()", TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "-2"));
        this.assertAndWithHspFitsFilterForm("type in subTaskIssueTypes()", TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "-3"));
        this.assertAndWithHspFitsFilterForm("type = hsp_type", TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "6"));
        this.assertAndWithHspFitsFilterForm("type = mky_type", TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "mky_type"));
        this.assertAndWithHspFitsFilterForm("type in (mky_type, hsp_type)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "mky_type", "hsp_type"));
        this.assertFitsFilterForm("project in (mky, hsp) and type in (mky_type, hsp_type)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "6", "7"));
        this.assertFitsFilterForm("type in (mky_type, hsp_type)", TestSystemFieldDoesItFitMultiple.createFilterFormParam("type", "6", "7"));
    }

    public void testUpdated() throws Exception {
        IssueNavigatorAssertions.FilterFormParam afterAbs = TestSystemFieldDoesItFitMultiple.createFilterFormParam("updated:after", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeAbs = TestSystemFieldDoesItFitMultiple.createFilterFormParam("updated:before", "11/May/09");
        IssueNavigatorAssertions.FilterFormParam beforeRel = TestSystemFieldDoesItFitMultiple.createFilterFormParam("updated:next", "1d");
        IssueNavigatorAssertions.FilterFormParam afterRel = TestSystemFieldDoesItFitMultiple.createFilterFormParam("updated:previous", "1d");
        this.assertFitsFilterForm("updated >= '2009-05-11' AND updated <= '2009-05-11'", afterAbs, beforeAbs);
        this.assertFitsFilterForm("updated >= '2009-05-11' AND updated <= '1d'", afterAbs, beforeRel);
        this.assertFitsFilterForm("updated >= '1d' AND updated <= '2009-05-11'", afterRel, beforeAbs);
        this.assertFitsFilterForm("updated >= '1d' AND updated <= '1d'", afterRel, beforeRel);
        this.assertFitsFilterForm("updated >= '2009-05-11' AND updated <= '2009-05-11' AND updated >= '1d'", afterAbs, beforeAbs, afterRel);
        this.assertFitsFilterForm("updated >= '2009-05-11' AND updated <= '2009-05-11' AND updated <= '1d'", afterAbs, beforeAbs, beforeRel);
        this.assertFitsFilterForm("updated >= '1d' AND updated <= '2009-05-11' AND updated >= '2009-05-11'", afterRel, beforeAbs, afterAbs);
        this.assertFitsFilterForm("updated >= '1d' AND updated <= '1d' AND updated <= '2009-05-11'", afterRel, beforeRel, beforeAbs);
        this.assertFitsFilterForm("updated >= '1d' AND updated <= '1d' AND updated >= '2009-05-11' AND updated <= '2009-05-11'", afterRel, beforeRel, afterAbs, beforeAbs);
        this.assertTooComplex("updated >= '1d' OR updated <= '1d'");
        this.assertTooComplex("updated >= '1d' AND updated >= '2d'");
        this.assertTooComplex("updated <= '1d' AND updated <= '2d'");
        this.assertTooComplex("updated > '1d' AND updated <= '1d' AND updated >= '2009-05-11' AND updated <= '2009-05-11'");
        this.assertTooComplex("updated >= 1234567890 AND updated <= '1d' AND updated >= '2009-05-11' AND updated <= '2009-05-11'");
        this.assertFitsFilterForm("(project = HSP AND updated <= '1d') AND (status = Open AND updated <= '2009-05-11')", TestSystemFieldDoesItFitMultiple.createFilterFormParam("pid", "10000"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("status", "1"), beforeRel, beforeAbs);
        this.assertAndWithHspFitsFilterForm("updated >= '1d'", afterRel);
        this.assertOrWithHspTooComplex("updated >= '1d'");
    }

    public void testWorkRatio() throws Exception {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.assertFitsFilterForm("workratio >= '10' AND workratio <= '20'", TestSystemFieldDoesItFitMultiple.createFilterFormParam("workratio:min", "10"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("workratio:max", "20"));
        this.assertFitsFilterForm("(project = HSP AND workratio >= '10') AND workratio <= '20'", TestSystemFieldDoesItFitMultiple.createFilterFormParam("pid", "10000"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("workratio:min", "10"), TestSystemFieldDoesItFitMultiple.createFilterFormParam("workratio:max", "20"));
        this.assertTooComplex("workratio >= '10' OR workratio <= '10'");
        this.assertTooComplex("workratio >= '10' AND workratio >= '20'");
        this.assertTooComplex("workratio <= '10' AND workratio <= '20'");
        this.assertTooComplex("workratio > '10' AND workratio <= '20'");
        this.assertAndWithHspFitsFilterForm("workratio >= '10'", TestSystemFieldDoesItFitMultiple.createFilterFormParam("workratio:min", "10"));
        this.assertOrWithHspTooComplex("workratio >= '10'");
    }

    private void assertAndWithHspFitsFilterForm(String jqlQuery, IssueNavigatorAssertions.FilterFormParam ... formParams) {
        IssueNavigatorAssertions.FilterFormParam[] params = new IssueNavigatorAssertions.FilterFormParam[formParams.length + 1];
        params[0] = TestSystemFieldDoesItFitMultiple.createFilterFormParam("pid", "10000");
        System.arraycopy(formParams, 0, params, 1, formParams.length);
        this.assertFitsFilterForm(String.format("project = HSP AND %s", jqlQuery), params);
    }

    private void assertOrTooComplex(String fieldName, String operand1, String operand2) {
        this.assertOrTooComplex(fieldName, "=", operand1, operand2);
    }

    private void assertOrTooComplex(String fieldName, String operator, String operand1, String operand2) {
        this.assertTooComplex(String.format("%1$s %2$s %3$s OR %1$s %2$s %4$s", fieldName, operator, operand1, operand2));
    }

    private void assertAndTooComplex(String fieldName, String operand1, String operand2) {
        this.assertTooComplex(String.format("%1$s = %2$s AND %1$s = %3$s", fieldName, operand1, operand2));
    }

    private void assertAndTooComplex(String fieldName, String operator, String operand1, String operand2) {
        this.assertTooComplex(String.format("%1$s %2$s %3$s AND %1$s %2$s %4$s", fieldName, operator, operand1, operand2));
    }

    private void assertAndWithHspTooComplex(String jqlQuery) {
        this.assertAndWithProjectTooComplex("HSP", jqlQuery);
    }

    private void assertOrWithHspTooComplex(String jqlQuery) {
        this.assertOrWithProjectTooComplex("HSP", jqlQuery);
    }

    private void assertAndWithProjectTooComplex(String project, String jqlQuery) {
        this.assertTooComplex(String.format("project = %s AND %s", project, jqlQuery));
    }

    private void assertOrWithProjectTooComplex(String project, String jqlQuery) {
        this.assertTooComplex(String.format("project = %s OR %s", project, jqlQuery));
    }
}

