/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.w3c.dom.Document;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestSearchValidationCanBeDisabled
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.backdoor.restoreBlankInstance();
        this.backdoor.issues().createIssue("HSP", "my issue");
    }

    public void testIssueNavXmlView() throws Exception {
        String hsp1 = "HSP-1";
        String hsp123 = "HSP-123";
        String jql = String.format("key in (%s, %s)", "HSP-1", "HSP-123");
        SearchRequestClient client = new SearchRequestClient(this.getEnvironmentData());
        ClientResponse withValidationResponse = client.get(jql, true);
        Assert.assertThat((Object)withValidationResponse.getStatus(), (Matcher)CoreMatchers.equalTo((Object)400));
        withValidationResponse.close();
        ClientResponse noValidationResponse = client.get(jql, false);
        Assert.assertThat((Object)noValidationResponse.getStatus(), (Matcher)CoreMatchers.equalTo((Object)200));
        Document responseXml = this.parseResponseXml(noValidationResponse);
        Assert.assertThat((Object)responseXml, TestSearchValidationCanBeDisabled.containsIssueWithKey("HSP-1"));
        Assert.assertThat((Object)responseXml, (Matcher)Matchers.not(TestSearchValidationCanBeDisabled.containsIssueWithKey("HSP-123")));
    }

    private Document parseResponseXml(ClientResponse response) {
        InputStream is = response.getEntityInputStream();
        try {
            is.reset();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            return document;
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing XML", e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    protected boolean isDumpHTML() {
        return false;
    }

    static Matcher<Document> containsIssueWithKey(String issueKey) {
        return new ContainsIssueWithKeyMatcher(issueKey);
    }

    private class SearchRequestClient
    extends RestApiClient<SearchRequestClient> {
        public SearchRequestClient(com.atlassian.jira.webtests.util.JIRAEnvironmentData environmentData) {
            super((JIRAEnvironmentData)environmentData);
        }

        public ClientResponse get(String jql, boolean validateQuery) {
            WebResource resource = this.resourceRoot(this.getEnvironmentData().getBaseUrl().toExternalForm()).path("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml").queryParam("tempMax", "1000").queryParam("jqlQuery", jql).queryParam("validateQuery", String.valueOf(validateQuery));
            return (ClientResponse)resource.get(ClientResponse.class);
        }
    }

    private static class ContainsIssueWithKeyMatcher
    extends TypeSafeMatcher<Document> {
        private final String issueKey;

        public ContainsIssueWithKeyMatcher(String issueKey) {
            this.issueKey = issueKey;
        }

        protected boolean matchesSafely(Document doc) {
            try {
                XPathFactory xPathfactory = XPathFactory.newInstance();
                XPath xpath = xPathfactory.newXPath();
                XPathExpression expr = xpath.compile(String.format("/rss/channel/item/key[contains(text(), '%s')]", this.issueKey));
                return this.issueKey.equals(expr.evaluate(doc));
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing XML", e);
            }
        }

        public void describeTo(Description description) {
            description.appendText("a response containing ").appendValue((Object)"HSP-1");
        }
    }
}

