/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import com.meterware.httpunit.HttpUnitOptions;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
public class TestSearchRequestURLsInvalidParameters
extends FuncTestCase {
    private static final String QUERY = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?tempMax=1000&";

    @Override
    public void setUpTest() {
        this.administration.restoreData("TestSearchRequestURLsInvalidParameters.xml");
    }

    @Override
    protected void setUpHttpUnitOptions() {
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        super.setUpHttpUnitOptions();
    }

    public void testEverySingleField() {
        this.assertErrorResponse(this.affectedVersion());
        this.assertErrorResponse(this.text());
        this.assertErrorResponse(this.component());
        this.assertErrorResponse(this.created());
        this.assertErrorResponse(this.dueDate());
        this.assertErrorResponse(this.updated());
        this.assertErrorResponse(this.resolutionDate());
        this.assertErrorResponse(this.fixVersion());
        this.assertErrorResponse(this.priority());
        this.assertErrorResponse(this.project());
        this.assertErrorResponse(this.resolution());
        this.assertErrorResponse(this.status());
        this.assertErrorResponse(this.type());
        this.assertErrorResponse(this.workRatio());
        this.assertErrorResponse(this.datePicker());
        this.assertErrorResponse(this.dateTime());
        this.assertErrorResponse(this.freeTextField());
        this.assertErrorResponse(this.readOnlyTextField());
        this.assertErrorResponse(this.textField());
        this.assertErrorResponse(this.groupPicker());
        this.assertErrorResponse(this.importIdExactSearcher());
        this.assertErrorResponse(this.importIdRangeSearcher());
        this.assertErrorResponse(this.cascadingSelect());
        this.assertErrorResponse(this.numberFieldExactSearcher());
        this.assertErrorResponse(this.numberFieldRangeSearcher());
        this.assertErrorResponse(this.singleVersionPicker());
        this.assertErrorResponse(this.versionPicker());
        this.assertErrorResponse(this.projectPicker());
        this.assertErrorResponse(this.multiGroupPicker());
        this.assertErrorResponse(this.multiCheckboxes());
        this.assertErrorResponse(this.multiSelect());
        this.assertErrorResponse(this.selectList());
        this.assertErrorResponse(this.radioButton());
    }

    public void testEverySingleWarningField() {
        this.assertWarningResponse(this.assignee());
        this.assertWarningResponse(this.reporter());
        this.assertWarningResponse(this.userPicker());
        this.assertWarningResponse(this.multiUserPicker());
    }

    private List<Scenario> affectedVersion() {
        return ImmutableList.of((Object)new Scenario("version=yes", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("affectedVersion", "yes")), (Object)new Scenario("version=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("affectedVersion", "50000")), (Object)new Scenario("version=10011&version=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("affectedVersion", "50000")));
    }

    private List<Scenario> assignee() {
        return this.buildUserScenarios("assignee", "assignee");
    }

    private List<Scenario> text() {
        return this.buildSystemTextScenario("text");
    }

    private List<Scenario> component() {
        return ImmutableList.of((Object)new Scenario("component=yes", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("component", "yes")), (Object)new Scenario("component=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("component", "50000")), (Object)new Scenario("component=component&component=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("component", "50000")));
    }

    private List<Scenario> created() {
        return this.buildDateScenarios("created");
    }

    private List<Scenario> dueDate() {
        return this.buildRelativeDateScenarios("duedate", "due");
    }

    private List<Scenario> updated() {
        return this.buildDateScenarios("updated");
    }

    private List<Scenario> resolutionDate() {
        return this.buildDateScenarios("resolutiondate", "resolved");
    }

    private List<Scenario> fixVersion() {
        return ImmutableList.of((Object)new Scenario("fixfor=yes", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("fixVersion", "yes")), (Object)new Scenario("fixfor=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("fixVersion", "50000")), (Object)new Scenario("fixfor=10011&fixfor=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("fixVersion", "50000")));
    }

    private List<Scenario> priority() {
        return this.buildIdScenarios("priority", "priority", "1");
    }

    private List<Scenario> project() {
        return this.buildIdScenarios("pid", "project", "10010");
    }

    private List<Scenario> resolution() {
        return this.buildIdScenarios("resolution", "resolution", "1");
    }

    private List<Scenario> status() {
        return this.buildIdScenarios("status", "status", "1");
    }

    private List<Scenario> type() {
        return this.buildIdScenarios("type", "issuetype", "1");
    }

    private List<Scenario> reporter() {
        return this.buildUserScenarios("reporter", "reporter");
    }

    private List<Scenario> workRatio() {
        String field = "workratio";
        return ImmutableList.of((Object)new Scenario("workratio:min=20&workratio:max=baddate", ErrorType.REQUIRES_INTEGER.formatError("workratio", "baddate")), (Object)new Scenario("workratio:min=baddate", ErrorType.REQUIRES_INTEGER.formatError("workratio", "baddate")), (Object)new Scenario("workratio:max=baddate", ErrorType.REQUIRES_INTEGER.formatError("workratio", "baddate")), (Object)new Scenario("workratio:max=20&workratio:min=baddate", ErrorType.REQUIRES_INTEGER.formatError("workratio", "baddate")));
    }

    private List<Scenario> datePicker() {
        return this.buildRelativeDateScenarios("customfield_10001", "DP");
    }

    private List<Scenario> dateTime() {
        String urlParam = "customfield_10002";
        String field = "DT";
        return ImmutableList.of((Object)new Scenario("customfield_10002:before=baddate", ErrorType.INVALID_DATE.formatError("DT", "baddate")), (Object)new Scenario("customfield_10002:after=baddate", ErrorType.INVALID_DATE.formatError("DT", "baddate")), (Object)new Scenario("customfield_10002:previous=HHH", ErrorType.INVALID_DATE.formatError("DT", "HHH")), (Object)new Scenario("customfield_10002:next=HHH", ErrorType.INVALID_DATE.formatError("DT", "HHH")), (Object)new Scenario("customfield_10002:before=11/May/08+11:34+AM&customfield_10002:after=baddate", ErrorType.INVALID_DATE.formatError("DT", "baddate")), (Object)new Scenario("customfield_10002:previous=1h&customfield_10002:next=HHH", ErrorType.INVALID_DATE.formatError("DT", "HHH")));
    }

    private List<Scenario> freeTextField() {
        return this.buildTextScenario("customfield_10003", "FTF");
    }

    private List<Scenario> readOnlyTextField() {
        return this.buildTextScenario("customfield_10013", "ROTF");
    }

    private List<Scenario> textField() {
        return this.buildTextScenario("customfield_10016", "TF");
    }

    private List<Scenario> groupPicker() {
        String urlParam = "customfield_10004";
        String field = "GP";
        return ImmutableList.of((Object)new Scenario("customfield_10004=1", ErrorType.GROUP_DOESNT_EXIST.formatError("GP", "1")));
    }

    private List<Scenario> importIdExactSearcher() {
        String urlParam = "customfield_10005";
        String field = "II exact";
        return this.buildExactNumberScenarios("customfield_10005", "II exact");
    }

    private List<Scenario> importIdRangeSearcher() {
        String urlParam = "customfield_10020";
        String field = "II range";
        return this.buildRangeNumberScenarios("customfield_10020", "II range");
    }

    private List<Scenario> cascadingSelect() {
        String urlParam = "customfield_10000";
        String field = "CSF";
        return ImmutableList.of((Object)new Scenario("customfield_10000=10010&customfield_10000:1=invalid", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "invalid")), (Object)new Scenario("customfield_10000=yes", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "yes")), (Object)new Scenario("customfield_10000=20", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "20")), (Object)new Scenario("customfield_10000:1=yes", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "yes")), (Object)new Scenario("customfield_10000:1=20", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "20")));
    }

    private List<Scenario> numberFieldExactSearcher() {
        return this.buildExactNumberScenarios("customfield_10010", "NF exact");
    }

    private List<Scenario> numberFieldRangeSearcher() {
        return this.buildRangeNumberScenarios("customfield_10021", "NF range");
    }

    private List<Scenario> userPicker() {
        return this.buildUserScenarios("customfield_10018", "UP");
    }

    private List<Scenario> singleVersionPicker() {
        return ImmutableList.of((Object)new Scenario("customfield_10015=yes", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("SVP", "yes")), (Object)new Scenario("customfield_10015=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("SVP", "50000")), (Object)new Scenario("customfield_10015=10011&customfield_10015=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("SVP", "50000")));
    }

    private List<Scenario> versionPicker() {
        return ImmutableList.of((Object)new Scenario("customfield_10019=yes", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("VP", "yes")), (Object)new Scenario("customfield_10019=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("VP", "50000")), (Object)new Scenario("customfield_10019=10011&customfield_10019=50000", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("VP", "50000")));
    }

    private List<Scenario> projectPicker() {
        String urlName = "customfield_10011";
        String field = "PP";
        return ImmutableList.of((Object)new Scenario("customfield_10011=yes", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("PP", "yes")), (Object)new Scenario("customfield_10011=50000", ErrorType.NUMBER_VALUE_DOESNT_EXIST.formatError("PP", "50000")));
    }

    private List<Scenario> multiGroupPicker() {
        String urlParam = "customfield_10007";
        String field = "MGP";
        return ImmutableList.of((Object)new Scenario("customfield_10007=1", ErrorType.GROUP_DOESNT_EXIST.formatError("MGP", "1")));
    }

    private List<Scenario> multiUserPicker() {
        return this.buildUserScenarios("customfield_10009", "MUP");
    }

    private List<Scenario> multiCheckboxes() {
        String urlParam = "customfield_10006";
        String field = "MC";
        return ImmutableList.of((Object)new Scenario("customfield_10006=1", ErrorType.OPTION_DOESNT_EXIST.formatError("MC", "1")), (Object)new Scenario("customfield_10006=opt1&customfield_10006=1", ErrorType.OPTION_DOESNT_EXIST.formatError("MC", "1")));
    }

    private List<Scenario> multiSelect() {
        String urlParam = "customfield_10008";
        String field = "MS";
        return ImmutableList.of((Object)new Scenario("customfield_10008=1", ErrorType.OPTION_DOESNT_EXIST.formatError("MS", "1")), (Object)new Scenario("customfield_10008=select1&customfield_10008=1", ErrorType.OPTION_DOESNT_EXIST.formatError("MS", "1")));
    }

    private List<Scenario> selectList() {
        String urlParam = "customfield_10014";
        String field = "SL";
        return ImmutableList.of((Object)new Scenario("customfield_10014=1", ErrorType.OPTION_DOESNT_EXIST.formatError("SL", "1")));
    }

    private List<Scenario> radioButton() {
        String urlParam = "customfield_10012";
        String field = "RB";
        return ImmutableList.of((Object)new Scenario("customfield_10012=1", ErrorType.OPTION_DOESNT_EXIST.formatError("RB", "1")));
    }

    private List<Scenario> buildUserScenarios(String urlParam, String field) {
        return ImmutableList.of((Object)new Scenario(urlParam + "=1", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError(field, "1")));
    }

    private List<Scenario> buildSystemTextScenario(String field) {
        return this.buildTextScenario("text", field);
    }

    private List<Scenario> buildTextScenario(String urlParam, String field) {
        return ImmutableList.of((Object)new Scenario(urlParam + "=%3Fbadtextquery", ErrorType.WILDCARD_CANNOT_START_WITH_STAR_OR_QUESTIONMARK.formatError(field, "?badtextquery")), (Object)new Scenario(urlParam + "=*badtextquery", ErrorType.WILDCARD_CANNOT_START_WITH_STAR_OR_QUESTIONMARK.formatError(field, "*badtextquery")));
    }

    private List<Scenario> buildDateScenarios(String field) {
        return this.buildDateScenarios(field, field);
    }

    private List<Scenario> buildRelativeDateScenarios(String urlParam, String field) {
        return ImmutableList.of((Object)new Scenario(urlParam + ":before=baddate", ErrorType.INVALID_RELATIVE_DATE.formatError(field, "baddate")), (Object)new Scenario(urlParam + ":after=baddate", ErrorType.INVALID_RELATIVE_DATE.formatError(field, "baddate")), (Object)new Scenario(urlParam + ":previous=HHH", ErrorType.INVALID_RELATIVE_DATE.formatError(field, "HHH")), (Object)new Scenario(urlParam + ":next=HHH", ErrorType.INVALID_RELATIVE_DATE.formatError(field, "HHH")), (Object)new Scenario(urlParam + ":equals=HHH", ErrorType.INVALID_RELATIVE_DATE.formatError(field, "HHH")), (Object)new Scenario(urlParam + ":before=11/May/08&" + urlParam + ":after=baddate", ErrorType.INVALID_RELATIVE_DATE.formatError(field, "baddate")), (Object)new Scenario(urlParam + ":previous=1h&" + urlParam + ":next=HHH", ErrorType.INVALID_RELATIVE_DATE.formatError(field, "HHH")));
    }

    private List<Scenario> buildDateScenarios(String urlParam, String field) {
        return ImmutableList.of((Object)new Scenario(urlParam + ":before=baddate", ErrorType.INVALID_DATE.formatError(field, "baddate")), (Object)new Scenario(urlParam + ":after=baddate", ErrorType.INVALID_DATE.formatError(field, "baddate")), (Object)new Scenario(urlParam + ":previous=HHH", ErrorType.INVALID_DATE.formatError(field, "HHH")), (Object)new Scenario(urlParam + ":next=HHH", ErrorType.INVALID_DATE.formatError(field, "HHH")), (Object)new Scenario(urlParam + ":before=11/May/08&" + urlParam + ":after=baddate", ErrorType.INVALID_DATE.formatError(field, "baddate")), (Object)new Scenario(urlParam + ":previous=1h&" + urlParam + ":next=HHH", ErrorType.INVALID_DATE.formatError(field, "HHH")));
    }

    private List<Scenario> buildIdScenarios(String urlName, String field, String validId) {
        return ImmutableList.of((Object)new Scenario(urlName + "=yes", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError(field, "yes")), (Object)new Scenario(urlName + "=50000", ErrorType.NUMBER_VALUE_DOESNT_EXIST.formatError(field, "50000")), (Object)new Scenario(urlName + "=" + validId + "&" + urlName + "=50000", ErrorType.NUMBER_VALUE_DOESNT_EXIST.formatError(field, "50000")));
    }

    private List<Scenario> buildExactNumberScenarios(String urlParam, String field) {
        return ImmutableList.of((Object)new Scenario(urlParam + "=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber")));
    }

    private List<Scenario> buildRangeNumberScenarios(String urlParam, String field) {
        return ImmutableList.of((Object)new Scenario(urlParam + ":greaterThan=20&" + urlParam + ":lessThan=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber")), (Object)new Scenario(urlParam + ":greaterThan=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber")), (Object)new Scenario(urlParam + ":lessThan=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber")), (Object)new Scenario(urlParam + ":lessThan=20&" + urlParam + ":greaterThan=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber")));
    }

    private void assertErrorResponse(List<Scenario> scenarios) {
        for (Scenario scenario : scenarios) {
            this.log(QUERY + scenario.urlParams);
            this.tester.gotoPage(QUERY + scenario.urlParams);
            TestSearchRequestURLsInvalidParameters.assertEquals((int)400, (int)this.tester.getDialog().getResponse().getResponseCode());
            this.assertions.html().assertResponseContains(this.tester, scenario.msg);
        }
    }

    private void assertWarningResponse(List<Scenario> scenarios) {
        for (Scenario scenario : scenarios) {
            this.log(QUERY + scenario.urlParams);
            this.tester.gotoPage(QUERY + scenario.urlParams);
            TestSearchRequestURLsInvalidParameters.assertEquals((int)200, (int)this.tester.getDialog().getResponse().getResponseCode());
        }
    }

    private static enum ErrorType {
        TEXT_START_CHAR{

            @Override
            String formatError(String fieldName, String value) {
                return String.format("The text query '%s' for field '%s' is not allowed to start with ", value, fieldName);
            }
        }
        ,
        WILDCARD_CANNOT_START_WITH_STAR_OR_QUESTIONMARK{

            @Override
            String formatError(String fieldName, String operand) {
                return String.format("The text query '%s' for field '%s' is not valid: the '*' and '?' are not allowed as first character in wildcard query.", operand, fieldName);
            }
        }
        ,
        INVALID_DATE{

            @Override
            String formatError(String fieldName, String value) {
                return String.format("Date value '%s' for field '%s' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'.", value, fieldName);
            }
        }
        ,
        INVALID_RELATIVE_DATE{

            @Override
            String formatError(String fieldName, String value) {
                return String.format("Date value '%s' for field '%s' is invalid. Valid formats include: 'YYYY/MM/DD', 'YYYY-MM-DD', or a period format e.g. '-5d', '4w 2d'.", value, fieldName);
            }
        }
        ,
        GROUP_DOESNT_EXIST{

            @Override
            String formatError(String fieldName, String value) {
                return String.format("The group '%s' for field '%s' does not exist.", value, fieldName);
            }
        }
        ,
        STRING_VALUE_DOESNT_EXIST{

            @Override
            String formatError(String fieldName, String value) {
                return String.format("The value '%s' does not exist for the field '%s'.", value, fieldName);
            }
        }
        ,
        NUMBER_VALUE_DOESNT_EXIST{

            @Override
            String formatError(String fieldName, String value) {
                return String.format("A value with ID '%s' does not exist for the field '%s'.", value, fieldName);
            }
        }
        ,
        REQUIRES_INTEGER{

            @Override
            String formatError(String fieldName, String value) {
                return String.format("The value '%s' for field '%s' is invalid - please specify an integer.", value, fieldName);
            }
        }
        ,
        REQUIRES_NUMBER{

            @Override
            String formatError(String fieldName, String value) {
                return String.format("Value '%s' for the '%s' field is not a valid number.", value, fieldName);
            }
        }
        ,
        OPTION_DOESNT_EXIST{

            @Override
            String formatError(String fieldName, String value) {
                return String.format("The option '%s' for field '%s' does not exist.", value, fieldName);
            }
        };


        abstract String formatError(String var1, String var2);
    }

    private static class Scenario {
        private final String urlParams;
        private final String msg;

        private Scenario(String urlParams, String msg) {
            this.urlParams = urlParams;
            this.msg = msg;
        }
    }
}

